/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.datasource.config;

import java.util.ArrayList;
import java.util.Collection;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.semanticdesktop.aperture.datasource.config.SubstringCondition;
import org.semanticdesktop.aperture.datasource.config.UrlPattern;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.vocabulary.DATASOURCE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstringPattern
extends UrlPattern {
    private String substring;
    private SubstringCondition condition;

    public SubstringPattern(String substring, SubstringCondition condition) {
        this.substring = substring;
        this.condition = condition;
    }

    public String getSubstring() {
        return this.substring;
    }

    public void setSubstring(String substring) {
        this.substring = substring;
    }

    public SubstringCondition getCondition() {
        return this.condition;
    }

    public void setCondition(SubstringCondition condition) {
        this.condition = condition;
    }

    @Override
    public boolean matches(String url) {
        return this.condition.test(url, this.substring);
    }

    @Override
    public Collection<Statement> getStatements(Model model, Resource subject) {
        ArrayList<Statement> result = new ArrayList<Statement>();
        result.add(ModelUtil.createStatement(model, subject, RDF.type, DATASOURCE.SubstringPattern));
        try {
            result.add(ModelUtil.createStatement(model, subject, RDF.value, ModelUtil.createLiteral(model, this.substring, XSD._string)));
        }
        catch (ModelException e) {
            throw new RuntimeException(e);
        }
        result.add(ModelUtil.createStatement(model, subject, DATASOURCE.condition, this.condition.toNode()));
        return result;
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = this == obj;
        if (!result && obj instanceof SubstringPattern) {
            SubstringPattern other = (SubstringPattern)obj;
            result = this.getSubstring().equals(other.getSubstring()) && this.getCondition().equals(other.getCondition());
        }
        return result;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

