/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.datasource.config;

import org.ontoware.rdf2go.model.node.Node;
import org.semanticdesktop.aperture.vocabulary.DATASOURCE;

public abstract class SubstringCondition {
    public static final StartsWith STARTS_WITH = new StartsWith();
    public static final EndsWith ENDS_WITH = new EndsWith();
    public static final Contains CONTAINS = new Contains();
    public static final DoesNotContain DOES_NOT_CONTAIN = new DoesNotContain();

    public abstract boolean test(String var1, String var2);

    public abstract Node toNode();

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = this == obj;
        if (!result && obj instanceof SubstringCondition) {
            SubstringCondition other = (SubstringCondition)obj;
            result = this.toString().equals(other.toString());
        }
        return result;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static class DoesNotContain
    extends SubstringCondition {
        public String toString() {
            return "DoesNotContain";
        }

        public boolean test(String string, String substring) {
            return string.indexOf(substring) < 0;
        }

        public Node toNode() {
            return DATASOURCE.DOES_NOT_CONTAIN;
        }
    }

    public static class Contains
    extends SubstringCondition {
        public String toString() {
            return "Contains";
        }

        public boolean test(String string, String substring) {
            return string.indexOf(substring) >= 0;
        }

        public Node toNode() {
            return DATASOURCE.CONTAINS;
        }
    }

    public static class EndsWith
    extends SubstringCondition {
        public String toString() {
            return "EndsWith";
        }

        public boolean test(String string, String substring) {
            return string.endsWith(substring);
        }

        public Node toNode() {
            return DATASOURCE.ENDS_WITH;
        }
    }

    public static class StartsWith
    extends SubstringCondition {
        public String toString() {
            return "StartsWith";
        }

        public boolean test(String string, String substring) {
            return string.startsWith(substring);
        }

        public Node toNode() {
            return DATASOURCE.STARTS_WITH;
        }
    }
}

