/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.datasource.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.semanticdesktop.aperture.datasource.config.UrlPattern;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.vocabulary.DATASOURCE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegExpPattern
extends UrlPattern {
    private Pattern pattern;

    public RegExpPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public RegExpPattern(String pattern) {
        this(Pattern.compile(pattern));
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getPatternString() {
        return this.pattern.pattern();
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    @Override
    public boolean matches(String url) {
        return this.pattern.matcher(url).matches();
    }

    @Override
    public Collection<Statement> getStatements(Model model, Resource subject) {
        ArrayList<Statement> result = new ArrayList<Statement>();
        result.add(ModelUtil.createStatement(model, subject, RDF.type, DATASOURCE.RegExpPattern));
        try {
            result.add(ModelUtil.createStatement(model, subject, RDF.value, ModelUtil.createLiteral(model, this.getPatternString(), XSD._string)));
        }
        catch (ModelException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = this == obj;
        if (!result && obj instanceof RegExpPattern) {
            RegExpPattern other = (RegExpPattern)obj;
            result = this.getPatternString().equals(other.getPatternString());
        }
        return result;
    }

    public int hashCode() {
        return this.getPatternString().hashCode();
    }
}

