/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.datasource.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.BlankNode;
import org.ontoware.rdf2go.model.node.Literal;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.datasource.config.DomainBoundaries;
import org.semanticdesktop.aperture.datasource.config.RegExpPattern;
import org.semanticdesktop.aperture.datasource.config.SubstringCondition;
import org.semanticdesktop.aperture.datasource.config.SubstringPattern;
import org.semanticdesktop.aperture.datasource.config.UrlPattern;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.vocabulary.DATASOURCE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationUtil {
    private static final URI IcalDataSource = new URIImpl("http://aperture.semanticdesktop.org/ontology/2007/08/12/icalds#IcalDataSource");
    private static final URI ical_rootUrl = new URIImpl("http://aperture.semanticdesktop.org/ontology/2007/08/12/icalds#rootUrl");

    private ConfigurationUtil() {
    }

    public static void setName(String name, RDFContainer configuration) {
        configuration.put(DATASOURCE.dataSourceName, name);
    }

    public static String getName(RDFContainer configuration) {
        return configuration.getString(DATASOURCE.dataSourceName);
    }

    public static void setUsername(String username, RDFContainer configuration) {
        configuration.put(DATASOURCE.username, username);
    }

    public static String getUsername(RDFContainer configuration) {
        return configuration.getString(DATASOURCE.username);
    }

    public static void setPassword(String password, RDFContainer configuration) {
        configuration.put(DATASOURCE.password, password);
    }

    public static String getPassword(RDFContainer configuration) {
        return configuration.getString(DATASOURCE.password);
    }

    public static void setDomainBoundaries(DomainBoundaries boundaries, RDFContainer configuration) {
        URI id = configuration.getDescribedUri();
        Model model = configuration.getModel();
        try {
            ConfigurationUtil.deletePatternStatements(id, DATASOURCE.includePattern, model);
            ConfigurationUtil.deletePatternStatements(id, DATASOURCE.excludePattern, model);
            if (boundaries != null) {
                ConfigurationUtil.addPatternStatements(id, boundaries.getIncludePatterns(), DATASOURCE.includePattern, model);
                ConfigurationUtil.addPatternStatements(id, boundaries.getExcludePatterns(), DATASOURCE.excludePattern, model);
            }
        }
        catch (ModelException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deletePatternStatements(URI id, URI predicate, Model model) throws ModelException {
        ClosableIterator iterator = null;
        try {
            LinkedList<Statement> statementsToRemove = new LinkedList<Statement>();
            iterator = model.findStatements(id, predicate, Variable.ANY);
            while (iterator.hasNext()) {
                Statement mainStatement = (Statement)iterator.next();
                Node object = mainStatement.getObject();
                if (!(object instanceof Resource)) continue;
                Resource objectResource = (Resource)object;
                List<Statement> types = ConfigurationUtil.findStatements(objectResource, RDF.type, model);
                List<Statement> values = ConfigurationUtil.findStatements(objectResource, RDF.value, model);
                List<Statement> conditions = ConfigurationUtil.findStatements(objectResource, DATASOURCE.condition, model);
                if (types.size() <= 0 || values.size() <= 0) continue;
                statementsToRemove.add(mainStatement);
                statementsToRemove.addAll(types);
                statementsToRemove.addAll(values);
                statementsToRemove.addAll(conditions);
            }
            model.removeAll(statementsToRemove.iterator());
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Statement> findStatements(Resource resource, URI predicate, Model model) throws ModelException {
        LinkedList<Statement> result = new LinkedList<Statement>();
        ClosableIterator iterator = null;
        try {
            iterator = model.findStatements(resource, predicate, Variable.ANY);
            while (iterator.hasNext()) {
                result.add((Statement)iterator.next());
            }
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
        return result;
    }

    private static void addPatternStatements(URI sourceID, List patterns, URI predicate, Model model) throws ModelException {
        for (UrlPattern pattern : patterns) {
            BlankNode patternResource = model.createBlankNode();
            model.addStatement(ModelUtil.createStatement(model, sourceID, predicate, patternResource));
            Collection<Statement> collection = pattern.getStatements(model, patternResource);
            model.addAll(collection.iterator());
        }
    }

    public static DomainBoundaries getDomainBoundaries(RDFContainer configuration) {
        URI id = configuration.getDescribedUri();
        Model model = configuration.getModel();
        List<UrlPattern> includePatterns = ConfigurationUtil.getPatterns(id, DATASOURCE.includePattern, model);
        List<UrlPattern> excludePatterns = ConfigurationUtil.getPatterns(id, DATASOURCE.excludePattern, model);
        return new DomainBoundaries(includePatterns, excludePatterns);
    }

    private static List<UrlPattern> getPatterns(URI id, URI predicate, Model model) {
        ClosableIterator statements = null;
        ArrayList<UrlPattern> result = new ArrayList<UrlPattern>();
        try {
            statements = model.findStatements(id, predicate, Variable.ANY);
            while (statements.hasNext()) {
                Node conditionValue;
                SubstringCondition condition;
                Statement statement = (Statement)statements.next();
                Node value = statement.getObject();
                if (!(value instanceof Resource)) continue;
                Resource patternResource = (Resource)value;
                Node typeValue = ConfigurationUtil.getSingleValue(patternResource, RDF.type, model);
                Node patternValue = ConfigurationUtil.getSingleValue(patternResource, RDF.value, model);
                if (!(typeValue instanceof URI) || !(patternValue instanceof Literal)) continue;
                String patternString = ((Literal)patternValue).getValue();
                if (DATASOURCE.RegExpPattern.equals(typeValue)) {
                    result.add(new RegExpPattern(patternString));
                    continue;
                }
                if (!DATASOURCE.SubstringPattern.equals(typeValue) || (condition = ConfigurationUtil.resolveCondition(conditionValue = ConfigurationUtil.getSingleValue(patternResource, DATASOURCE.condition, model))) == null) continue;
                result.add(new SubstringPattern(patternString, condition));
            }
        }
        catch (ModelException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (statements != null) {
                statements.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node getSingleValue(Resource resource, URI predicate, Model model) throws ModelException {
        ClosableIterator statements = null;
        Node result = null;
        try {
            statements = model.findStatements(resource, predicate, Variable.ANY);
            if (statements.hasNext()) {
                Statement statement = (Statement)statements.next();
                result = statement.getObject();
            }
        }
        finally {
            if (statements != null) {
                statements.close();
            }
        }
        return result;
    }

    public static SubstringCondition resolveCondition(Node value) {
        String comp = value.toString();
        if (DATASOURCE.STARTS_WITH.toString().equals(comp)) {
            return new SubstringCondition.StartsWith();
        }
        if (DATASOURCE.ENDS_WITH.toString().equals(comp)) {
            return new SubstringCondition.EndsWith();
        }
        if (DATASOURCE.CONTAINS.toString().equals(comp)) {
            return new SubstringCondition.Contains();
        }
        if (DATASOURCE.DOES_NOT_CONTAIN.toString().equals(comp)) {
            return new SubstringCondition.DoesNotContain();
        }
        return null;
    }
}

