/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.datasource.bundle;

import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.semanticdesktop.aperture.datasource.DataSourceFactory;
import org.semanticdesktop.aperture.datasource.DataSourceRegistry;
import org.semanticdesktop.aperture.datasource.impl.DataSourceRegistryImpl;

public class DataSourceServiceActivator
implements BundleActivator,
ServiceListener {
    public BundleContext bc = null;
    private ServiceRegistration registration;
    private DataSourceRegistry registry;

    public void start(BundleContext context) throws Exception {
        this.bc = context;
        this.registry = new DataSourceRegistryImpl();
        this.registration = this.bc.registerService(DataSourceRegistry.class.getName(), (Object)this.registry, new Hashtable());
        String filter = "(objectclass=" + DataSourceFactory.class.getName() + ")";
        this.bc.addServiceListener((ServiceListener)this, filter);
        ServiceReference[] references = this.bc.getServiceReferences(null, filter);
        for (int i = 0; references != null && i < references.length; ++i) {
            this.serviceChanged(new ServiceEvent(1, references[i]));
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.bc.removeServiceListener((ServiceListener)this);
        this.registration.unregister();
        this.bc = null;
    }

    public void serviceChanged(ServiceEvent event) {
        if (this.bc == null) {
            return;
        }
        switch (event.getType()) {
            case 1: {
                DataSourceFactory factory = (DataSourceFactory)this.bc.getService(event.getServiceReference());
                this.registry.add(factory);
                break;
            }
            case 2: {
                DataSourceFactory factory = (DataSourceFactory)this.bc.getService(event.getServiceReference());
                this.registry.remove(factory);
                this.registry.add(factory);
                break;
            }
            case 4: {
                DataSourceFactory factory = (DataSourceFactory)this.bc.getService(event.getServiceReference());
                this.registry.remove(factory);
            }
        }
    }
}

