/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.datasource.base;

import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.DATASOURCE;

public abstract class DataSourceBase
implements DataSource {
    private RDFContainer configuration;

    public DataSourceBase() {
    }

    public DataSourceBase(RDFContainer configuration) {
        this.configuration = configuration;
    }

    public URI getID() {
        return this.configuration.getDescribedUri();
    }

    public String getName() {
        return this.configuration.getString(DATASOURCE.dataSourceName);
    }

    public void setName(String name) {
        this.configuration.put(DATASOURCE.dataSourceName, name);
    }

    public String getComment() {
        return this.configuration.getString(DATASOURCE.dataSourceComment);
    }

    public void setComment(String comment) {
        this.configuration.put(DATASOURCE.dataSourceComment, comment);
    }

    public Integer getTimeout() {
        return this.configuration.getInteger(DATASOURCE.timeout);
    }

    public void setTimeout(int timeout) {
        this.configuration.put(DATASOURCE.timeout, timeout);
    }

    public RDFContainer getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(RDFContainer configuration) {
        this.configuration = configuration;
        configuration.put(RDF.type, this.getType());
    }

    public void dispose() {
        this.configuration.dispose();
    }
}

