/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.samba;

import java.io.BufferedInputStream;
import java.io.IOException;
import jcifs.smb.SmbFile;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.accessor.base.FileDataObjectBase;
import org.semanticdesktop.aperture.accessor.base.FolderDataObjectBase;
import org.semanticdesktop.aperture.crawler.ExitCode;
import org.semanticdesktop.aperture.crawler.base.CrawlerBase;
import org.semanticdesktop.aperture.crawler.samba.SambaDataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.HttpClientUtil;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;

public class SambaCrawler
extends CrawlerBase {
    private String domain;
    private String username;
    private String password;
    private String server;
    private String port;
    private String share;
    private String path;

    protected ExitCode crawlObjects() {
        this.readConfigurationOptionsFromDataSource();
        try {
            String rootFolderUri = SambaCrawler.generateUrl(this.domain, this.username, this.password, this.server, this.port, this.share, this.path);
            SmbFile file = new SmbFile(rootFolderUri);
            this.crawlFolderTree(file);
        }
        catch (Exception e) {
            return this.reportFatalErrorCause(e);
        }
        return ExitCode.COMPLETED;
    }

    private void crawlFolderTree(SmbFile file) throws IOException {
        SmbFile[] files;
        if (file.getName().equals("IPC$/")) {
            return;
        }
        this.crawlSingleSmbFile(file);
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (SmbFile sFile : files) {
                this.crawlFolderTree(sFile);
            }
        }
    }

    private void crawlSingleSmbFile(SmbFile file) throws IOException {
        DataObjectBase object;
        String registeredLastModifiedDate;
        String url = file.getURL().toString();
        URIImpl uri = new URIImpl(url);
        RDFContainer container = this.getRDFContainerFactory(url).getRDFContainer(uri);
        this.addStringProperty(container, NFO.fileName, file.getName());
        long lastModified = file.getLastModified();
        container.add(NFO.fileLastModified, lastModified);
        try {
            URIImpl parentUri = new URIImpl(file.getParent());
            container.add(NIE.isPartOf, parentUri);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.accessData != null && (registeredLastModifiedDate = this.accessData.get(url, "date")) != null && registeredLastModifiedDate.equals(String.valueOf(lastModified))) {
            this.reportUnmodifiedDataObject(url);
            return;
        }
        if (file.isFile()) {
            container.add(NFO.fileSize, file.length());
            object = new FileDataObjectBase((URI)uri, this.source, container, new BufferedInputStream(file.getInputStream()));
            if (this.accessData != null) {
                this.accessData.put(url, "date", String.valueOf(lastModified));
            }
            this.reportNewDataObject(object);
        } else {
            object = new FolderDataObjectBase(uri, this.source, container);
            if (this.accessData != null) {
                this.accessData.put(url, "date", String.valueOf(lastModified));
            }
            this.reportNewDataObject(object);
        }
    }

    private void addStringProperty(RDFContainer container, URI filename, String name) {
        if (name != null && name.trim().length() > 0) {
            container.add(filename, name.trim());
        }
    }

    private void readConfigurationOptionsFromDataSource() {
        SambaDataSource src = (SambaDataSource)this.source;
        this.domain = src.getDomain();
        this.server = src.getServer();
        this.username = src.getUsername();
        this.password = src.getPassword();
        this.port = src.getPort() != null ? src.getPort().toString() : null;
        this.share = src.getShare();
        this.path = src.getPath();
    }

    public static String generateUrl(String domain, String username, String password, String server, String port, String share, String path) {
        StringBuilder bldr = new StringBuilder();
        if (server == null) {
            throw new IllegalArgumentException("Server is obligatory");
        }
        bldr.append("smb://");
        if (username != null) {
            if (domain != null) {
                bldr.append(SambaCrawler.encodeSmbSrvName(domain) + ";");
            }
            bldr.append(SambaCrawler.encodeUserinfoNosem(username));
            if (password != null) {
                bldr.append(":" + SambaCrawler.encodeUserinfoNosem(password));
            }
            bldr.append("@");
        }
        bldr.append(server);
        if (port != null) {
            bldr.append(":" + port);
        }
        bldr.append("/");
        if (share != null) {
            bldr.append(SambaCrawler.encodeAbsolutePath(share) + "/");
        }
        if (path != null) {
            bldr.append(SambaCrawler.encodeAbsolutePath(path));
        }
        return bldr.toString();
    }

    private static String encodeSmbSrvName(String st) {
        return HttpClientUtil.formUrlEncode(st, "-_~!$&'()+,;=");
    }

    private static String encodeAbsolutePath(String st) {
        return HttpClientUtil.formUrlEncode(st, ":@!$&'()*+,;=/");
    }

    private static String encodeUserinfoNosem(String st) {
        return HttpClientUtil.formUrlEncode(st, "!$&'()*+,=:");
    }
}

