/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.imap;

import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.protocol.IMAPProtocol;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URLDecoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.UIDFolder;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import javax.mail.search.FlagTerm;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.DataAccessor;
import org.semanticdesktop.aperture.accessor.FolderDataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.UrlNotFoundException;
import org.semanticdesktop.aperture.crawler.ExitCode;
import org.semanticdesktop.aperture.crawler.imap.ImapStreamPool;
import org.semanticdesktop.aperture.crawler.mail.AbstractJavaMailCrawler;
import org.semanticdesktop.aperture.crawler.mail.DataObjectFactory;
import org.semanticdesktop.aperture.crawler.mail.MailUtil;
import org.semanticdesktop.aperture.crawler.mail.MessageDataObject;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.datasource.imap.ImapDataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.security.trustmanager.standard.StandardTrustManager;
import org.semanticdesktop.aperture.util.HttpClientUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapCrawler
extends AbstractJavaMailCrawler
implements DataAccessor {
    private static final String IMAP_URL_SCHEME = "imap://";
    private static final String NEXT_UID_KEY = "nextuid";
    private static final String SIZE_KEY = "size";
    private static final String UID_VALIDITY = "uidValidity";
    private static final String UID_STICKY = "uidSticky";
    private static final String MESSAGE_ID = "Message-ID";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ImapDataSource configuredDataSource;
    private Properties sessionProperties;
    private String hostName;
    private int port;
    private String userName;
    private String password;
    private String connectionType;
    private boolean ignoreSSLCertificates = false;
    private boolean useSSLCertificateFile = false;
    private boolean ignoreUidValidity = false;
    private String SSLCertificateFile;
    private String SSLCertificatePassword;
    private boolean includeInbox;
    private boolean useHeadersHash;
    private ImapStreamPool streamPool;
    private Message[] currentMessages;
    private boolean currentFolderChanged;
    private boolean uidStickyness;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ExitCode crawlObjects() {
        try {
            this.retrieveConfigurationData(this.getDataSource());
            try {
                this.ensureConnectedStore();
            }
            catch (MessagingException e) {
                ExitCode exitCode = this.reportFatalErrorCause("Unable to connect to IMAP mail store", e);
                this.closeConnection();
                return exitCode;
            }
            try {
                int nrFolders = this.baseFolders.size();
                if (nrFolders == 0) {
                    this.crawlFolder(this.store.getDefaultFolder(), 0);
                } else {
                    for (int i = 0; i < nrFolders; ++i) {
                        String baseFolderName = (String)this.baseFolders.get(i);
                        Folder baseFolder = this.store.getFolder(baseFolderName);
                        this.crawlFolder(baseFolder, 0);
                    }
                }
                if (this.includeInbox) {
                    this.crawlFolder(this.store.getFolder("INBOX"), 0);
                }
            }
            catch (MessagingException e) {
                ExitCode exitCode = this.reportFatalErrorCause("MessagingException while crawling", e);
                this.closeConnection();
                return exitCode;
            }
            if (this.isStopRequested()) {
                ExitCode exitCode = ExitCode.STOP_REQUESTED;
                return exitCode;
            }
            ExitCode exitCode = ExitCode.COMPLETED;
            return exitCode;
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    protected void retrieveConfigurationData(DataSource dataSource) {
        Long maximumSize;
        if (dataSource == this.configuredDataSource) {
            return;
        }
        this.configuredDataSource = (ImapDataSource)dataSource;
        this.hostName = this.configuredDataSource.getHostname();
        this.userName = this.configuredDataSource.getUsername();
        this.password = this.configuredDataSource.getPassword();
        this.port = -1;
        Integer configuredPort = this.configuredDataSource.getPort();
        if (configuredPort != null) {
            this.port = configuredPort;
        }
        this.baseFolders.clear();
        this.baseFolders.addAll(this.configuredDataSource.getAllBasepaths());
        Boolean includeInboxB = this.configuredDataSource.getIncludeInbox();
        this.includeInbox = includeInboxB == null ? false : includeInboxB;
        Boolean ignoreUidValidityB = this.configuredDataSource.getIgnoreUidValidity();
        this.ignoreUidValidity = ignoreUidValidityB == null ? false : ignoreUidValidityB;
        Integer maxDepthI = this.configuredDataSource.getMaximumDepth();
        this.maxDepth = maxDepthI == null ? -1 : maxDepthI;
        ImapDataSource.ConnectionSecurity securityType = this.configuredDataSource.getConnectionSecurity();
        if (securityType == null || securityType.equals((Object)ImapDataSource.ConnectionSecurity.PLAIN)) {
            this.connectionType = "imap";
        } else if (securityType.equals((Object)ImapDataSource.ConnectionSecurity.SSL) || securityType.equals((Object)ImapDataSource.ConnectionSecurity.SSL_NO_CERT)) {
            this.connectionType = "imaps";
        } else {
            throw new IllegalArgumentException("Illegal connection security type: " + (Object)((Object)securityType));
        }
        if (securityType != null && securityType.equals((Object)ImapDataSource.ConnectionSecurity.SSL_NO_CERT)) {
            this.ignoreSSLCertificates = true;
        }
        if (this.configuredDataSource.getSslFileName() != null) {
            this.useSSLCertificateFile = true;
            this.SSLCertificateFile = this.configuredDataSource.getSslFileName();
            this.SSLCertificatePassword = this.configuredDataSource.getSslFilePassword();
        }
        this.maximumByteSize = (maximumSize = this.configuredDataSource.getMaximumSize()) == null ? Long.MAX_VALUE : maximumSize;
        Boolean useHeadersHashBool = this.configuredDataSource.getUseHeadersHash();
        this.useHeadersHash = useHeadersHashBool == null ? true : useHeadersHashBool;
        if (this.store != null) {
            this.closeConnection();
            this.store = null;
        }
    }

    @Override
    protected void ensureConnectedStore() throws MessagingException {
        if (this.store == null) {
            Properties properties = System.getProperties();
            if (this.ignoreSSLCertificates) {
                properties.setProperty("mail.imaps.socketFactory.class", SimpleSocketFactory.class.getName());
                properties.setProperty("mail.imaps.socketFactory.fallback", "false");
            }
            if (this.useSSLCertificateFile) {
                properties.setProperty("javax.net.ssl.trustStore", this.SSLCertificateFile);
                properties.setProperty("javax.net.ssl.trustStorePassword", this.SSLCertificatePassword);
            }
            if (this.sessionProperties != null) {
                Enumeration<Object> keys = this.sessionProperties.elements();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = this.sessionProperties.getProperty(key);
                    properties.setProperty(key, value);
                }
            }
            Session session = Session.getDefaultInstance(properties);
            this.store = session.getStore(this.connectionType);
        }
        if (!this.store.isConnected()) {
            this.store.connect(this.hostName, this.port, this.userName, this.password);
        }
        this.streamPool = new ImapStreamPool(this.store);
    }

    @Override
    public void closeConnection() {
        if (this.streamPool != null) {
            this.streamPool.requestClose();
        }
    }

    @Override
    protected Object getDataObjectOrAllObjects(String url, DataSource dataSource, AccessData newAccessData, Map params, RDFContainerFactory containerFactory, boolean all) throws UrlNotFoundException, IOException {
        if (newAccessData != null && newAccessData.get(url, "accessed") != null && !all) {
            return null;
        }
        this.retrieveConfigurationData(dataSource);
        try {
            this.ensureConnectedStore();
            String folderName = this.getFolderName(url);
            Folder folder = folderName == null || folderName.equals("") ? this.store.getDefaultFolder() : this.store.getFolder(folderName);
            if (!folder.exists()) {
                throw new UrlNotFoundException(url, "unknown folder: " + folderName);
            }
            if (!folder.isOpen() && ImapCrawler.holdsMessages(folder)) {
                folder.open(1);
            }
            this.uidStickyness = this.checkUIDStickness(newAccessData, this.getFolderURI(folder), folder);
            int typeIndex = url.indexOf(";TYPE=");
            if (typeIndex < 0) {
                if (this.uidStickyness) {
                    super.setCurrentFolder(folder);
                    Object object = this.getDataObjectByUID(url, dataSource, containerFactory, folder, all);
                    return object;
                }
                this.setCurrentFolder(folder);
                Object object = this.getDataObjectByMessageURI(url, dataSource, containerFactory, folder, all);
                return object;
            }
            this.setCurrentFolder(folder);
            FolderDataObject obj = this.getCurrentFolderObject(dataSource, newAccessData, containerFactory);
            if (all) {
                HashMap<URI, FolderDataObject> res = new HashMap<URI, FolderDataObject>();
                res.put(obj.getID(), obj);
                HashMap<URI, FolderDataObject> hashMap = res;
                return hashMap;
            }
            FolderDataObject folderDataObject = obj;
            return folderDataObject;
        }
        catch (MessagingException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            this.closeConnection();
        }
    }

    private Object getDataObjectByUID(String url, DataSource dataSource, RDFContainerFactory containerFactory, Folder folder, boolean all) throws MessagingException, UrlNotFoundException, IOException {
        long messageUID;
        int separatorIndex = url.lastIndexOf("/;UID=");
        if ((separatorIndex = Math.max(separatorIndex, url.lastIndexOf("/;uid="))) < 0 || separatorIndex >= url.length() - 6) {
            throw new IllegalArgumentException("unable to get message UID from " + url);
        }
        String messageNumberString = url.substring(separatorIndex + 6);
        separatorIndex = messageNumberString.indexOf(35);
        if ((separatorIndex = Math.max(separatorIndex, messageNumberString.indexOf(47))) > 0 && separatorIndex < messageNumberString.length() - 1) {
            messageNumberString = messageNumberString.substring(0, separatorIndex);
        }
        try {
            messageUID = Long.parseLong(messageNumberString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("illegal message UID: " + messageNumberString);
        }
        MimeMessage message = (MimeMessage)((UIDFolder)((Object)folder)).getMessageByUID(messageUID);
        if (message == null) {
            throw new UrlNotFoundException("unknown UID: " + messageUID);
        }
        DataObjectFactory fac = new DataObjectFactory(message, containerFactory, this, dataSource, new URIImpl(this.getMessageUri(folder, message)), this.getFolderURI(folder));
        if (all) {
            return fac.getAllDataObjects();
        }
        return fac.getObjectAndDisposeAllOtherObjects(url);
    }

    @Override
    protected void setCurrentFolder(Folder folder) throws MessagingException {
        super.setCurrentFolder(folder);
        if (!ImapCrawler.holdsMessages(folder)) {
            this.currentFolderChanged = this.checkSubfoldersChanged(this.accessData);
            this.currentMessages = null;
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Prefetching started: " + this.currentFolderURI);
        }
        this.currentMessages = folder.search(new FlagTerm(new Flags(Flags.Flag.DELETED), false));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Folder has " + this.currentMessages.length + " non-deleted msgs");
        }
        this.currentMessages = this.getNonExpungedMessages(this.currentMessages);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Folder contains " + this.currentMessages.length + " non-expunged msgs");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Prefetching uids");
        }
        FetchProfile profile = new FetchProfile();
        profile.add(UIDFolder.FetchProfileItem.UID);
        profile.add(FetchProfile.Item.FLAGS);
        profile.add(FetchProfile.Item.ENVELOPE);
        folder.fetch(this.currentMessages, profile);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Prefetching uids completed");
        }
        boolean folderContentChanged = false;
        int messageCount = this.getCurrentFolderMessageCount();
        HashSet<String> unmodifiedMessages = new HashSet<String>(messageCount);
        boolean uidValidity = this.accessData != null ? this.checkCurrentFolderUIDValidity(this.accessData) : false;
        this.checkCurrentFolderUIDsStickyness(this.accessData);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("UID validity " + uidValidity);
        }
        String folderUriString = this.currentFolderURI.toString();
        if (this.accessData != null && (uidValidity || !this.uidStickyness)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Narrowing the current messages array");
            }
            folderContentChanged = this.narrowCurrentMessagesArray(this.accessData, unmodifiedMessages, folderUriString);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Narrowing completed, " + this.currentMessages.length + " msgs left, folderChanged: " + folderContentChanged);
            }
        } else if (this.accessData != null && !uidValidity && this.uidStickyness) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Removing folder info from access data");
            }
            folderContentChanged = this.removeFolderInfoFromAccessData(folderUriString);
        } else if (this.accessData == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No access data detected");
            }
            folderContentChanged = true;
        }
        if (this.isStopRequested()) {
            return;
        }
        this.currentFolderChanged = folderContentChanged ? true : this.checkSubfoldersChanged(this.accessData);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Finally, after checking subfolders, folderChanged: " + this.currentFolderChanged);
        }
        if (this.currentFolderChanged) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Prefetching content info of " + this.currentMessages.length + " msgs");
            }
            profile = new FetchProfile();
            profile.add(FetchProfile.Item.CONTENT_INFO);
            profile.add(MESSAGE_ID);
            profile.add("In-Reply-To");
            profile.add("References");
            if (!this.uidStickyness) {
                profile.add("Date");
                profile.add("Received");
            }
            this.currentFolder.fetch(this.currentMessages, profile);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Prefetching content info completed");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Reporting " + unmodifiedMessages.size() + " unmodified msgs");
            }
            for (String url : unmodifiedMessages) {
                this.reportNotModified(url);
            }
        }
    }

    private Message[] getNonExpungedMessages(Message[] messages) {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        for (Message message : messages) {
            if (message.isExpunged()) continue;
            arrayList.add(message);
        }
        return arrayList.toArray(new Message[arrayList.size()]);
    }

    @Override
    protected int getCurrentFolderMessageCount() throws MessagingException {
        return this.currentMessages.length;
    }

    @Override
    protected Message getMessageFromCurrentFolder(int index) throws MessagingException {
        return this.currentMessages[index - 1];
    }

    @Override
    public InputStream getPartStream(Part part) throws MessagingException, IOException {
        return this.streamPool.getStreamForAMessage(part);
    }

    @Override
    public MessageDataObject createDataObject(URI dataObjectId, DataSource dataSource, RDFContainer metadata, MimeMessage msg) throws MessagingException {
        return this.streamPool.getObjectForAMessage(dataObjectId, dataSource, metadata, msg);
    }

    private boolean narrowCurrentMessagesArray(AccessData newAccessData, Set<String> unmodifiedMessages, String folderUriString) throws MessagingException {
        Set deprecatedChildren;
        boolean folderChanged = false;
        int messageCount = this.getCurrentFolderMessageCount();
        ArrayList<MimeMessage> filteredMessages = new ArrayList<MimeMessage>(messageCount);
        if (!this.uidStickyness) {
            FetchProfile profile = new FetchProfile();
            profile.add(MESSAGE_ID);
            profile.add("Date");
            profile.add("Received");
            this.currentFolder.fetch(this.currentMessages, profile);
        }
        deprecatedChildren = (deprecatedChildren = newAccessData.getReferredIDs(folderUriString)) == null ? Collections.EMPTY_SET : new HashSet(deprecatedChildren);
        HashSet<String> encounteredChildren = new HashSet<String>(deprecatedChildren.size());
        for (int i = 1; i <= messageCount && !this.isStopRequested(); ++i) {
            MimeMessage message = (MimeMessage)this.getMessageFromCurrentFolder(i);
            String uri = null;
            try {
                uri = this.getMessageUri(this.currentFolder, message);
            }
            catch (FolderClosedException fce) {
                this.currentFolder.open(1);
                message = new MimeMessage(message);
                uri = this.getMessageUri(this.currentFolder, message);
            }
            if (deprecatedChildren.contains(uri)) {
                encounteredChildren.add(uri);
            } else {
                folderChanged = true;
            }
            if (newAccessData.get(uri, "accessed") == null) {
                if (!this.isAcceptable(message)) continue;
                filteredMessages.add(message);
                folderChanged = true;
                continue;
            }
            if (this.isRemoved(message)) {
                newAccessData.removeReferredID(folderUriString, uri);
                folderChanged = true;
                continue;
            }
            unmodifiedMessages.add(uri);
        }
        this.currentMessages = filteredMessages.toArray(new Message[filteredMessages.size()]);
        for (String childUri : deprecatedChildren) {
            if (encounteredChildren.contains(childUri)) continue;
            newAccessData.removeReferredID(folderUriString, childUri);
            folderChanged = true;
        }
        return folderChanged;
    }

    private boolean removeFolderInfoFromAccessData(String folderUriString) {
        if (this.accessData == null) {
            return false;
        }
        Set deprecatedChildren = this.accessData.getReferredIDs(folderUriString);
        deprecatedChildren = deprecatedChildren == null ? Collections.EMPTY_SET : new HashSet(deprecatedChildren);
        for (Object uri : deprecatedChildren) {
            this.reportDeletedDataObject(uri.toString());
        }
        this.accessData.removeReferredIDs(folderUriString);
        boolean folderContentChanged = true;
        return folderContentChanged;
    }

    private boolean checkCurrentFolderUIDValidity(AccessData newAccessData) throws MessagingException {
        if (newAccessData == null) {
            return false;
        }
        String uidValidity = newAccessData.get(this.currentFolderURI.toString(), UID_VALIDITY);
        if (uidValidity == null) {
            return false;
        }
        long oldValidity = 0L;
        try {
            oldValidity = Long.parseLong(uidValidity);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        long newValidity = ((UIDFolder)((Object)this.currentFolder)).getUIDValidity();
        if (this.ignoreUidValidity) {
            return true;
        }
        return oldValidity == newValidity;
    }

    private void checkCurrentFolderUIDsStickyness(AccessData newAccessData) throws MessagingException {
        this.uidStickyness = this.checkUIDStickness(newAccessData, this.currentFolderURI, this.currentFolder);
    }

    private boolean checkUIDStickness(AccessData accessData, URI folderUri, final Folder folder) throws MessagingException {
        Object stickyness;
        if (accessData != null && (stickyness = accessData.get(folderUri.toString(), UID_STICKY)) != null) {
            boolean stickyB = Boolean.parseBoolean((String)stickyness);
            return stickyB;
        }
        stickyness = (Boolean)((IMAPFolder)folder).doCommand(new IMAPFolder.ProtocolCommand(){

            public Object doCommand(IMAPProtocol p) throws ProtocolException {
                Response[] resps = p.command("EXAMINE " + ((IMAPFolder)folder).getFullName(), null);
                if (resps == null) {
                    return Boolean.TRUE;
                }
                for (Response res : resps) {
                    String rest = res.getRest();
                    if (!rest.contains("UIDNOTSTICKY")) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        return (Boolean)stickyness;
    }

    @Override
    protected void recordCurrentFolderInAccessData(AccessData newAccessData) throws MessagingException {
        UIDFolder imapFolder = (UIDFolder)((Object)this.currentFolder);
        String currentUriString = this.currentFolderURI.toString();
        if (newAccessData != null) {
            String subFoldersString;
            if (ImapCrawler.holdsMessages(this.currentFolder)) {
                newAccessData.put(currentUriString, UID_VALIDITY, String.valueOf(imapFolder.getUIDValidity()));
            } else {
                newAccessData.put(currentUriString, UID_VALIDITY, String.valueOf(-1));
            }
            newAccessData.put(currentUriString, UID_STICKY, Boolean.toString(this.uidStickyness));
            if (ImapCrawler.holdsFolders(this.currentFolder) && (subFoldersString = this.getSubFoldersString(this.currentFolder)) != null) {
                newAccessData.put(currentUriString, "subfolders", subFoldersString);
            }
        }
    }

    @Override
    protected boolean checkIfCurrentFolderHasBeenChanged(AccessData newAccessData) throws MessagingException {
        return this.currentFolderChanged;
    }

    private String getFolderURIPrefix(Folder folder) {
        StringBuilder buffer = new StringBuilder(100);
        URLName url = this.store.getURLName();
        buffer.append(IMAP_URL_SCHEME);
        String username = url.getUsername();
        if (username != null && !username.equals("")) {
            username = HttpClientUtil.formUrlEncode(username);
            buffer.append(username);
            buffer.append('@');
        }
        buffer.append(url.getHost());
        buffer.append('/');
        buffer.append(HttpClientUtil.formUrlEncode(folder.getFullName(), "/"));
        return buffer.toString();
    }

    @Override
    public String getFolderName(String url) {
        int lastIndex;
        if (!url.startsWith(IMAP_URL_SCHEME)) {
            return null;
        }
        int firstIndex = url.indexOf(47, 7);
        int n = lastIndex = url.endsWith(";TYPE=LIST") ? url.lastIndexOf(59) : url.lastIndexOf(47);
        if (firstIndex >= 0 && lastIndex > firstIndex) {
            String substring = url.substring(firstIndex + 1, lastIndex);
            try {
                return URLDecoder.decode(substring, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    protected URI getFolderURI(Folder folder) throws MessagingException {
        return new URIImpl(this.getFolderURIPrefix(folder) + ";TYPE=LIST");
    }

    @Override
    protected String getMessageUri(Folder folder, Message message) throws MessagingException {
        if (this.uidStickyness) {
            return this.getFolderURIPrefix(folder) + "/;UID=" + ((UIDFolder)((Object)folder)).getUID(message);
        }
        if (this.useHeadersHash) {
            return this.getFolderURIPrefix(folder) + "/" + MailUtil.getMessageIdWithHeadersHash(message);
        }
        return this.getFolderURIPrefix(folder) + "/" + MailUtil.getMessageId((MimeMessage)message);
    }

    public void setSessionProperties(Properties sessionProperties) {
        this.sessionProperties = sessionProperties;
    }

    public Properties getSessionProperties() {
        return this.sessionProperties;
    }

    public static class SimpleSocketFactory
    extends SSLSocketFactory {
        private Logger logger = LoggerFactory.getLogger(this.getClass());
        private SSLSocketFactory factory;

        public SimpleSocketFactory() {
            try {
                SSLContext sslcontext = SSLContext.getInstance("TLS");
                sslcontext.init(null, new TrustManager[]{new NaiveTrustManager()}, null);
                this.factory = sslcontext.getSocketFactory();
            }
            catch (Exception e) {
                this.logger.error("Exception while setting up SimpleSocketFactory", e);
            }
        }

        public SimpleSocketFactory(File certificateFile, String password) {
            try {
                SSLContext sslcontext = SSLContext.getInstance("TLS");
                StandardTrustManager trustManager = new StandardTrustManager(certificateFile, password.toCharArray());
                sslcontext.init(null, new TrustManager[]{trustManager}, null);
                this.factory = sslcontext.getSocketFactory();
            }
            catch (Exception e) {
                this.logger.error("Exception while setting up SimpleSocketFactory", e);
            }
        }

        public static SocketFactory getDefault() {
            return new SimpleSocketFactory();
        }

        public Socket createSocket() throws IOException {
            return this.factory.createSocket();
        }

        public Socket createSocket(Socket socket, String host, int port, boolean flag) throws IOException {
            return this.factory.createSocket(socket, host, port, flag);
        }

        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.factory.createSocket(address, port, localAddress, localPort);
        }

        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.factory.createSocket(host, port);
        }

        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.factory.createSocket(host, port, localHost, localPort);
        }

        public Socket createSocket(String host, int port) throws IOException {
            return this.factory.createSocket(host, port);
        }

        public String[] getDefaultCipherSuites() {
            return this.factory.getDefaultCipherSuites();
        }

        public String[] getSupportedCipherSuites() {
            return this.factory.getSupportedCipherSuites();
        }

        private static class NaiveTrustManager
        implements X509TrustManager {
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }
    }
}

