/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.ical;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.Pattern;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.component.VJournal;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.parameter.CuType;
import net.fortuna.ical4j.model.parameter.Encoding;
import net.fortuna.ical4j.model.parameter.PartStat;
import net.fortuna.ical4j.model.parameter.Range;
import net.fortuna.ical4j.model.parameter.RelType;
import net.fortuna.ical4j.model.parameter.Related;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.parameter.Rsvp;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Transp;
import net.fortuna.ical4j.util.CompatibilityHints;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.DatatypeLiteral;
import org.ontoware.rdf2go.model.node.Literal;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.RDFS;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.accessor.base.FileDataObjectBase;
import org.semanticdesktop.aperture.crawler.ExitCode;
import org.semanticdesktop.aperture.crawler.base.CrawlerBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.datasource.ical.IcalDataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.subcrawler.PathNotFoundException;
import org.semanticdesktop.aperture.subcrawler.SubCrawler;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerException;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerHandler;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerUtil;
import org.semanticdesktop.aperture.util.IOUtil;
import org.semanticdesktop.aperture.util.StringUtil;
import org.semanticdesktop.aperture.vocabulary.GEO;
import org.semanticdesktop.aperture.vocabulary.NCAL;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IcalCrawler
extends CrawlerBase
implements SubCrawler {
    public static final URI XSD_YEAR_MONTH_DURATION = new URIImpl("http://www.w3.org/2001/XMLSchema#yearMonthDuration");
    public static final URI XSD_DAY_TIME_DURATION = new URIImpl("http://www.w3.org/2001/XMLSchema#dayTimeDuration");
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String baseuri;
    private boolean subCrawlerMode;
    private SubCrawlerHandler subCrawlerHandler;
    private boolean attachmentsOnlyMode;
    private Resource calendarResource;
    private RDFContainer calendarContainer;
    private Pattern icalDurationPattern = Pattern.compile("(\\+|-)?P((\\d+W)|(\\d+D(T\\d+H(\\d+M(\\d+S)?)?)?)|(T\\d+H(\\d+M(\\d+S)?)?))");

    public IcalCrawler() {
        this(false);
    }

    public IcalCrawler(boolean attachmentsOnlyMode) {
        System.setProperty("ical4j.unfolding.relaxed", "true");
        CompatibilityHints.setHintEnabled((String)"ical4j.compatibility.notes", (boolean)true);
        this.attachmentsOnlyMode = attachmentsOnlyMode;
    }

    @Override
    protected ExitCode crawlObjects() {
        IcalDataSource icalDataSource = null;
        try {
            icalDataSource = (IcalDataSource)this.source;
        }
        catch (ClassCastException e) {
            return this.reportFatalErrorCause("unsupported data source type", e);
        }
        String icalFilePath = icalDataSource.getRootUrl();
        if (icalFilePath == null) {
            return this.reportFatalErrorCause("missing iCalendar file path specification");
        }
        File icalFile = new File(icalFilePath);
        if (!icalFile.exists()) {
            return this.reportFatalErrorCause("iCalendar file does not exist: '" + icalFile + "'");
        }
        if (!icalFile.canRead()) {
            return this.reportFatalErrorCause("iCalendar file cannot be read: '" + icalFile + "'");
        }
        try {
            this.baseuri = this.createBaseUri(icalFile);
        }
        catch (IOException e) {
            return this.reportFatalErrorCause("Couldn't get the canonical path for the iCalFile", e);
        }
        return this.crawlIcalFile(icalFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subCrawl(URI id, InputStream stream, SubCrawlerHandler handler, DataSource dataSource, AccessData accessData, Charset charset, String mimeType, RDFContainer parentMetadata) throws SubCrawlerException {
        this.subCrawlerMode = true;
        this.subCrawlerHandler = handler;
        this.baseuri = parentMetadata.getDescribedUri().toString();
        this.setDataSource(dataSource);
        this.setAccessData(accessData);
        CalendarBuilder builder = null;
        Calendar calendar = null;
        try {
            byte[] bytes = IOUtil.readBytes(stream);
            parentMetadata.add(RDF.type, NCAL.Calendar);
            parentMetadata.add(NIE.plainTextContent, new String(bytes, "UTF-8"));
            this.calendarResource = parentMetadata.getDescribedUri();
            this.calendarContainer = parentMetadata;
            builder = new CalendarBuilder();
            calendar = builder.build((InputStream)new ByteArrayInputStream(bytes));
            PropertyList propertyList = calendar.getProperties();
            this.crawlPropertyList(propertyList, parentMetadata.getDescribedUri(), parentMetadata, null);
            ComponentList componentList = calendar.getComponents();
            this.crawlComponentList(componentList, parentMetadata);
        }
        catch (Exception e) {
            this.logger.warn("error while parsing the ical file: " + parentMetadata.getDescribedUri(), e);
        }
        finally {
            this.closeClosable(stream);
        }
    }

    @Override
    public DataObject getDataObject(URI parentUri, String path, InputStream stream, DataSource dataSource, Charset charset, String mimeType, RDFContainerFactory factory) throws SubCrawlerException, PathNotFoundException {
        return null;
    }

    @Override
    public void stopSubCrawler() {
    }

    private String createBaseUri(File icalFile) throws IOException {
        return icalFile.getCanonicalFile().toURI() + "#";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ExitCode crawlIcalFile(File icalFile) {
        FileReader fin = null;
        CalendarBuilder builder = null;
        Calendar calendar = null;
        try {
            fin = new FileReader(icalFile);
            builder = new CalendarBuilder();
            calendar = builder.build((Reader)fin);
            this.crawlCalendar(calendar);
            ExitCode exitCode = ExitCode.COMPLETED;
            return exitCode;
        }
        catch (FileNotFoundException fnfe) {
            ExitCode exitCode = this.reportFatalErrorCause("Couldn't find the calendar file", fnfe);
            return exitCode;
        }
        catch (ParserException pe) {
            ExitCode exitCode = this.reportFatalErrorCause("Couldn't parse the calendar file", pe);
            return exitCode;
        }
        catch (IOException ioe) {
            ExitCode exitCode = this.reportFatalErrorCause("Input/Output error while parsing the calendar file", ioe);
            return exitCode;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void crawlCalendar(Calendar calendar) {
        URI uri = this.generateCalendarUri();
        RDFContainer rdfContainer = this.prepareDataObjectRDFContainer(uri);
        rdfContainer.add(RDF.type, NCAL.Calendar);
        PropertyList propertyList = calendar.getProperties();
        this.crawlPropertyList(propertyList, rdfContainer.getDescribedUri(), rdfContainer, null);
        rdfContainer.add(NIE.rootElementOf, this.getDataSource().getID());
        this.storeFulltext(calendar, rdfContainer);
        if (this.attachmentsOnlyMode) {
            this.calendarResource = rdfContainer.getDescribedUri();
            this.calendarContainer = rdfContainer;
        }
        this.passComponentToHandler(rdfContainer, null);
        ComponentList componentList = calendar.getComponents();
        this.crawlComponentList(componentList, rdfContainer);
    }

    private void storeFulltext(Calendar calendar, RDFContainer rdfContainer) {
        try {
            CalendarOutputter out = new CalendarOutputter(false);
            StringWriter sw = new StringWriter();
            out.output(calendar, (Writer)sw);
            rdfContainer.add(NIE.plainTextContent, sw.toString());
        }
        catch (Exception e) {
            this.logger.warn("Couldn't store the ical fulltext", e);
        }
    }

    private void crawlSingleComponent(Component component, Resource parentNode, RDFContainer rdfContainer) throws ModelException {
        if (component.getName().equals("VALARM")) {
            this.crawlAlarmComponent(component, parentNode, rdfContainer);
        } else if (component.getName().equals("VEVENT")) {
            this.crawlEventComponent(component, parentNode);
        } else if (component.getName().equals("VFREEBUSY")) {
            this.crawlFreebusyComponent(component, parentNode);
        } else if (component.getName().equals("VJOURNAL")) {
            this.crawlJournalComponent(component, parentNode);
        } else if (component.getName().equals("VTIMEZONE")) {
            this.crawlTimezoneComponent(component, parentNode);
        } else if (component.getName().equals("VTODO")) {
            this.crawlTodoComponent(component, parentNode);
        } else if (component.getName().equals("STANDARD")) {
            this.crawlStandardObservance(component, parentNode, rdfContainer);
        } else if (component.getName().equals("DAYLIGHT")) {
            this.crawlDaylightObservance(component, parentNode, rdfContainer);
        } else if (component.getName().startsWith("X-")) {
            this.crawlExperimentalComponent(component, parentNode);
        } else {
            this.logger.warn("Unknown component name: " + component.getName());
        }
    }

    private void crawlSingleProperty(Property property, Resource parentNode, RDFContainer rdfContainer, Component component) throws ModelException {
        String propertyName = property.getName();
        if (propertyName.equals("ACTION")) {
            this.crawlActionProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("ATTACH")) {
            this.crawlAttachProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("ATTENDEE")) {
            this.crawlAttendeeProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("CALSCALE")) {
            this.crawlCalScaleProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("CATEGORIES")) {
            this.crawlCategoriesProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("CLASS")) {
            this.crawlClassProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("COMMENT")) {
            this.crawlCommentProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("COMPLETED")) {
            this.crawlCompletedProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("CONTACT")) {
            this.crawlContactProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("CREATED")) {
            this.crawlCreatedProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("DESCRIPTION")) {
            this.crawlDescriptionProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("DTEND")) {
            this.crawlDtEndProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("DTSTAMP")) {
            this.crawlDtStampProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("DTSTART")) {
            this.crawlDtStartProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("DUE")) {
            this.crawlDueProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("DURATION")) {
            this.crawlDurationProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("EXDATE")) {
            this.crawlExDateProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("EXRULE")) {
            this.crawlExRuleProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("FREEBUSY")) {
            this.crawlFreeBusyProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("GEO")) {
            this.crawlGeoProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("LAST-MODIFIED")) {
            this.crawlLastModifiedProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("LOCATION")) {
            this.crawlLocationProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("METHOD")) {
            this.crawlMethodProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("ORGANIZER")) {
            this.crawlOrganizerProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("PERCENT-COMPLETE")) {
            this.crawlPercentCompleteProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("PRIORITY")) {
            this.crawlPriorityProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("PRODID")) {
            this.crawlProdIdProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("RDATE")) {
            this.crawlRDateProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("RECURRENCE-ID")) {
            this.crawlRecurrenceIdProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("RELATED-TO")) {
            this.crawlRelatedToProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("REPEAT")) {
            this.crawlRepeatProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("REQUEST-STATUS")) {
            this.crawlRequestStatusProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("RESOURCES")) {
            this.crawlResourcesProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("RRULE")) {
            this.crawlRRuleProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("SEQUENCE")) {
            this.crawlSequenceProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("STATUS")) {
            this.crawlStatusProperty(property, parentNode, rdfContainer, component);
        } else if (propertyName.startsWith("SUMMARY")) {
            this.crawlSummaryProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("TRANSP")) {
            this.crawlTranspProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("TRIGGER")) {
            this.crawlTriggerProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("TZID")) {
            this.crawlTzidProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("TZNAME")) {
            this.crawlTzNameProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("TZOFFSETFROM")) {
            this.crawlTzOffsetFromProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("TZOFFSETTO")) {
            this.crawlTzOffsetToProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("TZURL")) {
            this.crawlTzUrlProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("UID")) {
            this.crawlUidProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("URL")) {
            this.crawlUrlProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("VERSION")) {
            this.crawlVersionProperty(property, parentNode, rdfContainer);
        } else if (propertyName.startsWith("X-")) {
            this.crawlXtendedProperty(property, parentNode, rdfContainer);
        } else {
            this.logger.warn("Unknown property name: " + property.getName());
        }
    }

    private void crawlSingleParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
        String parameterName = parameter.getName();
        if (parameterName.equals("ALTREP")) {
            this.crawlAltRepParameter(parameter, parentNode, rdfContainer);
        } else if (parameterName.equals("CN")) {
            this.crawlCnParameter(parameter, parentNode, rdfContainer);
        } else if (parameterName.equals("CUTYPE")) {
            this.crawlCuTypeParameter(parameter, parentNode, rdfContainer);
        } else if (parameterName.equals("DELEGATED-FROM")) {
            this.crawlDelegatedFromParameter(parameter, parentNode, rdfContainer);
        } else if (parameterName.equals("DELEGATED-TO")) {
            this.crawlDelegatedToParameter(parameter, parentNode, rdfContainer);
        } else if (parameterName.equals("DIR")) {
            this.crawlDirParameter(parameter, parentNode, rdfContainer);
        } else if (parameterName.equals("ENCODING")) {
            this.crawlEncodingParameter(parameter, parentNode, rdfContainer);
        } else if (parameterName.equals("FBTYPE")) {
            this.crawlFbTypeParameter(parameter, parentNode, rdfContainer);
        } else if (parameterName.equals("FMTTYPE")) {
            this.crawlFmtTypeParameter(parameter, parentNode, rdfContainer);
        } else if (parameterName.equals("LANGUAGE")) {
            this.crawlLanguageParameter(parameter, parentNode, rdfContainer);
        } else if (parameterName.equals("MEMBER")) {
            this.crawlMemberParameter(parameter, parentNode, rdfContainer);
        } else if (parameterName.equals("PARTSTAT")) {
            this.crawlPartStatParameter(parameter, parentNode, rdfContainer);
        } else if (parameterName.equals("RANGE")) {
            this.crawlRangeParameter(parameter, parentNode, rdfContainer);
        } else if (parameterName.equals("RELATED")) {
            this.crawlRelatedParameter(parameter, parentNode, rdfContainer);
        } else if (parameterName.equals("RELTYPE")) {
            this.crawlRelTypeParameter(parameter, parentNode, rdfContainer);
        } else if (parameterName.equals("ROLE")) {
            this.crawlRoleParameter(parameter, parentNode, rdfContainer);
        } else if (parameterName.equals("RSVP")) {
            this.crawlRsvpParameter(parameter, parentNode, rdfContainer);
        } else if (parameterName.equals("SENT-BY")) {
            this.crawlSentByParameter(parameter, parentNode, rdfContainer);
        } else if (parameterName.equals("TZID")) {
            this.crawlTzidParameter(parameter, parentNode, rdfContainer);
        } else if (parameterName.equals("VALUE")) {
            this.crawlValueParameter(parameter, parentNode, rdfContainer);
        } else if (parameterName.startsWith("X-")) {
            this.crawlXParameter(parameter, parentNode, rdfContainer);
        } else {
            this.logger.warn("Unknown parameter name: '" + parameterName + "'");
        }
    }

    private void crawlComponentList(ComponentList componentList, RDFContainer rdfContainer) {
        for (Component component : componentList) {
            try {
                this.crawlSingleComponent(component, rdfContainer.getDescribedUri(), rdfContainer);
            }
            catch (ModelException e) {
                this.logger.warn("ModelException while processing single component, skipping component", e);
            }
        }
    }

    private void crawlPropertyList(Component component, RDFContainer rdfContainer) {
        this.crawlPropertyList(component, rdfContainer.getDescribedUri(), rdfContainer);
    }

    private void crawlPropertyList(Component component, Resource parentNode, RDFContainer rdfContainer) {
        PropertyList propertyList = component.getProperties();
        this.crawlPropertyList(propertyList, parentNode, rdfContainer, component);
    }

    private void crawlPropertyList(PropertyList propertyList, Resource parentNode, RDFContainer rdfContainer, Component component) {
        for (Property property : propertyList) {
            try {
                this.crawlSingleProperty(property, parentNode, rdfContainer, component);
            }
            catch (ModelException e) {
                this.logger.warn("ModelException while handling single property, skipping property", e);
            }
        }
    }

    private Resource crawlParameterList(Property property, RDFContainer rdfContainer) {
        Resource propertyBlankNode = this.generateAnonymousNode(rdfContainer);
        ParameterList parameterList = property.getParameters();
        this.crawlParameterList(parameterList, propertyBlankNode, rdfContainer);
        return propertyBlankNode;
    }

    private void crawlParameterList(ParameterList parameterList, Resource parentNode, RDFContainer rdfContainer) {
        for (Parameter parameter : parameterList) {
            this.crawlSingleParameter(parameter, parentNode, rdfContainer);
        }
    }

    public void crawlAlarmComponent(Component component, Resource parentNode, RDFContainer rdfContainer) {
        VAlarm valarm = (VAlarm)component;
        URI valarmParentNode = this.generateAnonymousComponentUri(component);
        this.crawlPropertyList((Component)valarm, valarmParentNode, rdfContainer);
        this.addStatement(rdfContainer, parentNode, NCAL.hasAlarm, valarmParentNode);
        this.addStatement(rdfContainer, (Resource)valarmParentNode, RDF.type, NCAL.Alarm);
        this.addStatement(rdfContainer, (Resource)valarmParentNode, RDF.type, NCAL.CalendarDataObject);
    }

    public void crawlEventComponent(Component component, Resource parentNode) {
        RDFContainer rdfContainer = this.prepareDataObjectRDFContainer(component);
        rdfContainer.add(RDF.type, NCAL.Event);
        VEvent vevent = (VEvent)component;
        this.crawlPropertyList((Component)vevent, rdfContainer);
        ComponentList alarmList = vevent.getAlarms();
        this.crawlComponentList(alarmList, rdfContainer);
        this.addStatement(rdfContainer, parentNode, NCAL.component, rdfContainer.getDescribedUri());
        this.passComponentToHandler(rdfContainer, component);
    }

    public void crawlFreebusyComponent(Component component, Resource parentNode) {
        RDFContainer rdfContainer = this.prepareDataObjectRDFContainer(component);
        VFreeBusy vfreebusy = (VFreeBusy)component;
        rdfContainer.add(RDF.type, NCAL.Freebusy);
        this.crawlPropertyList((Component)vfreebusy, rdfContainer);
        this.addStatement(rdfContainer, parentNode, NCAL.component, rdfContainer.getDescribedUri());
        this.passComponentToHandler(rdfContainer, component);
    }

    public void crawlJournalComponent(Component component, Resource parentNode) {
        RDFContainer rdfContainer = this.prepareDataObjectRDFContainer(component);
        rdfContainer.add(RDF.type, NCAL.Journal);
        VJournal vjournal = (VJournal)component;
        this.crawlPropertyList((Component)vjournal, rdfContainer);
        this.addStatement(rdfContainer, parentNode, NCAL.component, rdfContainer.getDescribedUri());
        this.passComponentToHandler(rdfContainer, component);
    }

    public void crawlTimezoneComponent(Component component, Resource parentNode) {
        RDFContainer rdfContainer = this.prepareDataObjectRDFContainer(component);
        rdfContainer.add(RDF.type, NCAL.Timezone);
        VTimeZone vtimezone = (VTimeZone)component;
        this.crawlPropertyList((Component)vtimezone, rdfContainer);
        ComponentList observances = vtimezone.getObservances();
        this.crawlComponentList(observances, rdfContainer);
        this.addStatement(rdfContainer, parentNode, NCAL.component, rdfContainer.getDescribedUri());
        this.passComponentToHandler(rdfContainer, component);
    }

    public void crawlTodoComponent(Component component, Resource parentNode) {
        RDFContainer rdfContainer = this.prepareDataObjectRDFContainer(component);
        rdfContainer.add(RDF.type, NCAL.Todo);
        VToDo vtodo = (VToDo)component;
        this.crawlPropertyList((Component)vtodo, rdfContainer);
        ComponentList alarmList = vtodo.getAlarms();
        this.crawlComponentList(alarmList, rdfContainer);
        this.addStatement(rdfContainer, parentNode, NCAL.component, rdfContainer.getDescribedUri());
        this.passComponentToHandler(rdfContainer, component);
    }

    public void crawlExperimentalComponent(Component component, Resource parentNode) {
    }

    public void crawlStandardObservance(Component component, Resource parentNode, RDFContainer rdfContainer) {
        Resource standardParentNode = this.generateAnonymousNode(rdfContainer);
        this.addStatement(rdfContainer, standardParentNode, RDF.type, NCAL.TimezoneObservance);
        this.crawlPropertyList(component, standardParentNode, rdfContainer);
        this.addStatement(rdfContainer, parentNode, NCAL.standard, standardParentNode);
    }

    public void crawlDaylightObservance(Component component, Resource parentNode, RDFContainer rdfContainer) {
        Resource daylightParentNode = this.generateAnonymousNode(rdfContainer);
        this.addStatement(rdfContainer, daylightParentNode, RDF.type, NCAL.TimezoneObservance);
        this.crawlPropertyList(component, daylightParentNode, rdfContainer);
        this.addStatement(rdfContainer, parentNode, NCAL.daylight, daylightParentNode);
    }

    public void crawlActionProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        String value = property.getValue();
        if (value.equals(Action.AUDIO.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.action, NCAL.audioAction);
        } else if (value.equals(Action.DISPLAY.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.action, NCAL.displayAction);
        } else if (value.equals(Action.EMAIL.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.action, NCAL.emailAction);
        } else if (value.equals(Action.PROCEDURE.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.action, NCAL.procedureAction);
        } else {
            this.logger.warn("Unknown action property value: " + value);
        }
    }

    public void crawlAttachProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Parameter valueParameter = property.getParameter("VALUE");
        String propertyValue = property.getValue();
        if (valueParameter == null || valueParameter.equals((Object)Value.URI)) {
            URI uri = this.tryToCreateAnUri(rdfContainer, propertyValue);
            this.addStatement(rdfContainer, parentNode, NCAL.attach, uri);
            this.addStatement(rdfContainer, (Resource)uri, RDF.type, NCAL.Attachment);
            this.addStatement(rdfContainer, (Resource)uri, RDF.type, RDFS.Resource);
        } else if (valueParameter.equals((Object)Value.BINARY)) {
            Attach attach = (Attach)property;
            byte[] bytes = attach.getBinary();
            URIImpl attachmentUri = new URIImpl(parentNode.toString() + "/attachment-" + StringUtil.sha1Hash(bytes));
            RDFContainer attachmentContainer = this.prepareDataObjectRDFContainer(attachmentUri);
            this.addStatement(rdfContainer, parentNode, NCAL.attach, attachmentUri);
            this.addStatement(attachmentContainer, (Resource)attachmentUri, RDF.type, NCAL.Attachment);
            if (this.attachmentsOnlyMode) {
                this.addStatement(attachmentContainer, (Resource)attachmentUri, NIE.isPartOf, this.calendarResource);
                this.addStatement(this.calendarContainer, this.calendarResource, NIE.hasPart, attachmentUri);
            } else {
                this.addStatement(attachmentContainer, (Resource)attachmentUri, NIE.isPartOf, parentNode);
            }
            this.crawlParameterList(property, attachmentContainer);
            this.passAttachmentToHandler(attachmentContainer, attach.getBinary());
        }
    }

    public void crawlAttendeeProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Resource blankNode = this.crawlParameterList(property, rdfContainer);
        this.addStatement(rdfContainer, parentNode, NCAL.attendee, blankNode);
        this.processAttendeeOrOrganizer(property, blankNode, rdfContainer);
        this.addStatement(rdfContainer, blankNode, RDF.type, NCAL.Attendee);
    }

    public void crawlCalScaleProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        String value = property.getValue();
        if (value.equals(CalScale.GREGORIAN.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.calscale, NCAL.gregorianCalendarScale);
        }
    }

    public void crawlCategoriesProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.categories, property.getValue());
    }

    public void crawlClassProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        String value = property.getValue();
        if (value.equals(Clazz.CONFIDENTIAL.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.class_, NCAL.confidentialClassification);
        } else if (value.equals(Clazz.PRIVATE.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.class_, NCAL.privateClassification);
        } else if (value.equals(Clazz.PUBLIC.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.class_, NCAL.publicClassification);
        } else {
            this.logger.warn("Unknown CLASS property value: " + value);
        }
    }

    public void crawlCommentProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.comment, property.getValue());
    }

    public void crawlCompletedProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Node propertyValue = this.getRdfPropertyValue(rdfContainer, property, "DATE-TIME");
        this.addStatement(rdfContainer, parentNode, NCAL.completed, propertyValue);
    }

    public void crawlContactProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.contact, property.getValue());
    }

    public void crawlCreatedProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Node propertyValue = this.getRdfPropertyValue(rdfContainer, property, "DATE-TIME");
        this.addStatement(rdfContainer, parentNode, NCAL.created, propertyValue);
    }

    public void crawlDescriptionProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.description, property.getValue());
    }

    public void crawlDtEndProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Node propertyValue = this.getRdfPropertyValue(rdfContainer, property, "NCAL-DATE-TIME");
        this.addStatement(rdfContainer, parentNode, NCAL.dtend, propertyValue);
    }

    public void crawlDtStampProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Node propertyValue = this.getRdfPropertyValue(rdfContainer, property, "DATE-TIME");
        this.addStatement(rdfContainer, parentNode, NCAL.dtstamp, propertyValue);
    }

    public void crawlDtStartProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Node propertyValue = this.getRdfPropertyValue(rdfContainer, property, "NCAL-DATE-TIME");
        this.addStatement(rdfContainer, parentNode, NCAL.dtstart, propertyValue);
    }

    public void crawlDueProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Node propertyValue = this.getRdfPropertyValue(rdfContainer, property, "NCAL-DATE-TIME");
        this.addStatement(rdfContainer, parentNode, NCAL.due, propertyValue);
    }

    public void crawlDurationProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Node propertyValue = this.getRdfPropertyValue(rdfContainer, property, "DURATION");
        this.addStatement(rdfContainer, parentNode, NCAL.duration, propertyValue);
    }

    public void crawlExDateProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        List<Node> valueList = this.getMultipleRdfPropertyValues(rdfContainer, property, "NCAL-DATE-TIME");
        this.addMultipleStatements(rdfContainer, parentNode, NCAL.exdate, valueList);
    }

    public void crawlExRuleProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Resource rruleBlankNode = this.generateAnonymousNode(rdfContainer);
        this.crawlRecur(property.getValue(), rruleBlankNode, rdfContainer);
        this.addStatement(rdfContainer, parentNode, NCAL.exrule, rruleBlankNode);
    }

    public void crawlFreeBusyProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        List<Node> valueList = this.getMultipleRdfPropertyValues(rdfContainer, property, "PERIOD");
        for (Node node : valueList) {
            Resource resource = node.asResource();
            this.addStatement(rdfContainer, parentNode, NCAL.freebusy, resource);
            this.addStatement(rdfContainer, resource, RDF.type, NCAL.FreebusyPeriod);
        }
    }

    public void crawlGeoProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        String[] valueTokens = property.getValue().split(";");
        DatatypeLiteral latitudeLiteral = rdfContainer.getModel().createDatatypeLiteral(valueTokens[0], XSD._decimal);
        DatatypeLiteral longitudeLiteral = rdfContainer.getModel().createDatatypeLiteral(valueTokens[1], XSD._decimal);
        Resource geoPointNode = this.generateAnonymousNode(rdfContainer);
        this.addStatement(rdfContainer, geoPointNode, RDF.type, GEO.Point);
        this.addStatement(rdfContainer, geoPointNode, GEO.lat, latitudeLiteral);
        this.addStatement(rdfContainer, geoPointNode, GEO.long_, longitudeLiteral);
        this.addStatement(rdfContainer, parentNode, NCAL.geo, geoPointNode);
    }

    public void crawlLastModifiedProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Node propertyValue = this.getRdfPropertyValue(rdfContainer, property, "DATE-TIME");
        this.addStatement(rdfContainer, parentNode, NCAL.lastModified, propertyValue);
    }

    public void crawlLocationProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.location, property.getValue());
    }

    public void crawlMethodProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.method, property.getValue());
    }

    public void crawlOrganizerProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Resource blankNode = this.crawlParameterList(property, rdfContainer);
        this.addStatement(rdfContainer, parentNode, NCAL.organizer, blankNode);
        this.processAttendeeOrOrganizer(property, blankNode, rdfContainer);
        this.addStatement(rdfContainer, blankNode, RDF.type, NCAL.Organizer);
    }

    public void crawlPercentCompleteProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Node propertyValue = this.getRdfPropertyValue(rdfContainer, property, "INTEGER");
        this.addStatement(rdfContainer, parentNode, NCAL.percentComplete, propertyValue);
    }

    public void crawlPriorityProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Node propertyValue = this.getRdfPropertyValue(rdfContainer, property, "INTEGER");
        this.addStatement(rdfContainer, parentNode, NCAL.priority, propertyValue);
    }

    public void crawlProdIdProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.prodid, property.getValue());
    }

    public void crawlRDateProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        List<Node> valueList = this.getMultipleRdfPropertyValues(rdfContainer, property, "NCAL-DATE-TIME");
        this.addMultipleStatements(rdfContainer, parentNode, NCAL.rdate, valueList);
    }

    public void crawlRecurrenceIdProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Resource recurrenceIdBlankNode = this.crawlParameterList(property, rdfContainer);
        Node propertyValue = this.getRdfPropertyValue(rdfContainer, property, "NCAL-DATE-TIME");
        this.addStatement(rdfContainer, parentNode, NCAL.recurrenceId, recurrenceIdBlankNode);
        this.addStatement(rdfContainer, recurrenceIdBlankNode, NCAL.recurrenceIdDateTime, propertyValue);
        this.addStatement(rdfContainer, recurrenceIdBlankNode, RDF.type, NCAL.RecurrenceIdentifier);
    }

    public void crawlRelatedToProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Parameter reltypeParameter = property.getParameter("RELTYPE");
        if (reltypeParameter == null) {
            this.addStatement(rdfContainer, parentNode, NCAL.relatedToParent, property.getValue());
            return;
        }
        String reltype = reltypeParameter.getValue();
        if (reltype.equals(RelType.CHILD.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.relatedToChild, property.getValue());
        } else if (reltype.equals(RelType.PARENT.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.relatedToParent, property.getValue());
        } else if (reltype.equals(RelType.SIBLING.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.relatedToSibling, property.getValue());
        } else {
            this.logger.warn("Unkown RELTYPE parameter value: " + reltype);
        }
    }

    public void crawlRepeatProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Node propertyValue = this.getRdfPropertyValue(rdfContainer, property, "INTEGER");
        this.addStatement(rdfContainer, parentNode, NCAL.repeat, propertyValue);
    }

    public void crawlRequestStatusProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        String value = property.getValue();
        String[] parts = value.split(";");
        if (parts.length == 0) {
            return;
        }
        Resource requestStatus = this.generateAnonymousNode(rdfContainer);
        this.addStatement(rdfContainer, requestStatus, RDF.type, NCAL.RequestStatus);
        this.addStatement(rdfContainer, requestStatus, NCAL.returnStatus, parts[0]);
        this.addStatement(rdfContainer, parentNode, NCAL.requestStatus, requestStatus);
        if (parts.length >= 2) {
            this.addStatement(rdfContainer, requestStatus, NCAL.statusDescription, parts[1]);
        }
        if (parts.length >= 3) {
            String result = parts[2];
            for (int i = 3; i < parts.length; ++i) {
                result = result + ";" + parts[i];
            }
            this.addStatement(rdfContainer, requestStatus, NCAL.requestStatusData, result);
        }
    }

    public void crawlResourcesProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        List<Node> values = this.getMultipleRdfPropertyValues(rdfContainer, property, "TEXT");
        this.addMultipleStatements(rdfContainer, parentNode, NCAL.resources, values);
    }

    public void crawlRRuleProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Resource rruleBlankNode = this.generateAnonymousNode(rdfContainer);
        this.crawlRecur(property.getValue(), rruleBlankNode, rdfContainer);
        this.addStatement(rdfContainer, parentNode, NCAL.rrule, rruleBlankNode);
    }

    public void crawlSequenceProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Node propertyValue = this.getRdfPropertyValue(rdfContainer, property, "INTEGER");
        this.addStatement(rdfContainer, parentNode, NCAL.sequence, propertyValue);
    }

    public void crawlStatusProperty(Property property, Resource parentNode, RDFContainer rdfContainer, Component component) {
        String value = property.getValue();
        if (component == null) {
            this.logger.warn("Trying to crawl the status propperty with a null component argument");
        }
        if (value.equals(Status.VEVENT_CANCELLED.getValue()) || value.equals(Status.VJOURNAL_CANCELLED.getValue()) || value.equals(Status.VTODO_CANCELLED.getValue())) {
            if (component.getName().equals("VEVENT")) {
                this.addStatement(rdfContainer, parentNode, NCAL.eventStatus, NCAL.cancelledEventStatus);
            } else if (component.getName().equals("VJOURNAL")) {
                this.addStatement(rdfContainer, parentNode, NCAL.journalStatus, NCAL.cancelledJournalStatus);
            } else if (component.getName().equals("VTODO")) {
                this.addStatement(rdfContainer, parentNode, NCAL.todoStatus, NCAL.cancelledTodoStatus);
            } else {
                this.logger.warn("Unknown component has an event status: " + component.getName());
            }
        } else if (value.equals(Status.VEVENT_CONFIRMED.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.eventStatus, NCAL.confirmedStatus);
        } else if (value.equals(Status.VEVENT_TENTATIVE.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.eventStatus, NCAL.tentativeStatus);
        } else if (value.equals(Status.VJOURNAL_DRAFT.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.journalStatus, NCAL.draftStatus);
        } else if (value.equals(Status.VJOURNAL_FINAL.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.journalStatus, NCAL.finalStatus);
        } else if (value.equals(Status.VTODO_COMPLETED.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.todoStatus, NCAL.completedStatus);
        } else if (value.equals(Status.VTODO_IN_PROCESS.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.todoStatus, NCAL.inProcessStatus);
        } else if (value.equals(Status.VTODO_NEEDS_ACTION.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.todoStatus, NCAL.needsActionStatus);
        } else {
            this.logger.warn("Unknown value of the STATUS property: " + value);
        }
    }

    public void crawlSummaryProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.summary, property.getValue());
    }

    public void crawlTranspProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        String value = property.getValue();
        if (value.equals(Transp.OPAQUE.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.transp, NCAL.opaqueTransparency);
        } else if (value.equals(Transp.TRANSPARENT.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.transp, NCAL.transparentTransparency);
        } else {
            this.logger.warn("Unknown TRANSP property value: " + value);
        }
    }

    public void crawlTriggerProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Resource triggerBlankNode = this.crawlParameterList(property, rdfContainer);
        this.addStatement(rdfContainer, parentNode, NCAL.trigger, triggerBlankNode);
        Node propertyValue = this.getRdfPropertyValue(rdfContainer, property, "DURATION");
        Parameter valueParameter = property.getParameter("VALUE");
        if (valueParameter == null || valueParameter.getValue().equals("DURATION")) {
            this.addStatement(rdfContainer, triggerBlankNode, NCAL.triggerDuration, propertyValue);
        } else if (valueParameter.getValue().equals("DATE-TIME")) {
            this.addStatement(rdfContainer, triggerBlankNode, NCAL.triggerDateTime, propertyValue);
        } else {
            this.logger.warn("Unknown VALUE parameter for the TRIGGER property: " + valueParameter.getValue());
        }
        this.addStatement(rdfContainer, triggerBlankNode, RDF.type, NCAL.Trigger);
    }

    public void crawlTzidProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.tzid, property.getValue());
    }

    public void crawlTzNameProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.tzname, property.getValue());
    }

    public void crawlTzOffsetFromProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.tzoffsetfrom, property.getValue());
    }

    public void crawlTzOffsetToProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.tzoffsetto, property.getValue());
    }

    public void crawlTzUrlProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Node propertyValue = this.getRdfPropertyValue(rdfContainer, property, "URI");
        this.addStatement(rdfContainer, parentNode, NCAL.tzurl, propertyValue);
    }

    public void crawlUidProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.uid, property.getValue());
    }

    public void crawlUrlProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        Node propertyValue = this.getRdfPropertyValue(rdfContainer, property, "URI");
        this.addStatement(rdfContainer, parentNode, NCAL.url, propertyValue);
    }

    public void crawlVersionProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.version, property.getValue());
    }

    public void crawlXtendedProperty(Property property, Resource parentNode, RDFContainer rdfContainer) {
    }

    public void crawlAltRepParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
    }

    public void crawlCnParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
    }

    public void crawlCuTypeParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
        String value = parameter.getValue();
        if (value.equals(CuType.GROUP.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.cutype, NCAL.groupUserType);
        } else if (value.equals(CuType.INDIVIDUAL.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.cutype, NCAL.individualUserType);
        } else if (value.equals(CuType.RESOURCE.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.cutype, NCAL.resourceUserType);
        } else if (value.equals(CuType.ROOM.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.cutype, NCAL.roomUserType);
        } else if (value.equals(CuType.UNKNOWN.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.cutype, NCAL.unknownUserType);
        } else {
            this.logger.warn("Unknown CUTYPE parameter value: " + value);
        }
    }

    public void crawlDelegatedToParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.delegatedTo, parameter.getValue());
    }

    public void crawlDelegatedFromParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.delegatedFrom, parameter.getValue());
    }

    public void crawlDirParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.dir, parameter.getValue());
    }

    public void crawlEncodingParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
        String value = parameter.getValue();
        if (value.equals(Encoding.BASE64.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.encoding, NCAL.base64Encoding);
        } else if (value.equals(Encoding.EIGHT_BIT.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.encoding, NCAL._8bitEncoding);
        } else {
            this.logger.warn("Unknown encoding type: " + value);
        }
    }

    public void crawlFbTypeParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.fbtype, parameter.getValue());
    }

    private void crawlFmtTypeParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.fmttype, parameter.getValue().toLowerCase());
    }

    public void crawlLanguageParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
    }

    public void crawlMemberParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.member, parameter.getValue());
    }

    public void crawlPartStatParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
        String value = parameter.getValue();
        if (value.equals(PartStat.ACCEPTED.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.partstat, NCAL.acceptedParticipationStatus);
        } else if (value.equals(PartStat.COMPLETED.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.partstat, NCAL.completedParticipationStatus);
        } else if (value.equals(PartStat.DECLINED.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.partstat, NCAL.declinedParticipationStatus);
        } else if (value.equals(PartStat.DELEGATED.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.partstat, NCAL.delegatedParticipationStatus);
        } else if (value.equals(PartStat.IN_PROCESS.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.partstat, NCAL.inProcessParticipationStatus);
        } else if (value.equals(PartStat.NEEDS_ACTION.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.partstat, NCAL.needsActionParticipationStatus);
        } else if (value.equals(PartStat.TENTATIVE.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.partstat, NCAL.tentativeParticipationStatus);
        } else {
            this.logger.warn("Unknown PARTSTAT parameter value: " + value);
        }
    }

    public void crawlRangeParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
        String value = parameter.getValue();
        if (value.equals(Range.THISANDFUTURE.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.range, NCAL.thisAndFutureRange);
        } else if (value.equals(Range.THISANDPRIOR.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.range, NCAL.thisAndPriorRange);
        } else {
            this.logger.warn("Unknown RANGE parameter value: " + value);
        }
    }

    public void crawlRelatedParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
        String value = parameter.getValue();
        if (value.equals(Related.START.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.related, NCAL.startTriggerRelation);
        } else if (value.equals(Related.END.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.related, NCAL.endTriggerRelation);
        } else {
            this.logger.warn("Unknown RELATED parameter value: " + value);
        }
    }

    public void crawlRelTypeParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
    }

    public void crawlRoleParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
        String value = parameter.getValue();
        if (value.equals(Role.CHAIR.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.role, NCAL.chairRole);
        } else if (value.equals(Role.NON_PARTICIPANT.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.role, NCAL.nonParticipantRole);
        } else if (value.equals(Role.OPT_PARTICIPANT.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.role, NCAL.optParticipantRole);
        } else if (value.equals(Role.REQ_PARTICIPANT.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.role, NCAL.reqParticipantRole);
        } else {
            this.logger.warn("Unknown ROLE parameter value: " + value);
        }
    }

    public void crawlRsvpParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
        String value = parameter.getValue();
        if (value.equals(Rsvp.TRUE.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.rsvp, true);
        } else if (value.equals(Rsvp.FALSE.getValue())) {
            this.addStatement(rdfContainer, parentNode, NCAL.rsvp, false);
        } else {
            this.logger.warn("Unknown RSVP parameter value: " + value);
        }
    }

    public void crawlSentByParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.sentBy, parameter.getValue());
    }

    public void crawlTzidParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
    }

    public void crawlValueParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
    }

    public void crawlXParameter(Parameter parameter, Resource parentNode, RDFContainer rdfContainer) {
    }

    private void crawlRecur(String recurString, Resource rruleBlankNode, RDFContainer rdfContainer) {
        String[] recurTokens = recurString.split("[=;]");
        for (int i = 0; i < recurTokens.length; i += 2) {
            try {
                this.crawlRecurrenceParam(recurTokens[i], recurTokens[i + 1], rruleBlankNode, rdfContainer);
                continue;
            }
            catch (ModelException e) {
                this.logger.warn("ModelException while processing recurrence param, skipping param", e);
            }
        }
        this.addStatement(rdfContainer, rruleBlankNode, RDF.type, NCAL.RecurrenceRule);
    }

    private void crawlRecurrenceParam(String name, String value, Resource parentNode, RDFContainer rdfContainer) throws ModelException {
        if (name.equals("FREQ")) {
            this.crawlFreqRecurrenceParam(name, value, parentNode, rdfContainer);
        } else if (name.equals("UNTIL")) {
            this.crawlUntilRecurrenceParam(name, value, parentNode, rdfContainer);
        } else if (name.equals("COUNT")) {
            this.crawlCountRecurrenceParam(name, value, parentNode, rdfContainer);
        } else if (name.equals("INTERVAL")) {
            this.crawlIntervalRecurrenceParam(name, value, parentNode, rdfContainer);
        } else if (name.equals("BYSECOND")) {
            this.crawlBySecondRecurrenceParam(name, value, parentNode, rdfContainer);
        } else if (name.equals("BYMINUTE")) {
            this.crawlByMinuteRecurrenceParam(name, value, parentNode, rdfContainer);
        } else if (name.equals("BYHOUR")) {
            this.crawlByHourRecurrenceParam(name, value, parentNode, rdfContainer);
        } else if (name.equals("BYDAY")) {
            this.crawlByDayRecurrenceParam(name, value, parentNode, rdfContainer);
        } else if (name.equals("BYMONTHDAY")) {
            this.crawlByMonthdayRecurrenceParam(name, value, parentNode, rdfContainer);
        } else if (name.equals("BYYEARDAY")) {
            this.crawlByYeardayRecurrenceParam(name, value, parentNode, rdfContainer);
        } else if (name.equals("BYWEEKNO")) {
            this.crawlByWeeknoRecurrenceParam(name, value, parentNode, rdfContainer);
        } else if (name.equals("BYMONTH")) {
            this.crawlByMonthRecurrenceParam(name, value, parentNode, rdfContainer);
        } else if (name.equals("BYSETPOS")) {
            this.crawlBySetposRecurrenceParam(name, value, parentNode, rdfContainer);
        } else if (name.equals("WKST")) {
            this.crawlWkstRecurrenceParam(name, value, parentNode, rdfContainer);
        } else {
            this.logger.warn("Unknown recurrence param name " + name);
        }
    }

    private void crawlFreqRecurrenceParam(String name, String value, Resource parentNode, RDFContainer rdfContainer) {
        if (value.equals("YEARLY")) {
            this.addStatement(rdfContainer, parentNode, NCAL.freq, NCAL.yearly);
        } else if (value.equals("MONTHLY")) {
            this.addStatement(rdfContainer, parentNode, NCAL.freq, NCAL.monthly);
        } else if (value.equals("WEEKLY")) {
            this.addStatement(rdfContainer, parentNode, NCAL.freq, NCAL.weekly);
        } else if (value.equals("DAILY")) {
            this.addStatement(rdfContainer, parentNode, NCAL.freq, NCAL.daily);
        } else if (value.equals("HOURLY")) {
            this.addStatement(rdfContainer, parentNode, NCAL.freq, NCAL.hourly);
        } else if (value.equals("MINUTELY")) {
            this.addStatement(rdfContainer, parentNode, NCAL.freq, NCAL.minutely);
        } else if (value.equals("SECONDLY")) {
            this.addStatement(rdfContainer, parentNode, NCAL.freq, NCAL.secondly);
        } else {
            this.logger.warn("Unknown FREQ recurrence rule parameter value: " + value);
        }
    }

    private void crawlUntilRecurrenceParam(String name, String value, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.until, value);
    }

    private void crawlIntervalRecurrenceParam(String name, String value, Resource parentNode, RDFContainer rdfContainer) throws ModelException {
        Literal literal = rdfContainer.getValueFactory().createLiteral(value, XSD._integer);
        this.addStatement(rdfContainer, parentNode, NCAL.interval, literal);
    }

    private void crawlCountRecurrenceParam(String name, String value, Resource parentNode, RDFContainer rdfContainer) throws ModelException {
        Literal literal = rdfContainer.getValueFactory().createLiteral(value, XSD._integer);
        this.addStatement(rdfContainer, parentNode, NCAL.count, literal);
    }

    private void crawlBySecondRecurrenceParam(String name, String value, Resource parentNode, RDFContainer rdfContainer) {
        try {
            int number = Integer.parseInt(value);
            this.addStatement(rdfContainer, parentNode, NCAL.bysecond, number);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
    }

    private void crawlByMinuteRecurrenceParam(String name, String value, Resource parentNode, RDFContainer rdfContainer) {
        try {
            int number = Integer.parseInt(value);
            this.addStatement(rdfContainer, parentNode, NCAL.byminute, number);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
    }

    private void crawlByHourRecurrenceParam(String name, String value, Resource parentNode, RDFContainer rdfContainer) {
        try {
            int number = Integer.parseInt(value);
            this.addStatement(rdfContainer, parentNode, NCAL.byhour, number);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
    }

    private void crawlByDayRecurrenceParam(String name, String originalValue, Resource parentNode, RDFContainer rdfContainer) throws ModelException {
        String[] array;
        for (String value : array = originalValue.split(",")) {
            Resource bydayRulePartNode = this.generateAnonymousNode(rdfContainer);
            String twoLastCharacters = value.substring(value.length() - 2, value.length());
            URI weekdayURI = null;
            if (twoLastCharacters.equals("MO")) {
                weekdayURI = NCAL.monday;
            } else if (twoLastCharacters.equals("TU")) {
                weekdayURI = NCAL.tuesday;
            } else if (twoLastCharacters.equals("WE")) {
                weekdayURI = NCAL.wednesday;
            } else if (twoLastCharacters.equals("TH")) {
                weekdayURI = NCAL.thursday;
            } else if (twoLastCharacters.equals("FR")) {
                weekdayURI = NCAL.friday;
            } else if (twoLastCharacters.equals("SA")) {
                weekdayURI = NCAL.saturday;
            } else if (twoLastCharacters.equals("SU")) {
                weekdayURI = NCAL.sunday;
            } else {
                this.logger.warn("Unknown day of the week: " + value);
                return;
            }
            int number = 0;
            boolean numberPresent = false;
            if (value.length() > 2) {
                String numberPart = value.substring(0, value.length() - 2);
                try {
                    number = Integer.parseInt(numberPart);
                    numberPresent = true;
                }
                catch (NumberFormatException nfe) {
                    return;
                }
            }
            this.addStatement(rdfContainer, bydayRulePartNode, NCAL.bydayWeekday, weekdayURI);
            if (numberPresent) {
                this.addStatement(rdfContainer, bydayRulePartNode, NCAL.bydayModifier, rdfContainer.getModel().createDatatypeLiteral(String.valueOf(number), XSD._integer));
            }
            this.addStatement(rdfContainer, bydayRulePartNode, RDF.type, NCAL.BydayRulePart);
            this.addStatement(rdfContainer, parentNode, NCAL.byday, bydayRulePartNode);
        }
    }

    private void crawlByMonthdayRecurrenceParam(String name, String value, Resource parentNode, RDFContainer rdfContainer) {
        try {
            int number = Integer.parseInt(value);
            this.addStatement(rdfContainer, parentNode, NCAL.bymonthday, number);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
    }

    private void crawlByYeardayRecurrenceParam(String name, String value, Resource parentNode, RDFContainer rdfContainer) {
        try {
            int number = Integer.parseInt(value);
            this.addStatement(rdfContainer, parentNode, NCAL.byyearday, number);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
    }

    private void crawlByWeeknoRecurrenceParam(String name, String value, Resource parentNode, RDFContainer rdfContainer) {
        try {
            int number = Integer.parseInt(value);
            this.addStatement(rdfContainer, parentNode, NCAL.byweekno, number);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
    }

    private void crawlByMonthRecurrenceParam(String name, String value, Resource parentNode, RDFContainer rdfContainer) {
        try {
            int number = Integer.parseInt(value);
            this.addStatement(rdfContainer, parentNode, NCAL.bymonth, number);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
    }

    private void crawlBySetposRecurrenceParam(String name, String value, Resource parentNode, RDFContainer rdfContainer) {
        try {
            int number = Integer.parseInt(value);
            this.addStatement(rdfContainer, parentNode, NCAL.bysetpos, number);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
    }

    private void crawlWkstRecurrenceParam(String name, String value, Resource parentNode, RDFContainer rdfContainer) {
        this.addStatement(rdfContainer, parentNode, NCAL.wkst, value);
    }

    private RDFContainer prepareDataObjectRDFContainer(Component component) {
        URI uri = this.generateComponentUri(component);
        return this.prepareDataObjectRDFContainer(uri);
    }

    private RDFContainer prepareDataObjectRDFContainer(URI uri) {
        this.reportAccessingObject(uri.toString());
        RDFContainerFactory containerFactory = null;
        containerFactory = this.subCrawlerMode ? this.subCrawlerHandler.getRDFContainerFactory(uri.toString()) : this.getRDFContainerFactory(uri.toString());
        RDFContainer rdfContainer = containerFactory.getRDFContainer(uri);
        rdfContainer.add(RDF.type, NCAL.CalendarDataObject);
        return rdfContainer;
    }

    private void addStatement(RDFContainer rdfContainer, Resource subject, URI predicate, String object) {
        try {
            this.addStatement(rdfContainer, subject, predicate, rdfContainer.getValueFactory().createLiteral(object));
        }
        catch (ModelException e) {
            this.logger.warn("ModelException while creating literal, skipping statement", e);
        }
    }

    private void addStatement(RDFContainer rdfContainer, Resource subject, URI predicate, int object) {
        try {
            this.addStatement(rdfContainer, subject, predicate, rdfContainer.getValueFactory().createLiteral(object));
        }
        catch (ModelException e) {
            this.logger.warn("ModelException while creating literal, skipping statement", e);
        }
    }

    private void addStatement(RDFContainer rdfContainer, Resource subject, URI predicate, boolean object) {
        try {
            this.addStatement(rdfContainer, subject, predicate, rdfContainer.getValueFactory().createLiteral(object));
        }
        catch (ModelException e) {
            this.logger.warn("ModelException while creating literal, skipping statement", e);
        }
    }

    private void addStatement(RDFContainer rdfContainer, Resource subject, URI predicate, Node object) {
        Statement statement = rdfContainer.getValueFactory().createStatement(subject, predicate, object);
        rdfContainer.add(statement);
    }

    private void addMultipleStatements(RDFContainer rdfContainer, Resource parentNode, URI predicate, List<Node> valueList) {
        for (Node value : valueList) {
            this.addStatement(rdfContainer, parentNode, predicate, value);
        }
    }

    private void processAttendeeOrOrganizer(Property property, Resource attendeeOrOrganizerNode, RDFContainer rdfContainer) {
        Resource contactBlankNode = this.generateAnonymousNode(rdfContainer);
        this.addStatement(rdfContainer, attendeeOrOrganizerNode, NCAL.involvedContact, contactBlankNode);
        this.addStatement(rdfContainer, contactBlankNode, RDF.type, NCO.PersonContact);
        Resource emailAddressBlankNode = this.generateAnonymousNode(rdfContainer);
        this.addStatement(rdfContainer, contactBlankNode, NCO.hasEmailAddress, emailAddressBlankNode);
        this.addStatement(rdfContainer, emailAddressBlankNode, RDF.type, NCO.EmailAddress);
        this.addStatement(rdfContainer, emailAddressBlankNode, NCO.emailAddress, property.getValue().substring(7));
        Parameter cnParameter = property.getParameter("CN");
        if (cnParameter != null) {
            String cn = cnParameter.getValue();
            this.addStatement(rdfContainer, contactBlankNode, NCO.fullname, cn);
        }
    }

    private void passComponentToHandler(RDFContainer metadata, Component component) {
        if (this.attachmentsOnlyMode) {
            metadata.dispose();
            return;
        }
        DataObjectBase dataObject = new DataObjectBase(metadata.getDescribedUri(), this.getDataSource(), metadata);
        String id = metadata.getDescribedUri().toString();
        if (this.accessData == null) {
            this.reportNewDataObject(dataObject);
        } else if (!this.accessData.isKnownId(id)) {
            if (component == null) {
                this.updateAccessData(metadata, this.hashOfProperties(metadata));
            } else {
                this.updateAccessData(metadata, component);
            }
            this.reportNewDataObject(dataObject);
        } else if (this.isChanged(metadata, component)) {
            if (component == null) {
                this.updateAccessData(metadata, this.hashOfProperties(metadata));
            } else {
                this.updateAccessData(metadata, component);
            }
            this.reportModifiedDataObject(dataObject);
        } else {
            this.reportUnmodifiedDataObject(id);
            dataObject.dispose();
        }
    }

    private void passAttachmentToHandler(RDFContainer metadata, byte[] bytes) {
        String sha1Hash = StringUtil.sha1Hash(bytes);
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        FileDataObjectBase dataObject = new FileDataObjectBase(metadata.getDescribedUri(), this.source, metadata, stream);
        String id = metadata.getDescribedUri().toString();
        if (this.accessData == null) {
            this.reportNewDataObject(dataObject);
        } else if (!this.accessData.isKnownId(id)) {
            this.updateAccessData(metadata, sha1Hash);
            this.reportNewDataObject(dataObject);
        } else if (this.isAttachmentChanged(metadata, sha1Hash)) {
            this.updateAccessData(metadata, sha1Hash);
            this.reportModifiedDataObject(dataObject);
        } else {
            this.reportUnmodifiedDataObject(id);
            dataObject.dispose();
        }
    }

    @Override
    protected void reportModifiedDataObject(DataObject object) {
        if (this.subCrawlerMode) {
            this.touchObject(object.getID().toString());
            this.subCrawlerHandler.objectChanged(object);
        } else {
            super.reportModifiedDataObject(object);
        }
    }

    @Override
    protected void reportNewDataObject(DataObject object) {
        if (this.subCrawlerMode) {
            this.touchObject(object.getID().toString());
            this.subCrawlerHandler.objectNew(object);
        } else {
            super.reportNewDataObject(object);
        }
    }

    @Override
    protected void reportUnmodifiedDataObject(String url) {
        if (this.subCrawlerMode) {
            this.accessData.touchRecursively(url);
            this.subCrawlerHandler.objectNotModified(url);
        } else {
            super.reportUnmodifiedDataObject(url);
        }
    }

    private void updateAccessData(RDFContainer metadata, Component component) {
        this.updateAccessData(metadata, StringUtil.sha1Hash(component.toString()));
    }

    private void updateAccessData(RDFContainer metadata, String hash) {
        String id = metadata.getDescribedUri().toString();
        this.accessData.put(id, "visited", "true");
        this.accessData.put(id, "hash", hash);
    }

    private String hashOfProperties(RDFContainer metadata) {
        StringBuffer buffer = new StringBuffer("");
        this.appendPropertyValue(buffer, metadata, NCAL.method);
        this.appendPropertyValue(buffer, metadata, NCAL.prodid);
        this.appendPropertyValue(buffer, metadata, NCAL.version);
        this.appendPropertyValue(buffer, metadata, NCAL.calscale);
        return StringUtil.sha1Hash(buffer.toString());
    }

    private void appendPropertyValue(StringBuffer buffer, RDFContainer metadata, URI predicate) {
        Collection propertyValues = metadata.getAll(predicate);
        for (Node value : propertyValues) {
            this.appendSinglePropertyValue(buffer, predicate, value);
        }
    }

    private void appendSinglePropertyValue(StringBuffer buffer, URI predicate, Node value) {
        if (value instanceof Literal) {
            URI datatype = null;
            String label = ((Literal)value).getValue();
            if (value instanceof DatatypeLiteral) {
                datatype = ((DatatypeLiteral)value).getDatatype();
            }
            if (buffer.length() > 0) {
                buffer.append("#");
            }
            buffer.append(predicate.toString());
            buffer.append("#");
            buffer.append(label);
            if (datatype != null) {
                buffer.append("#");
                buffer.append(datatype.toString());
            }
        } else if (value instanceof URI) {
            if (buffer.length() > 0) {
                buffer.append("#");
            }
            buffer.append(predicate.toString());
            buffer.append("#");
            buffer.append(value.toString());
        }
    }

    private boolean isChanged(RDFContainer metadata, Component component) {
        String id = metadata.getDescribedUri().toString();
        String newHash = component == null ? this.hashOfProperties(metadata) : StringUtil.sha1Hash(component.toString());
        String oldHash = this.accessData.get(id, "hash");
        if (oldHash == null) {
            return true;
        }
        return !oldHash.equals(newHash);
    }

    private boolean isAttachmentChanged(RDFContainer metadata, String newHash) {
        String id = metadata.getDescribedUri().toString();
        String oldHash = this.accessData.get(id, "hash");
        if (oldHash == null) {
            return true;
        }
        return !oldHash.equals(newHash);
    }

    private URI generateCalendarUri() {
        return new URIImpl(this.baseuri + "Calendar");
    }

    private URI generateComponentUri(Component component) {
        if (component instanceof VTimeZone) {
            return this.generateTimeZoneURI((VTimeZone)component);
        }
        Property uidProperty = component.getProperty("UID");
        if (uidProperty != null) {
            if (this.subCrawlerMode) {
                return SubCrawlerUtil.createChildUri(new URIImpl(this.baseuri), uidProperty.getValue(), "ical");
            }
            return new URIImpl(this.baseuri + uidProperty.getValue());
        }
        return this.generateSumOfAllPropertiesURI(component);
    }

    private URI generateTimeZoneURI(VTimeZone component) {
        Property tzidProperty = component.getProperty("TZID");
        if (tzidProperty != null) {
            return this.createTimeZoneURI(tzidProperty.getValue());
        }
        return this.generateSumOfAllPropertiesURI((Component)component);
    }

    private URI generateSumOfAllPropertiesURI(Component component) {
        StringBuffer sumOfAllProperties = new StringBuffer("");
        PropertyList propertyList = component.getProperties();
        for (Property property : propertyList) {
            sumOfAllProperties.append(property.getValue());
        }
        if (this.subCrawlerMode) {
            return SubCrawlerUtil.createChildUri(new URIImpl(this.baseuri), StringUtil.sha1Hash(sumOfAllProperties.toString()), "ical");
        }
        return new URIImpl(this.baseuri + StringUtil.sha1Hash(sumOfAllProperties.toString()));
    }

    private URI generateAnonymousComponentUri(Component component) {
        if (this.subCrawlerMode) {
            return SubCrawlerUtil.createChildUri(new URIImpl(this.baseuri), component.getName() + "-" + UUID.randomUUID().toString(), "ical");
        }
        return new URIImpl(this.baseuri + component.getName() + "-" + UUID.randomUUID().toString());
    }

    private URI createTimeZoneURI(String tzidParamValue) {
        if (this.subCrawlerMode) {
            return SubCrawlerUtil.createChildUri(new URIImpl(this.baseuri), tzidParamValue, "ical");
        }
        return new URIImpl(this.baseuri + tzidParamValue);
    }

    private Resource generateAnonymousNode(RDFContainer rdfContainer) {
        return ModelUtil.generateRandomResource(rdfContainer.getModel());
    }

    private Node getRdfPropertyValue(RDFContainer rdfContainer, String propertyValue, Parameter actualTzidParameter, Parameter actualValueParameter, String defaultType) {
        if (defaultType.equals("NCAL-DATE-TIME")) {
            return this.getNcalDateTime(rdfContainer, propertyValue, actualTzidParameter, actualValueParameter);
        }
        if (actualValueParameter == null && defaultType.equals("URI") || actualValueParameter != null && actualValueParameter.getValue().equals("URI")) {
            URI uri = this.tryToCreateAnUri(rdfContainer, propertyValue);
            this.addStatement(rdfContainer, (Resource)uri, RDF.type, RDFS.Resource);
            return uri;
        }
        if (actualValueParameter == null && defaultType.equals("PERIOD") || actualValueParameter != null && actualValueParameter.getValue().equals("PERIOD")) {
            return this.createPeriod(rdfContainer, propertyValue);
        }
        Literal literal = null;
        URI datatypeURI = null;
        String rdfPropertyValue = null;
        if (actualValueParameter != null) {
            String valueParameterString = actualValueParameter.getValue();
            datatypeURI = this.convertValueParameterToXSDDatatype(valueParameterString);
            rdfPropertyValue = this.convertIcalValueToXSDValue(propertyValue, valueParameterString);
            literal = datatypeURI == null ? rdfContainer.getModel().createPlainLiteral(rdfPropertyValue) : rdfContainer.getModel().createDatatypeLiteral(rdfPropertyValue, datatypeURI);
        } else if (defaultType != null) {
            datatypeURI = this.convertValueParameterToXSDDatatype(defaultType);
            rdfPropertyValue = this.convertIcalValueToXSDValue(propertyValue, defaultType);
            literal = datatypeURI == null ? rdfContainer.getModel().createPlainLiteral(rdfPropertyValue) : rdfContainer.getModel().createDatatypeLiteral(rdfPropertyValue, datatypeURI);
        } else {
            literal = rdfContainer.getModel().createPlainLiteral(propertyValue);
        }
        return literal;
    }

    private Node createPeriod(RDFContainer rdfContainer, String propertyValue) {
        String[] values = propertyValue.split("/");
        if (values.length != 2) {
            return null;
        }
        Resource periodResource = this.generateAnonymousNode(rdfContainer);
        this.addStatement(rdfContainer, periodResource, RDF.type, NCAL.NcalPeriod);
        this.addStatement(rdfContainer, periodResource, NCAL.periodBegin, rdfContainer.getModel().createDatatypeLiteral(this.convertIcalDateTimeToXSDDateTime(values[0]), XSD._dateTime));
        if (values[1].contains("P")) {
            this.addStatement(rdfContainer, periodResource, NCAL.periodDuration, rdfContainer.getModel().createDatatypeLiteral(this.convertIcalDurationToXSDDayTimeDuration(values[1]), XSD_DAY_TIME_DURATION));
        } else {
            this.addStatement(rdfContainer, periodResource, NCAL.periodEnd, rdfContainer.getModel().createDatatypeLiteral(this.convertIcalDateTimeToXSDDateTime(values[1]), XSD._dateTime));
        }
        return periodResource;
    }

    private Node getNcalDateTime(RDFContainer rdfContainer, String icalValue, Parameter tzidParameter, Parameter valueParameter) {
        Resource ncalDateTimeNode = this.generateAnonymousNode(rdfContainer);
        if (valueParameter == null || valueParameter.getValue().equals("DATE-TIME")) {
            String rdfPropertyValue = this.convertIcalDateTimeToXSDDateTime(icalValue);
            this.addStatement(rdfContainer, ncalDateTimeNode, RDF.type, NCAL.NcalDateTime);
            this.addStatement(rdfContainer, ncalDateTimeNode, NCAL.dateTime, rdfContainer.getModel().createDatatypeLiteral(rdfPropertyValue, XSD._dateTime));
            if (tzidParameter != null) {
                URI timezoneURI = this.createTimeZoneURI(tzidParameter.getValue());
                this.addStatement(rdfContainer, ncalDateTimeNode, NCAL.ncalTimezone, timezoneURI);
                this.addStatement(rdfContainer, (Resource)timezoneURI, RDF.type, NCAL.Timezone);
            }
        } else if (valueParameter.getValue().equals("DATE")) {
            String rdfPropertyValue = this.convertIcalDateToXSDDate(icalValue);
            this.addStatement(rdfContainer, ncalDateTimeNode, RDF.type, NCAL.NcalDateTime);
            this.addStatement(rdfContainer, ncalDateTimeNode, NCAL.date, rdfContainer.getModel().createDatatypeLiteral(rdfPropertyValue, XSD._date));
        } else if (valueParameter.getValue().equals("PERIOD")) {
            return this.createPeriod(rdfContainer, icalValue);
        }
        return ncalDateTimeNode;
    }

    private List<Node> getMultipleRdfPropertyValues(RDFContainer rdfContainer, Property property, String defaultType) {
        String totalPropertyValue = property.getValue();
        if (totalPropertyValue == null) {
            return null;
        }
        String[] valuesArray = totalPropertyValue.split(",");
        LinkedList<Node> resultList = new LinkedList<Node>();
        for (int i = 0; i < valuesArray.length; ++i) {
            Node currentValue = this.getRdfPropertyValue(rdfContainer, valuesArray[i], property.getParameter("TZID"), property.getParameter("VALUE"), defaultType);
            resultList.add(currentValue);
        }
        return resultList;
    }

    private Node getRdfPropertyValue(RDFContainer rdfContainer, Property property, String defaultType) {
        return this.getRdfPropertyValue(rdfContainer, property.getValue(), property.getParameter("TZID"), property.getParameter("VALUE"), defaultType);
    }

    private URI tryToCreateAnUri(RDFContainer rdfContainer, String propertyValue) {
        URI uri = null;
        if (propertyValue.indexOf(58) == -1) {
            uri = rdfContainer.getModel().createURI("uri:" + propertyValue);
        } else {
            try {
                uri = rdfContainer.getModel().createURI(propertyValue);
            }
            catch (Exception e) {
                uri = rdfContainer.getModel().createURI(this.baseuri + propertyValue);
            }
        }
        return uri;
    }

    private String convertIcalValueToXSDValue(String value, String icalDataType) {
        if (icalDataType == null) {
            return value;
        }
        if (icalDataType.equals("DATE-TIME")) {
            return this.convertIcalDateTimeToXSDDateTime(value);
        }
        if (icalDataType.equals("DATE")) {
            return this.convertIcalDateToXSDDate(value);
        }
        return value;
    }

    public String convertIcalDurationToXSDDayTimeDuration(String string) {
        if (!this.icalDurationPattern.matcher(string).matches()) {
            throw new RuntimeException("wrong duration format");
        }
        boolean positive = true;
        int weeks = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        if (string.charAt(0) == '-') {
            positive = false;
            string = string.substring(2);
        } else {
            string = string.charAt(0) == '+' ? string.substring(2) : string.substring(1);
        }
        StringTokenizer tokenizer = new StringTokenizer(string, "+-PWDTHMS", true);
        while (tokenizer.hasMoreTokens()) {
            String numberToken = tokenizer.nextToken();
            if (numberToken.equals("T")) continue;
            String unitNameToken = tokenizer.nextToken();
            if (unitNameToken.equals("W")) {
                weeks += Integer.parseInt(numberToken);
                continue;
            }
            if (unitNameToken.equals("D")) {
                days += Integer.parseInt(numberToken);
                continue;
            }
            if (unitNameToken.equals("H")) {
                hours += Integer.parseInt(numberToken);
                continue;
            }
            if (unitNameToken.equals("M")) {
                minutes += Integer.parseInt(numberToken);
                continue;
            }
            if (!unitNameToken.equals("S")) continue;
            seconds += Integer.parseInt(numberToken);
        }
        long totalNumberOfSeconds = seconds + 60 * minutes + 3600 * hours + 86400 * days + 604800 * weeks;
        String resultString = "";
        if (totalNumberOfSeconds == 0L) {
            resultString = "P0S";
        } else {
            resultString = (positive ? "" : "-") + "P";
            if (totalNumberOfSeconds / 86400L != 0L) {
                resultString = resultString + "" + totalNumberOfSeconds / 86400L + "D";
            }
            if ((totalNumberOfSeconds %= 86400L) != 0L) {
                resultString = resultString + "T";
            }
            if (totalNumberOfSeconds / 3600L != 0L) {
                resultString = resultString + "" + totalNumberOfSeconds / 3600L + "H";
            }
            if ((totalNumberOfSeconds %= 3600L) / 60L != 0L) {
                resultString = resultString + "" + totalNumberOfSeconds / 60L + "M";
            }
            if ((totalNumberOfSeconds %= 60L) != 0L) {
                resultString = resultString + "" + totalNumberOfSeconds + "S";
            }
        }
        return resultString;
    }

    private String convertIcalDateToXSDDate(String icalDate) {
        if (icalDate.length() != 8) {
            throw new IllegalArgumentException("Invalid ical date: " + icalDate);
        }
        String year = icalDate.substring(0, 4);
        String month = icalDate.substring(4, 6);
        String day = icalDate.substring(6, 8);
        return year + "-" + month + "-" + day;
    }

    private String convertIcalDateTimeToXSDDateTime(String icalDateTime) {
        if (icalDateTime.length() < 15 || icalDateTime.length() > 16) {
            throw new IllegalArgumentException("Invalid ical datetime: " + icalDateTime);
        }
        String date = this.convertIcalDateToXSDDate(icalDateTime.substring(0, 8));
        String hour = icalDateTime.substring(9, 11);
        String minute = icalDateTime.substring(11, 13);
        String second = icalDateTime.substring(13, 15);
        String z = icalDateTime.length() == 16 ? "Z" : "";
        return date + "T" + hour + ":" + minute + ":" + second + z;
    }

    private URI convertValueParameterToXSDDatatype(String valueString) {
        URI datatypeURI = null;
        if (valueString.equalsIgnoreCase("TEXT")) {
            datatypeURI = null;
        } else if (valueString.equalsIgnoreCase("BINARY")) {
            datatypeURI = null;
        } else if (valueString.equalsIgnoreCase("BOOLEAN")) {
            datatypeURI = null;
        } else if (valueString.equalsIgnoreCase("CAL-ADDRESS")) {
            datatypeURI = null;
        } else if (valueString.equalsIgnoreCase("DATE")) {
            datatypeURI = XSD._date;
        } else if (valueString.equalsIgnoreCase("DATE-TIME")) {
            datatypeURI = XSD._dateTime;
        } else if (valueString.equalsIgnoreCase("DURATION")) {
            datatypeURI = XSD_DAY_TIME_DURATION;
        } else if (valueString.equalsIgnoreCase("FLOAT")) {
            datatypeURI = XSD._float;
        } else if (valueString.equals("INTEGER")) {
            datatypeURI = XSD._integer;
        } else if (valueString.equalsIgnoreCase("PERIOD")) {
            datatypeURI = null;
        } else if (valueString.equalsIgnoreCase("RECUR")) {
            datatypeURI = null;
        } else if (valueString.equalsIgnoreCase("TIME")) {
            datatypeURI = XSD._time;
        } else if (valueString.equalsIgnoreCase("URI")) {
            datatypeURI = XSD._anyURI;
        } else if (valueString.equalsIgnoreCase("UTC-OFFSET")) {
            datatypeURI = null;
        } else {
            this.logger.warn("Unknown value parameter: " + valueString);
        }
        return datatypeURI;
    }

    private void closeClosable(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                this.logger.warn("Couldn't close the stream");
            }
        }
    }
}

