/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.filesystem;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.semanticdesktop.aperture.accessor.DataAccessor;
import org.semanticdesktop.aperture.accessor.DataAccessorFactory;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.UrlNotFoundException;
import org.semanticdesktop.aperture.crawler.ExitCode;
import org.semanticdesktop.aperture.crawler.base.CrawlerBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.datasource.filesystem.FileSystemDataSource;
import org.semanticdesktop.aperture.util.OSUtils;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemCrawler
extends CrawlerBase {
    private static final boolean DEFAULT_IGNORE_HIDDEN_FILES = true;
    private static final boolean DEFAULT_FOLLOW_SYMBOLIC_LINKS = false;
    private static final boolean DEFAULT_SUPPRESS_PARENT_CHILD_LINKS = false;
    private static final int DEFAULT_MAX_DEPTH = Integer.MAX_VALUE;
    private static final long DEFAULT_MAX_SIZE = Long.MAX_VALUE;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean ignoreHiddenFiles;
    private boolean followSymbolicLinks;
    private boolean suppressParentChildLinks;
    private long maximumSize;
    private DataAccessorFactory accessorFactory;
    private HashMap params;
    private File root;
    private FileSystemDataSource source;

    protected ExitCode crawlObjects() {
        DataSource dataSource = this.getDataSource();
        if (!(dataSource instanceof FileSystemDataSource)) {
            return this.reportFatalErrorCause("wrong data source type, should be " + FileSystemDataSource.class.getName() + " is: " + dataSource.getClass().getName());
        }
        this.source = (FileSystemDataSource)dataSource;
        String rootFolder = this.source.getRootFolder();
        if (rootFolder == null) {
            return this.reportFatalErrorCause("rootFolder property missing");
        }
        this.root = new File(rootFolder);
        if (!this.root.exists()) {
            return this.reportFatalErrorCause("root folder does not exist: '" + this.root + "'");
        }
        try {
            this.root = this.root.getCanonicalFile();
        }
        catch (IOException e) {
            return this.reportFatalErrorCause("unable to determine canonical file of root folder " + this.root, e);
        }
        Integer i = this.source.getMaximumDepth();
        int maxDepth = i == null ? Integer.MAX_VALUE : i;
        Long l = this.source.getMaximumSize();
        this.maximumSize = l == null ? Long.MAX_VALUE : l;
        Boolean b = this.source.getIncludeHiddenResources();
        this.ignoreHiddenFiles = b == null ? true : b == false;
        b = this.source.getFollowSymbolicLinks();
        this.followSymbolicLinks = b == null ? false : b;
        b = this.source.getSuppressParentChildLinks();
        this.suppressParentChildLinks = b == null ? false : b;
        this.params = new HashMap(2);
        this.getAccessorFactory();
        boolean crawlCompleted = this.crawlFileTree(this.root, maxDepth);
        this.params = null;
        return crawlCompleted ? ExitCode.COMPLETED : ExitCode.STOP_REQUESTED;
    }

    private void getAccessorFactory() {
        if (this.accessorRegistry == null) {
            throw new IllegalStateException("DataAccessorRegistry not set");
        }
        Set factories = this.accessorRegistry.get("file");
        if (factories == null || factories.isEmpty()) {
            throw new IllegalStateException("Could not retrieve a file data accessor");
        }
        this.accessorFactory = (DataAccessorFactory)factories.iterator().next();
    }

    private boolean crawlFileTree(File file, int depth) {
        try {
            String absolutePath = file.getAbsolutePath();
            String canonicalPath = file.getCanonicalPath();
            if (!this.followSymbolicLinks && !absolutePath.equals(canonicalPath)) {
                return true;
            }
            file = new File(canonicalPath);
        }
        catch (IOException e) {
            this.logger.warn("unable to resolve file to its canocical form, continuing with original file: " + file, e);
        }
        if (file.isFile() && depth >= 0) {
            boolean smallerThanMax;
            boolean inDomain = this.inDomain(file.toURI().toString());
            boolean canRead = file.canRead();
            boolean bl = smallerThanMax = file.length() <= this.maximumSize;
            if (inDomain && canRead && smallerThanMax) {
                this.crawlSingleFile(file);
            } else if (!inDomain) {
                this.logger.info("File " + file.toURI() + " is outside the domain boundaries for this data source. Skipping.");
            } else if (!canRead) {
                this.logger.info("Can't read file " + file.toURI() + ". Skipping.");
            } else if (!smallerThanMax) {
                this.logger.info("File " + file.toURI() + " exceeds the maximum size specified for this data source. Skipping.");
            }
            return true;
        }
        if (file.isDirectory() && depth >= 0) {
            if (this.inDomain(file.toURI().toString())) {
                this.crawlSingleFile(file);
            } else {
                this.logger.info("Directory " + file.toURI() + " is not in domain. Skipping.");
            }
            if (OSUtils.isMac() && OSUtils.isMacOSXBundle(file)) {
                return true;
            }
            if (depth > 0 && this.inDomain(file.toURI().toString())) {
                return this.filterThroughFolderContent(file, depth);
            }
            return true;
        }
        return true;
    }

    private boolean filterThroughFolderContent(File file, int depth) {
        CrawlerFileFilter filter = new CrawlerFileFilter(depth);
        file.listFiles(filter);
        return filter.getResult();
    }

    private boolean iterateOverFolderContent(File file, int depth) {
        int i;
        File[] nestedFiles = file.listFiles();
        if (nestedFiles == null) {
            return true;
        }
        for (i = 0; !this.stopRequested && i < nestedFiles.length; ++i) {
            boolean scanCompleted;
            File nestedFile = nestedFiles[i];
            if (this.ignoreHiddenFiles && nestedFile.isHidden() || (scanCompleted = this.crawlFileTree(nestedFile, depth - 1))) continue;
            return false;
        }
        return i == nestedFiles.length;
    }

    private void crawlSingleFile(File file) {
        String url = file.toURI().toString();
        this.reportAccessingObject(url);
        boolean knownObject = this.accessData == null ? false : this.accessData.isKnownId(url);
        RDFContainerFactory containerFactory = this.getRDFContainerFactory(url);
        DataAccessor accessor = this.accessorFactory.get();
        this.params.put("file", file);
        if (this.suppressParentChildLinks) {
            this.params.put("suppressParentChildLinks", Boolean.TRUE);
        }
        try {
            DataObject dataObject = accessor.getDataObjectIfModified(url, this.source, this.accessData, this.params, containerFactory);
            if (dataObject == null) {
                this.reportUnmodifiedDataObject(url);
            } else {
                if (file.equals(this.root)) {
                    dataObject.getMetadata().add(NIE.rootElementOf, this.source.getID());
                }
                if (knownObject) {
                    this.reportModifiedDataObject(dataObject);
                } else {
                    this.reportNewDataObject(dataObject);
                }
            }
        }
        catch (UrlNotFoundException e) {
            this.logger.warn("unable to access " + url, e);
        }
        catch (IOException e) {
            this.logger.warn("I/O error while processing " + url, e);
        }
    }

    private class CrawlerFileFilter
    implements FileFilter {
        private int depth;
        private boolean result;

        public CrawlerFileFilter(int depth) {
            this.depth = depth;
            this.result = true;
        }

        public boolean accept(File nestedFile) {
            if (FileSystemCrawler.this.stopRequested || !this.result) {
                this.result = false;
                return false;
            }
            if (FileSystemCrawler.this.ignoreHiddenFiles && nestedFile.isHidden()) {
                return false;
            }
            this.result = FileSystemCrawler.this.crawlFileTree(nestedFile, this.depth - 1);
            return false;
        }

        public boolean getResult() {
            return this.result;
        }
    }
}

