/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.semanticdesktop.aperture.crawler.CrawlReport;
import org.semanticdesktop.aperture.crawler.ExitCode;
import org.semanticdesktop.aperture.util.DateUtil;
import org.semanticdesktop.aperture.util.SimpleSAXAdapter;
import org.semanticdesktop.aperture.util.SimpleSAXParser;
import org.semanticdesktop.aperture.util.XmlWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class CrawlReportBase
implements CrawlReport {
    public static final String CRAWL_REPORT_TAG = "crawlReport";
    public static final String VERSION_ATTR = "version";
    public static final String CRAWL_STARTED_TAG = "crawlStarted";
    public static final String CRAWL_STOPPED_TAG = "crawlStopped";
    public static final String EXIT_CODE_TAG = "exitCode";
    public static final String COMPLETED_VALUE = "completed";
    public static final String STOP_REQUESTED_VALUE = "stopRequested";
    public static final String FATAL_ERROR_VALUE = "fatalError";
    public static final String NEW_COUNT_TAG = "newCount";
    public static final String CHANGED_COUNT_TAG = "changedCount";
    public static final String REMOVED_COUNT_TAG = "removedCount";
    public static final String UNCHANGED_COUNT_TAG = "unchangedCount";
    private long crawlStarted = -1L;
    private long crawlStopped = -1L;
    private ExitCode exitCode = null;
    private Throwable fatalErrorCause;
    private int newCount = 0;
    private int changedCount = 0;
    private int removedCount = 0;
    private int unchangedCount = 0;

    public void setCrawlStarted(long crawlStarted) {
        this.crawlStarted = crawlStarted;
    }

    public long getCrawlStarted() {
        return this.crawlStarted;
    }

    public void setCrawlStopped(long crawlStopped) {
        this.crawlStopped = crawlStopped;
    }

    public long getCrawlStopped() {
        return this.crawlStopped;
    }

    public void setExitCode(ExitCode exitCode) {
        this.exitCode = exitCode;
    }

    public ExitCode getExitCode() {
        return this.exitCode;
    }

    public void setNewCount(int newCount) {
        this.newCount = newCount;
    }

    public void increaseNewCount() {
        ++this.newCount;
    }

    public int getNewCount() {
        return this.newCount;
    }

    public void setChangedCount(int changedCount) {
        this.changedCount = changedCount;
    }

    public void increaseChangedCount() {
        ++this.changedCount;
    }

    public int getChangedCount() {
        return this.changedCount;
    }

    public void setRemovedCount(int removedCount) {
        this.removedCount = removedCount;
    }

    public void increaseRemovedCount() {
        ++this.removedCount;
    }

    public int getRemovedCount() {
        return this.removedCount;
    }

    public Throwable getFatalErrorCause() {
        return this.fatalErrorCause;
    }

    public void setFatalErrorCause(Throwable fatalErrorCause) {
        this.fatalErrorCause = fatalErrorCause;
    }

    public void setUnchangedCount(int unchangedCount) {
        this.unchangedCount = unchangedCount;
    }

    public void increaseUnchangedCount() {
        ++this.unchangedCount;
    }

    public int getUnchangedCount() {
        return this.unchangedCount;
    }

    public int getTotalCount() {
        return this.newCount + this.changedCount + this.unchangedCount;
    }

    public String toString() {
        return "CrawlReport[crawlStarted=" + this.crawlStarted + ", crawlStopped=" + this.crawlStopped + ", exitCode=" + this.exitCode + ", newCount=" + this.newCount + ", changedCount=" + this.changedCount + ", removedCount=" + this.removedCount + ", unchangedCount=" + this.unchangedCount + "]";
    }

    public void write(OutputStream stream) throws IOException {
        Date date;
        XmlWriter xmlWriter = new XmlWriter(stream);
        xmlWriter.setPrettyPrint(true);
        xmlWriter.startDocument();
        xmlWriter.setAttribute(VERSION_ATTR, "1.0");
        xmlWriter.startTag(CRAWL_REPORT_TAG);
        if (this.crawlStarted >= 0L) {
            date = new Date(this.crawlStarted);
            xmlWriter.textElement(CRAWL_STARTED_TAG, DateUtil.dateTime2String(date));
        }
        if (this.crawlStopped >= 0L) {
            date = new Date(this.crawlStopped);
            xmlWriter.textElement(CRAWL_STOPPED_TAG, DateUtil.dateTime2String(date));
        }
        if (this.exitCode != null) {
            String value = null;
            if (this.exitCode.equals(ExitCode.COMPLETED)) {
                value = COMPLETED_VALUE;
            } else if (this.exitCode.equals(ExitCode.STOP_REQUESTED)) {
                value = STOP_REQUESTED_VALUE;
            } else if (this.exitCode.equals(ExitCode.FATAL_ERROR)) {
                value = FATAL_ERROR_VALUE;
            }
            if (value != null) {
                xmlWriter.textElement(EXIT_CODE_TAG, value);
            }
        }
        if (this.newCount >= 0) {
            xmlWriter.textElement(NEW_COUNT_TAG, String.valueOf(this.newCount));
        }
        if (this.changedCount >= 0) {
            xmlWriter.textElement(CHANGED_COUNT_TAG, String.valueOf(this.changedCount));
        }
        if (this.removedCount >= 0) {
            xmlWriter.textElement(REMOVED_COUNT_TAG, String.valueOf(this.removedCount));
        }
        if (this.unchangedCount >= 0) {
            xmlWriter.textElement(UNCHANGED_COUNT_TAG, String.valueOf(this.unchangedCount));
        }
        xmlWriter.endTag(CRAWL_REPORT_TAG);
        xmlWriter.endDocument();
    }

    public void read(InputStream stream) throws IOException {
        try {
            SimpleSAXParser parser = new SimpleSAXParser();
            parser.setListener(new CrawlReportParser());
            parser.parse(stream);
        }
        catch (ParserConfigurationException e) {
            IOException ie = new IOException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        catch (SAXException e) {
            IOException ie = new IOException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    private class CrawlReportParser
    extends SimpleSAXAdapter {
        private Logger logger = LoggerFactory.getLogger(this.getClass());

        private CrawlReportParser() {
        }

        public void startTag(String tagName, Map atts, String text) throws SAXException {
            if (text != null && !text.equals("")) {
                try {
                    this.handleTag(tagName, atts, text);
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
        }

        private void handleTag(String tagName, Map atts, String text) {
            if (CrawlReportBase.CRAWL_STARTED_TAG.equals(tagName)) {
                try {
                    Date date = DateUtil.string2DateTime(text);
                    CrawlReportBase.this.crawlStarted = date.getTime();
                }
                catch (ParseException e) {
                    this.logger.warn("invalid date: " + text, e);
                }
            } else if (CrawlReportBase.CRAWL_STOPPED_TAG.equals(tagName)) {
                try {
                    Date date = DateUtil.string2DateTime(text);
                    CrawlReportBase.this.crawlStopped = date.getTime();
                }
                catch (ParseException e) {
                    this.logger.warn("invalid date: " + text, e);
                }
            } else if (CrawlReportBase.EXIT_CODE_TAG.equals(tagName)) {
                if (CrawlReportBase.COMPLETED_VALUE.equals(text)) {
                    CrawlReportBase.this.exitCode = ExitCode.COMPLETED;
                } else if (CrawlReportBase.STOP_REQUESTED_VALUE.equals(text)) {
                    CrawlReportBase.this.exitCode = ExitCode.STOP_REQUESTED;
                } else if (CrawlReportBase.FATAL_ERROR_VALUE.equals(text)) {
                    CrawlReportBase.this.exitCode = ExitCode.FATAL_ERROR;
                } else {
                    this.logger.warn("unknown exit code: " + text);
                }
            } else if (CrawlReportBase.NEW_COUNT_TAG.equals(tagName)) {
                CrawlReportBase.this.newCount = this.parseInt(text, CrawlReportBase.this.newCount);
            } else if (CrawlReportBase.CHANGED_COUNT_TAG.equals(tagName)) {
                CrawlReportBase.this.changedCount = this.parseInt(text, CrawlReportBase.this.changedCount);
            } else if (CrawlReportBase.REMOVED_COUNT_TAG.equals(tagName)) {
                CrawlReportBase.this.removedCount = this.parseInt(text, CrawlReportBase.this.removedCount);
            } else if (CrawlReportBase.UNCHANGED_COUNT_TAG.equals(tagName)) {
                CrawlReportBase.this.unchangedCount = this.parseInt(text, CrawlReportBase.this.unchangedCount);
            }
        }

        private int parseInt(String text, int oldValue) {
            try {
                return Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                this.logger.warn("invalid int: " + text, e);
                return oldValue;
            }
        }
    }
}

