/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.addressbook.thunderbird;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.addressbook.thunderbird.THUNDERBIRDADDRESSBOOKDS;
import org.semanticdesktop.aperture.addressbook.thunderbird.ThunderbirdAddressbookDataSource;
import org.semanticdesktop.aperture.detector.DataSourceDescription;
import org.semanticdesktop.aperture.detector.DataSourceDetector;
import org.semanticdesktop.aperture.rdf.impl.RDFContainerImpl;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.util.OSUtils;
import org.semanticdesktop.aperture.util.RegistryReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThunderbirdAddressbookDetector
implements DataSourceDetector {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String URI = "urn:nepomuk:software:thunderbird";

    public String getURI() {
        return URI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, String>> readIni(File file) {
        LinkedHashMap<String, Map<String, String>> sections = new LinkedHashMap<String, Map<String, String>>();
        String currentSection = null;
        LinkedHashMap<String, String> currentProps = new LinkedHashMap<String, String>();
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    char firstChar;
                    if (line.length() <= 0 || (firstChar = line.charAt(0)) == ';' || firstChar == '#') continue;
                    if (line.charAt(0) == '[') {
                        if (currentSection != null) {
                            sections.put(currentSection, currentProps);
                            currentProps = new LinkedHashMap();
                        }
                        currentSection = line.substring(1, line.length() - 1);
                        continue;
                    }
                    int i = line.indexOf(61);
                    if (i >= 1) {
                        String key = line.substring(0, i).trim();
                        String value = line.substring(i + 1).trim();
                        currentProps.put(key, value);
                        continue;
                    }
                    throw new ParseException("Could not parse ini file. Expected section or variable, got: " + line, 0);
                }
                if (currentSection != null) {
                    sections.put(currentSection, currentProps);
                }
            }
            finally {
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return sections;
        }
        return sections;
    }

    private List<String> getLinuxThunderbirdDirs() {
        String home = System.getProperty("user.home");
        Vector<String> res = new Vector<String>();
        res.add(home + File.separator + ".mozilla-thunderbird");
        res.add(home + File.separator + ".mozilla/thunderbird");
        res.add(home + File.separator + ".thunderbird");
        return res;
    }

    private List<String> getWinThunderbirdDirs() {
        String home = System.getProperty("user.home");
        Vector<String> res = new Vector<String>();
        String path = RegistryReader.getCurrentUserAppDataFolderPath();
        if (path != null) {
            res.add(path + "\\Thunderbird");
        }
        if ((path = RegistryReader.getCurrentUserLocalAppDataFolderPath()) != null) {
            res.add(path + "\\Thunderbird");
        }
        res.add(home + File.separator + "Application Data\\Thunderbird");
        res.add(home + File.separator + "Local Settings\\Application Data\\Thunderbird");
        res.add(home + File.separator + "Anwendungsdaten\\Thunderbird");
        res.add(home + File.separator + "Lokale Einstellungen\\Anwendungsdaten\\Thunderbird");
        return res;
    }

    private List<String> getMacThunderbirdDirs() {
        String home = System.getProperty("user.home");
        Vector<String> res = new Vector<String>();
        res.add(home + File.separator + "Library/Thunderbird");
        return res;
    }

    @Override
    public List<DataSourceDescription> detect() throws Exception {
        Map<String, String> props;
        String p;
        List<String> paths;
        this.log.debug("Detecting thunderbird.");
        if (OSUtils.isLinux()) {
            paths = this.getLinuxThunderbirdDirs();
        } else if (OSUtils.isMac()) {
            paths = this.getMacThunderbirdDirs();
        } else if (OSUtils.isWindows()) {
            paths = this.getWinThunderbirdDirs();
        } else {
            throw new Exception("Your operating system '" + System.getProperty("os.name") + "' aint supported yet.");
        }
        File thunderbird = null;
        Iterator<String> i$ = paths.iterator();
        while (i$.hasNext() && !(thunderbird = new File(p = i$.next())).exists()) {
        }
        if (!thunderbird.exists()) {
            this.log.debug("No thunderbird directory found.");
            return Collections.emptyList();
        }
        Map<String, Map<String, String>> ini = this.readIni(new File(thunderbird, "profiles.ini"));
        String defaultProfile = null;
        int i = 0;
        while ((props = ini.get("Profile" + i)) != null) {
            if (props.containsKey("Default")) {
                defaultProfile = props.get("Path");
                break;
            }
            ++i;
        }
        if (defaultProfile == null) {
            if (i == 1) {
                defaultProfile = ini.get("Profile0").get("Path");
            } else {
                this.log.debug("Found thunderbird directory - but could not find default folder.");
                return Collections.emptyList();
            }
        }
        ThunderbirdAddressbookDataSource ds = new ThunderbirdAddressbookDataSource();
        Model m = RDF2Go.getModelFactory().createModel();
        m.open();
        ds.setConfiguration(new RDFContainerImpl(m, ModelUtil.generateRandomURI(m)));
        ds.setName("Thunderbird Addressbook");
        ds.setComment("Contacts from your Thunderbird Addressbook.");
        ds.setThunderbirdAddressbookPath(thunderbird.getAbsolutePath() + File.separator + defaultProfile + File.separator + "abook.mab");
        ArrayList<DataSourceDescription> result = new ArrayList<DataSourceDescription>(1);
        result.add(new DataSourceDescription(ds));
        return result;
    }

    @Override
    public URI getSupportedType() {
        return THUNDERBIRDADDRESSBOOKDS.ThunderbirdAddressbookDataSource;
    }
}

