/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.accessor.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticdesktop.aperture.accessor.DataAccessorFactory;
import org.semanticdesktop.aperture.accessor.DataAccessorRegistry;

public class DataAccessorRegistryImpl
implements DataAccessorRegistry {
    private HashMap factories = new HashMap();

    public void add(DataAccessorFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory is not allowed to be null");
        }
        for (String scheme : factory.getSupportedSchemes()) {
            HashSet<DataAccessorFactory> set = (HashSet<DataAccessorFactory>)this.factories.get(scheme);
            if (set == null) {
                set = new HashSet<DataAccessorFactory>();
                this.factories.put(scheme, set);
            }
            set.add(factory);
        }
    }

    public void remove(DataAccessorFactory factory) {
        for (String scheme : factory.getSupportedSchemes()) {
            Set set = (Set)this.factories.get(scheme);
            if (set == null) continue;
            set.remove(factory);
            if (!set.isEmpty()) continue;
            this.factories.remove(scheme);
        }
    }

    public Set getAll() {
        HashSet result = new HashSet();
        Iterator sets = this.factories.values().iterator();
        while (sets.hasNext()) {
            result.addAll((Set)sets.next());
        }
        return result;
    }

    public Set get(String scheme) {
        Set set = (Set)this.factories.get(scheme);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(set);
    }
}

