/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.accessor.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.DataAccessor;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.UrlNotFoundException;
import org.semanticdesktop.aperture.accessor.base.FileDataObjectBase;
import org.semanticdesktop.aperture.accessor.http.ContentType;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.HttpClientUtil;
import org.semanticdesktop.aperture.util.UrlUtil;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAccessor
implements DataAccessor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ACCESSED_KEY = "accessed";
    private static final int MAX_REDIRECTIONS = 20;
    private int connectTimeout = 20000;
    private int readTimeout = 20000;

    public void setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public DataObject getDataObject(String url, DataSource source, Map params, RDFContainerFactory containerFactory) throws UrlNotFoundException, IOException {
        return this.get(url, source, null, params, containerFactory);
    }

    public DataObject getDataObjectIfModified(String url, DataSource source, AccessData accessData, Map params, RDFContainerFactory containerFactory) throws UrlNotFoundException, IOException {
        return this.get(url, source, accessData, params, containerFactory);
    }

    private DataObject get(String urlString, DataSource source, AccessData accessData, Map params, RDFContainerFactory containerFactory) throws UrlNotFoundException, IOException {
        int responseCode;
        URL url;
        HttpURLConnection connection;
        URIImpl uri;
        block13: {
            String lastUrl;
            uri = null;
            try {
                uri = new URIImpl(urlString);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            String originalUrlString = urlString;
            connection = null;
            int nrRedirections = 0;
            do {
                if (nrRedirections > 20) {
                    throw new IOException("too many redirections, max = 20, url = " + originalUrlString);
                }
                url = new URL(urlString);
                url = UrlUtil.normalizeURL(url);
                urlString = url.toExternalForm();
                Date ifModifiedSince = accessData == null ? null : this.getIfModifiedSince(urlString, accessData);
                try {
                    connection = this.createConnection(url, ifModifiedSince);
                    connection.connect();
                }
                catch (Exception e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new UrlNotFoundException(originalUrlString, "connection resulted in a " + e.getClass() + " exception");
                }
                responseCode = connection.getResponseCode();
                if (!this.isRedirected(responseCode)) break block13;
                lastUrl = urlString;
                urlString = this.getRedirectedUrl(url, connection);
                ++nrRedirections;
                if (accessData != null) {
                    accessData.remove(lastUrl, "date");
                    accessData.remove(lastUrl, ACCESSED_KEY);
                    accessData.put(lastUrl, "redirectsTo", urlString);
                }
                try {
                    uri = new URIImpl(urlString);
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            } while (!urlString.equals(lastUrl));
            throw new UrlNotFoundException("url redirects to itself: " + urlString);
        }
        if (responseCode == 404) {
            throw new UrlNotFoundException(urlString);
        }
        if (responseCode == 304) {
            return null;
        }
        if (responseCode != 200) {
            throw new IOException("Http connection error, response code = " + responseCode + ", url = " + url);
        }
        DataObject result = this.createDataObject(uri, source, connection, containerFactory);
        this.updateAccessData(accessData, urlString, connection.getDate());
        return result;
    }

    private Date getIfModifiedSince(String urlString, AccessData accessData) {
        if (accessData == null) {
            return null;
        }
        String value = accessData.get(urlString, "date");
        if (value == null) {
            return null;
        }
        try {
            long l = Long.parseLong(value);
            return new Date(l);
        }
        catch (NumberFormatException e) {
            this.logger.error("invalid long: " + value, e);
            return null;
        }
    }

    private HttpURLConnection createConnection(URL url, Date ifModifiedSince) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(this.connectTimeout);
        connection.setReadTimeout(this.readTimeout);
        HttpClientUtil.setAcceptGZIPEncoding(connection);
        connection.setInstanceFollowRedirects(false);
        if (ifModifiedSince != null) {
            connection.setIfModifiedSince(ifModifiedSince.getTime());
        }
        return connection;
    }

    private boolean isRedirected(int responseCode) {
        return responseCode == 300 || responseCode == 301 || responseCode == 302 || responseCode == 303;
    }

    private String getRedirectedUrl(URL url, HttpURLConnection connection) throws IOException {
        String newLocation = connection.getHeaderField("Location");
        if (newLocation == null) {
            throw new IOException("missing redirection location");
        }
        return new URL(url, newLocation).toString();
    }

    private DataObject createDataObject(URI uri, DataSource source, HttpURLConnection connection, RDFContainerFactory containerFactory) throws IOException {
        long lastModified;
        long contentLength;
        RDFContainer metadata = containerFactory.getRDFContainer(uri);
        InputStream stream = HttpClientUtil.getInputStream(connection);
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream, 8192);
        }
        FileDataObjectBase object = new FileDataObjectBase(uri, source, metadata, stream);
        String characterSet = null;
        String mimeType = null;
        String contentType = connection.getContentType();
        if (contentType != null) {
            ContentType parsedType = new ContentType(contentType);
            characterSet = parsedType.getCharset();
            mimeType = parsedType.getMimeType();
        }
        if (characterSet == null) {
            characterSet = "ISO-8859-1";
        }
        metadata.add(RDF.type, NFO.RemoteDataObject);
        metadata.add(RDF.type, NIE.InformationElement);
        metadata.add(NIE.characterSet, characterSet);
        if (mimeType != null) {
            metadata.add(NIE.mimeType, mimeType);
        }
        if ((contentLength = (long)connection.getContentLength()) >= 0L) {
            metadata.add(NIE.byteSize, contentLength);
        }
        if ((lastModified = connection.getLastModified()) != 0L) {
            metadata.add(NIE.contentLastModified, new Date(lastModified));
        }
        return object;
    }

    private void updateAccessData(AccessData accessData, String urlString, long date) {
        if (accessData != null) {
            accessData.remove(urlString, ACCESSED_KEY);
            accessData.remove(urlString, "date");
            accessData.remove(urlString, "redirectsTo");
            if (date == 0L) {
                accessData.remove(urlString, "date");
                accessData.remove(urlString, "redirectsTo");
                accessData.put(urlString, ACCESSED_KEY, "");
            } else {
                accessData.remove(urlString, ACCESSED_KEY);
                accessData.remove(urlString, "redirectsTo");
                accessData.put(urlString, "date", String.valueOf(date));
            }
        }
    }
}

