/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.accessor.file;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Map;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.DataAccessor;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.UrlNotFoundException;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.accessor.base.FileDataObjectBase;
import org.semanticdesktop.aperture.accessor.base.FolderDataObjectBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAccessor
implements DataAccessor {
    public static final String FILE_KEY = "file";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public DataObject getDataObject(String url, DataSource source, Map params, RDFContainerFactory containerFactory) throws UrlNotFoundException, IOException {
        return this.get(url, source, null, params, containerFactory);
    }

    public DataObject getDataObjectIfModified(String url, DataSource source, AccessData accessData, Map params, RDFContainerFactory containerFactory) throws UrlNotFoundException, IOException {
        return this.get(url, source, accessData, params, containerFactory);
    }

    private DataObject get(String url, DataSource source, AccessData accessData, Map params, RDFContainerFactory containerFactory) throws UrlNotFoundException, IOException {
        DataObjectBase result;
        if (!url.startsWith("file:")) {
            throw new IllegalArgumentException("non-file scheme: " + url);
        }
        File file = this.getFile(url, params);
        if (!file.exists()) {
            throw new UrlNotFoundException(url);
        }
        boolean isFile = file.isFile();
        boolean isFolder = file.isDirectory();
        if (!isFile && !isFolder) {
            this.logger.warn("not a file nor a folder: " + file);
        }
        if (accessData != null) {
            long lastModified = file.lastModified();
            String value = accessData.get(url, "date");
            if (value != null) {
                try {
                    long registeredDate = Long.parseLong(value);
                    if (registeredDate == lastModified) {
                        return null;
                    }
                }
                catch (NumberFormatException e) {
                    this.logger.error("illegal long: " + value, e);
                }
            }
            accessData.put(url, "date", String.valueOf(lastModified));
        }
        URI id = this.toURI(file);
        boolean addFolderChildren = true;
        if (params != null && params.get("suppressParentChildLinks") != null && params.get("suppressParentChildLinks").equals(Boolean.TRUE)) {
            addFolderChildren = false;
        }
        RDFContainer metadata = this.createMetadata(file, id, isFile, isFolder, addFolderChildren, containerFactory);
        if (isFile) {
            result = file.canRead() ? new FileDataObjectBase(id, source, metadata, file) : new DataObjectBase(id, source, metadata);
            result.getMetadata().add(RDF.type, NFO.FileDataObject);
        } else {
            result = isFolder ? new FolderDataObjectBase(id, source, metadata) : new DataObjectBase(id, source, metadata);
        }
        return result;
    }

    private File getFile(String url, Map params) throws IOException {
        Object value;
        if (params != null && (value = params.get(FILE_KEY)) instanceof File) {
            return (File)value;
        }
        try {
            java.net.URI id = new java.net.URI(url);
            return new File(id);
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException("invalid url");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private RDFContainer createMetadata(File file, URI id, boolean isFile, boolean isFolder, boolean addFolderChildren, RDFContainerFactory containerFactory) {
        File parent;
        String name;
        RDFContainer metadata = containerFactory.getRDFContainer(id);
        metadata.add(RDF.type, NFO.FileDataObject);
        long lastModified = file.lastModified();
        if (lastModified != 0L) {
            metadata.add(NFO.fileLastModified, new Date(lastModified));
        }
        if ((name = file.getName()) != null) {
            metadata.add(NFO.fileName, name);
        }
        if ((parent = file.getParentFile()) != null) {
            metadata.add(NFO.belongsToContainer, this.toURI(parent));
            metadata.add(metadata.getModel().createStatement(this.toURI(parent), RDF.type, NFO.Folder));
        }
        if (isFile) {
            long length = file.length();
            metadata.add(NFO.fileSize, length);
        } else if (isFolder && addFolderChildren) {
            final RDFContainer finalMetadata = metadata;
            file.listFiles(new FileFilter(){

                public boolean accept(File child) {
                    if (child != null) {
                        finalMetadata.add(NIE.hasPart, FileAccessor.this.toURI(child));
                        finalMetadata.add(finalMetadata.getModel().createStatement(FileAccessor.this.toURI(child), RDF.type, NFO.FileDataObject));
                    }
                    return false;
                }
            });
        }
        return metadata;
    }

    private URI toURI(File file) {
        return URIImpl.createURIWithoutChecking(file.toURI().toString());
    }
}

