/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.accessor.base;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.semanticdesktop.aperture.accessor.base.AccessDataImpl;
import org.semanticdesktop.aperture.util.ArrayMap;
import org.semanticdesktop.aperture.util.SimpleSAXAdapter;
import org.semanticdesktop.aperture.util.SimpleSAXParser;
import org.semanticdesktop.aperture.util.XmlWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class FileAccessData
extends AccessDataImpl {
    public static final String REFERRED_ID_TAG = "referredID";
    public static final String AGGREGATED_ID_TAG = "aggregatedID";
    private Logger log = LoggerFactory.getLogger(FileAccessData.class);
    private int autoSaveCounter;
    private int autoSaveInterval;
    private File dataFile;

    public FileAccessData() {
    }

    public FileAccessData(File dataFile) {
        this.dataFile = dataFile;
    }

    public FileAccessData(int autoSaveInterval) {
        this.autoSaveInterval = autoSaveInterval;
    }

    public FileAccessData(File dataFile, int autoSaveInterval) {
        this.dataFile = dataFile;
        this.autoSaveInterval = autoSaveInterval;
    }

    public void setDataFile(File dataFile) {
        this.dataFile = dataFile;
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public int getAutoSaveInterval() {
        return this.autoSaveInterval;
    }

    public void setAutoSaveInterval(int autoSaveInterval) {
        this.autoSaveInterval = autoSaveInterval;
        this.autoSaveCounter = 0;
    }

    public void put(String id, String key, String value) {
        super.put(id, key, value);
        this.updateCounter();
    }

    public String get(String id, String key) {
        this.updateCounter();
        return super.get(id, key);
    }

    private void updateCounter() {
        if (this.autoSaveInterval > 0) {
            ++this.autoSaveCounter;
            if (this.autoSaveCounter == this.autoSaveInterval) {
                this.autoSaveCounter = 0;
                try {
                    this.store();
                }
                catch (IOException ioe) {
                    this.log.warn("Couldn't auto-save the FileAccessData instance", ioe);
                }
            }
        }
    }

    public void initialize() throws IOException {
        this.idMap = null;
        this.referredIDMap = null;
        this.aggregatedIDMap = null;
        super.initialize();
        int oldAutoSaveInterval = this.autoSaveInterval;
        this.autoSaveInterval = 0;
        if (this.dataFile != null && this.dataFile.exists()) {
            FileInputStream fileStream = new FileInputStream(this.dataFile);
            BufferedInputStream buffer = new BufferedInputStream(fileStream);
            GZIPInputStream zipStream = new GZIPInputStream(buffer);
            this.read(zipStream);
            zipStream.close();
        }
        this.autoSaveInterval = oldAutoSaveInterval;
    }

    public void store() throws IOException {
        if (this.dataFile != null) {
            FileOutputStream fileStream = new FileOutputStream(this.dataFile);
            BufferedOutputStream buffer = new BufferedOutputStream(fileStream);
            GZIPOutputStream zipStream = new GZIPOutputStream(buffer);
            this.write(zipStream);
            zipStream.close();
        }
    }

    public void clear() throws IOException {
        super.clear();
        if (this.dataFile != null && this.dataFile.exists()) {
            this.dataFile.delete();
        }
    }

    private void read(InputStream in) throws IOException {
        try {
            SimpleSAXParser parser = new SimpleSAXParser();
            AccessDataParser listener = new AccessDataParser();
            parser.setListener(listener);
            parser.parse(in);
        }
        catch (ParserConfigurationException e) {
            IOException ie = new IOException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        catch (SAXException e) {
            IOException ie = new IOException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    private void write(OutputStream out) throws IOException {
        XmlWriter xmlWriter = new XmlWriter(out);
        xmlWriter.setPrettyPrint(true);
        xmlWriter.startDocument();
        xmlWriter.setAttribute("version", 1);
        xmlWriter.startTag("scanresult");
        for (String id : this.idMap.keySet()) {
            if (id != null) {
                xmlWriter.setAttribute("id", id.toString());
                xmlWriter.startTag("dataobject");
                this.writeInfo(id, xmlWriter);
                xmlWriter.endTag("dataobject");
                continue;
            }
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("Cannot write null id");
        }
        xmlWriter.endTag("scanresult");
        xmlWriter.endDocument();
    }

    private void writeInfo(String id, XmlWriter xmlWriter) throws IOException {
        Set aggregatedIDs;
        Set referredIDs;
        ArrayMap infoMap = (ArrayMap)this.idMap.get(id);
        if (infoMap != null) {
            for (Map.Entry entry : infoMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                xmlWriter.textElement(key, value);
            }
        }
        if ((referredIDs = (Set)this.referredIDMap.get(id)) != null) {
            for (String referredID : referredIDs) {
                xmlWriter.textElement(REFERRED_ID_TAG, referredID);
            }
        }
        if ((aggregatedIDs = this.getAggregatedIDs(id)) != null) {
            for (String aggregatedID : aggregatedIDs) {
                xmlWriter.textElement(AGGREGATED_ID_TAG, aggregatedID);
            }
        }
    }

    private class AccessDataParser
    extends SimpleSAXAdapter {
        private String dataObjectId;

        private AccessDataParser() {
        }

        public void startTag(String tagName, Map atts, String text) throws SAXException {
            block14: {
                if (tagName.equals("scanresult")) {
                    String version = (String)atts.get("version");
                    if (version == null) {
                        throw new SAXException("Scan results file version missing");
                    }
                    try {
                        int versionInt = Integer.parseInt(version);
                        if (versionInt != 1) {
                            throw new SAXException("Unsupported scan results file version: " + version);
                        }
                        break block14;
                    }
                    catch (NumberFormatException e) {
                        throw new SAXException("Illegal scan results file version: " + version);
                    }
                }
                if (tagName.equals("dataobject")) {
                    this.dataObjectId = (String)atts.get("id");
                } else if (tagName.equals(FileAccessData.REFERRED_ID_TAG)) {
                    String referredID = text;
                    if (referredID != null && this.dataObjectId != null) {
                        FileAccessData.this.putReferredID(this.dataObjectId, referredID);
                    }
                } else if (tagName.equals(FileAccessData.AGGREGATED_ID_TAG)) {
                    String aggregatedID = text;
                    if (aggregatedID != null && this.dataObjectId != null) {
                        FileAccessData.this.putAggregatedID(this.dataObjectId, aggregatedID);
                    }
                } else if (this.dataObjectId != null) {
                    FileAccessData.this.put(this.dataObjectId, tagName, text);
                }
            }
        }

        public void endTag(String tagName) {
            if (tagName.equals("dataobject")) {
                this.dataObjectId = null;
            }
        }
    }
}

