/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.accessor.base;

import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataObjectBase
implements DataObject {
    private URI id;
    private DataSource dataSource;
    private RDFContainer metadata;
    private boolean disposed;
    private DataObject wrappedDataObject;

    public DataObjectBase() {
    }

    public DataObjectBase(URI id, DataSource dataSource, RDFContainer metadata) {
        this.id = id;
        this.dataSource = dataSource;
        this.metadata = metadata;
        this.disposed = false;
        metadata.add(RDF.type, NIE.DataObject);
    }

    public void finalize() throws Throwable {
        if (!this.disposed) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("DataObject has not been disposed. URI: " + this.id);
            try {
                this.dispose();
            }
            catch (Throwable t) {
                logger.error("Error while disposing DataObject", t);
            }
        }
        super.finalize();
    }

    public void setID(URI id) {
        this.id = id;
    }

    public URI getID() {
        return this.id;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setMetadata(RDFContainer metadata) {
        this.metadata = metadata;
    }

    public RDFContainer getMetadata() {
        return this.metadata;
    }

    public void dispose() {
        this.disposed = true;
        this.metadata.dispose();
        if (this.wrappedDataObject != null) {
            this.wrappedDataObject.dispose();
        }
    }

    public DataObject getWrappedDataObject() {
        return this.wrappedDataObject;
    }

    public void setWrappedDataObject(DataObject wrappedDataObject) {
        this.wrappedDataObject = wrappedDataObject;
    }

    protected boolean isDisposed() {
        return this.disposed;
    }
}

