/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.accessor.base;

import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends InputStream {
    private InputStream wrappedInputStream;
    private long currentByte;
    private long markedByte;

    public CountingInputStream(InputStream wrappedInputStream) {
        this.wrappedInputStream = wrappedInputStream;
    }

    public long getCurrentByte() {
        return this.currentByte;
    }

    public int available() throws IOException {
        return this.wrappedInputStream.available();
    }

    public void close() throws IOException {
        this.wrappedInputStream.close();
    }

    public boolean equals(Object obj) {
        return this.wrappedInputStream.equals(obj);
    }

    public int hashCode() {
        return this.wrappedInputStream.hashCode();
    }

    public void mark(int readlimit) {
        this.wrappedInputStream.mark(readlimit);
        this.markedByte = this.currentByte;
    }

    public boolean markSupported() {
        return this.wrappedInputStream.markSupported();
    }

    public int read() throws IOException {
        int result = this.wrappedInputStream.read();
        if (result != -1) {
            ++this.currentByte;
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.wrappedInputStream.read(b, off, len);
        if (bytesRead != -1) {
            this.currentByte += (long)bytesRead;
        }
        return bytesRead;
    }

    public int read(byte[] b) throws IOException {
        int bytesRead = this.wrappedInputStream.read(b);
        if (bytesRead != -1) {
            this.currentByte += (long)bytesRead;
        }
        return bytesRead;
    }

    public void reset() throws IOException {
        this.wrappedInputStream.reset();
        this.currentByte = this.markedByte;
    }

    public long skip(long n) throws IOException {
        long bytesSkipped = this.wrappedInputStream.skip(n);
        this.currentByte += bytesSkipped;
        return bytesSkipped;
    }

    public String toString() {
        return this.wrappedInputStream.toString();
    }
}

