/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.datatypes.XMLDatatypeUtil;

public class LiteralImpl
implements Literal {
    private static final long serialVersionUID = -1649571784782592271L;
    private final String label;
    private final String language;
    private final URI datatype;

    public LiteralImpl(String label) {
        this(label, null, null);
    }

    public LiteralImpl(String label, String language) {
        this(label, language, null);
    }

    public LiteralImpl(String label, URI datatype) {
        this(label, null, datatype);
    }

    private LiteralImpl(String label, String language, URI datatype) {
        assert (label != null);
        this.label = label;
        this.language = language == null ? null : language.toLowerCase();
        this.datatype = datatype;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLanguage() {
        return this.language;
    }

    public URI getDatatype() {
        return this.datatype;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Literal) {
            Literal other = (Literal)o;
            if (!this.label.equals(other.getLabel())) {
                return false;
            }
            if (this.datatype == null ? other.getDatatype() != null : !this.datatype.equals(other.getDatatype())) {
                return false;
            }
            return !(this.language == null ? other.getLanguage() != null : !this.language.equals(other.getLanguage()));
        }
        return false;
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.label.length() * 2);
        sb.append('\"');
        sb.append(this.label);
        sb.append('\"');
        if (this.language != null) {
            sb.append('@');
            sb.append(this.language);
        }
        if (this.datatype != null) {
            sb.append("^^");
            sb.append(this.datatype.toString());
        }
        return sb.toString();
    }

    public String stringValue() {
        return this.label;
    }

    public boolean booleanValue() {
        return XMLDatatypeUtil.parseBoolean((String)this.getLabel());
    }

    public byte byteValue() {
        return XMLDatatypeUtil.parseByte((String)this.getLabel());
    }

    public short shortValue() {
        return XMLDatatypeUtil.parseShort((String)this.getLabel());
    }

    public int intValue() {
        return XMLDatatypeUtil.parseInt((String)this.getLabel());
    }

    public long longValue() {
        return XMLDatatypeUtil.parseLong((String)this.getLabel());
    }

    public float floatValue() {
        return XMLDatatypeUtil.parseFloat((String)this.getLabel());
    }

    public double doubleValue() {
        return XMLDatatypeUtil.parseDouble((String)this.getLabel());
    }

    public BigInteger integerValue() {
        return XMLDatatypeUtil.parseInteger((String)this.getLabel());
    }

    public BigDecimal decimalValue() {
        return XMLDatatypeUtil.parseDecimal((String)this.getLabel());
    }

    public XMLGregorianCalendar calendarValue() {
        return XMLDatatypeUtil.parseCalendar((String)this.getLabel());
    }
}

