/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.plugin;

import java.io.File;
import java.util.jar.Attributes;
import net.sf.regain.RegainException;
import net.sf.regain.crawler.config.PreparatorSettings;
import net.sf.regain.crawler.document.Pluggable;
import net.sf.regain.crawler.document.PluggableFactory;
import net.sf.regain.crawler.plugin.CrawlerPlugin;
import net.sf.regain.crawler.plugin.CrawlerPluginManager;

public class CrawlerPluginFactory
extends PluggableFactory {
    private static final String DEFAULT_CRAWLERPLUGIN_PACKAGE = "net.sf.regain.crawler.plugin.plugin";
    private static CrawlerPluginFactory mSingleton = null;
    private CrawlerPluginManager pluginManager = CrawlerPluginManager.getInstance();

    protected CrawlerPluginFactory() {
    }

    public static CrawlerPluginFactory getInstance() {
        if (mSingleton == null) {
            mSingleton = new CrawlerPluginFactory();
        }
        return mSingleton;
    }

    @Override
    protected File getPluggableDir() throws RegainException {
        File preparatorDir = new File("plugins");
        if (!preparatorDir.exists()) {
            mLog.warn("No plugin directory found at " + preparatorDir.getAbsolutePath());
            return null;
        }
        return preparatorDir;
    }

    @Override
    protected void pluggableAfterInit(Pluggable pluggable, PreparatorSettings preparatorSettings) throws RegainException {
        if (preparatorSettings == null) {
            this.pluginManager.registerPlugin((CrawlerPlugin)pluggable);
        } else {
            this.pluginManager.registerPlugin((CrawlerPlugin)pluggable, preparatorSettings.getPriority());
        }
        mLog.info("Plugin " + pluggable.getClass().getName() + " was registered.");
    }

    @Override
    protected String[] getClassNames(File pluggableFile, Attributes attributes) throws RegainException {
        String clazz = attributes.getValue("Plugin-Class");
        if (clazz == null) {
            throw new RegainException("The plugin file " + pluggableFile + " did not have the required attribute 'Plugin-Class' in its manifest.xml.");
        }
        return new String[]{clazz};
    }

    @Override
    protected String getDefaultPackage() {
        return DEFAULT_CRAWLERPLUGIN_PACKAGE;
    }
}

