/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.document;

import java.io.File;
import java.util.jar.Attributes;
import net.sf.regain.RegainException;
import net.sf.regain.RegainToolkit;
import net.sf.regain.crawler.config.PreparatorSettings;
import net.sf.regain.crawler.document.Pluggable;
import net.sf.regain.crawler.document.PluggableFactory;
import net.sf.regain.crawler.document.Preparator;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class PreparatorFactory
extends PluggableFactory {
    private static PreparatorFactory mSingleton;

    public static PreparatorFactory getInstance() {
        if (mSingleton == null) {
            mSingleton = new PreparatorFactory();
        }
        return mSingleton;
    }

    @Override
    protected void pluggableAfterInit(Pluggable pluggable, PreparatorSettings preparatorSettings) throws RegainException {
        if (preparatorSettings == null) {
            return;
        }
        Preparator prep = (Preparator)pluggable;
        String urlRegexAsString = preparatorSettings.getUrlRegex();
        if (urlRegexAsString != null) {
            RE urlRegex;
            try {
                urlRegex = new RE(urlRegexAsString);
            }
            catch (RESyntaxException exc) {
                throw new RegainException("urlRegex of preparator " + prep.getClass().getName() + " has wrong syntax", exc);
            }
            prep.setUrlRegex(urlRegex);
        }
        prep.setPriority(preparatorSettings.getPriority());
    }

    @Override
    protected File getPluggableDir() throws RegainException {
        File preparatorDir = new File("preparator");
        if (!preparatorDir.exists()) {
            throw new RegainException("Preparator directory not found: " + preparatorDir.getAbsolutePath());
        }
        return preparatorDir;
    }

    @Override
    protected String[] getClassNames(File pluggableFile, Attributes attributes) throws RegainException {
        String classNameCsv = attributes.getValue("Preparator-Classes");
        if (classNameCsv == null) {
            throw new RegainException("The manifest in preparator file '" + pluggableFile + "' has no 'Preparator-Classes' attribute");
        }
        String[] classNameArr = RegainToolkit.splitString(classNameCsv, ";", true);
        return classNameArr;
    }

    public Preparator[] createPreparatorArr(PreparatorSettings[] preparatorSettingsArr) throws RegainException {
        return this.createPluggables(preparatorSettingsArr).toArray(new Preparator[0]);
    }

    @Override
    protected String getDefaultPackage() {
        return "net.sf.regain.crawler.preparator";
    }
}

