/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.document;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.regain.RegainException;
import net.sf.regain.crawler.config.PreparatorConfig;
import net.sf.regain.crawler.document.PathElement;
import net.sf.regain.crawler.document.Preparator;
import net.sf.regain.crawler.document.RawDocument;
import net.sf.regain.crawler.document.WriteablePreparator;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public abstract class AbstractPreparator
implements Preparator,
WriteablePreparator {
    private RE mUrlRegex;
    private String mTitle;
    private String mCleanedContent;
    private String mSummary;
    private String mCleanedMetaData;
    private String mHeadlines;
    private PathElement[] mPath;
    private HashMap<String, String> mAdditionalFieldMap;
    private String[] mMimeTypes;
    private int mPriority;

    public AbstractPreparator() {
    }

    public AbstractPreparator(RE urlRegex) {
        this.mUrlRegex = urlRegex;
    }

    public AbstractPreparator(String mimeType) throws RegainException {
        this.mMimeTypes = new String[]{mimeType};
    }

    public AbstractPreparator(String[] mimeTypeArr) throws RegainException {
        this.mMimeTypes = mimeTypeArr;
    }

    private static RE createExtentionRegex(String extention) throws RegainException {
        if (extention == null || extention.length() == 0) {
            return null;
        }
        String regex = "\\." + extention + "$";
        try {
            return new RE(regex, 1);
        }
        catch (RESyntaxException exc) {
            throw new RegainException("Creating accept regex for preparator failed: " + regex, exc);
        }
    }

    private static RE createExtentionRegex(String[] extentionArr) throws RegainException {
        if (extentionArr == null || extentionArr.length == 0) {
            return null;
        }
        StringBuilder buffer = new StringBuilder("\\.(");
        for (int i = 0; i < extentionArr.length; ++i) {
            if (i > 0) {
                buffer.append("|");
            }
            buffer.append(extentionArr[i]);
        }
        buffer.append(")$");
        String urlRegex = buffer.toString();
        try {
            return new RE(urlRegex, 1);
        }
        catch (RESyntaxException exc) {
            throw new RegainException("Creating accept regex for preparator failed: " + urlRegex, exc);
        }
    }

    @Override
    public void init(PreparatorConfig config) throws RegainException {
    }

    @Override
    public void setUrlRegex(RE urlRegex) {
        this.mUrlRegex = urlRegex;
    }

    @Override
    public boolean accepts(RawDocument rawDocument) {
        if (this.mUrlRegex == null) {
            if (this.mMimeTypes != null && this.mMimeTypes.length > 0) {
                for (String mimeType : this.mMimeTypes) {
                    if (!mimeType.equals(rawDocument.getMimeType())) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        return this.mUrlRegex.match(rawDocument.getUrl());
    }

    @Override
    public String getTitle() {
        return this.mTitle;
    }

    @Override
    public void setTitle(String title) {
        this.mTitle = title;
    }

    @Override
    public String getCleanedContent() {
        return this.mCleanedContent;
    }

    @Override
    public void setCleanedContent(String cleanedContent) {
        this.mCleanedContent = cleanedContent;
    }

    @Override
    public String getCleanedMetaData() {
        return this.mCleanedMetaData;
    }

    @Override
    public void setCleanedMetaData(String mCleanedMetaData) {
        this.mCleanedMetaData = mCleanedMetaData;
    }

    @Override
    public String getSummary() {
        return this.mSummary;
    }

    @Override
    public void setSummary(String summary) {
        this.mSummary = summary;
    }

    @Override
    public String getHeadlines() {
        return this.mHeadlines;
    }

    @Override
    public void setHeadlines(String headlines) {
        this.mHeadlines = headlines;
    }

    @Override
    public PathElement[] getPath() {
        return this.mPath;
    }

    public void setPath(PathElement[] path) {
        this.mPath = path;
    }

    @Override
    public Map<String, String> getAdditionalFields() {
        return this.mAdditionalFieldMap;
    }

    @Override
    public void addAdditionalField(String fieldName, String fieldValue) {
        if (this.mAdditionalFieldMap == null) {
            this.mAdditionalFieldMap = new HashMap();
        }
        this.mAdditionalFieldMap.put(fieldName, fieldValue);
    }

    @Override
    public int getPriority() {
        return this.mPriority;
    }

    @Override
    public void setPriority(int priority) {
        this.mPriority = priority;
    }

    @Override
    public void cleanUp() {
        this.mTitle = null;
        this.mCleanedContent = null;
        this.mSummary = null;
        this.mHeadlines = null;
        this.mPath = null;
        this.mAdditionalFieldMap = null;
    }

    protected String concatenateStringParts(List<String> parts, int maxPartsUsed) {
        StringBuilder result = new StringBuilder();
        if (parts.size() > 0) {
            int end = parts.size();
            if (maxPartsUsed < parts.size()) {
                end = maxPartsUsed;
            }
            for (int i = 0; i < end; ++i) {
                if (parts.get(i).length() <= 0) continue;
                result.append(parts.get(i));
                if (i >= end - 1) continue;
                result.append(", ");
            }
        }
        return result.toString();
    }

    @Override
    public void close() throws RegainException {
    }
}

