/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.config;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import net.sf.regain.RegainException;
import net.sf.regain.XmlToolkit;
import net.sf.regain.crawler.config.AuxiliaryField;
import net.sf.regain.crawler.config.CrawlerConfig;
import net.sf.regain.crawler.config.PrefixUrlMatcher;
import net.sf.regain.crawler.config.PreparatorConfig;
import net.sf.regain.crawler.config.PreparatorSettings;
import net.sf.regain.crawler.config.RegexUrlMatcher;
import net.sf.regain.crawler.config.StartUrl;
import net.sf.regain.crawler.config.UrlMatcher;
import net.sf.regain.crawler.config.UrlMatcherResult;
import net.sf.regain.crawler.config.UrlPattern;
import net.sf.regain.crawler.config.WhiteListEntry;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlCrawlerConfig
implements CrawlerConfig {
    private String mProxyHost;
    private String mProxyPort;
    private String mProxyUser;
    private String mProxyPassword;
    private String mUserAgent;
    private boolean mLoadUnparsedUrls;
    private boolean mBuildIndex;
    private int mHttpTimeoutSecs;
    private String mIndexDir;
    private int mMaxFieldLength;
    private int mMaxCycleCount;
    private String mAnalyzerType;
    private String[] mStopWordList;
    private String[] mExclusionList;
    private boolean mWriteAnalysisFiles;
    private int mBreakpointInterval;
    private double mMaxFailedDocuments;
    private String mFinishedWithoutFatalsFileName;
    private String mFinishedWithFatalsFileName;
    private StartUrl[] mStartUrls;
    private UrlPattern[] mHtmlParserUrlPatterns;
    private UrlMatcher[] mBlackList;
    private WhiteListEntry[] mWhiteListEntryArr;
    private String[] mValuePrefetchFields;
    private String[] mUseLinkTextAsTitleRegexList;
    private PreparatorSettings[] mPreparatorSettingsArr;
    private PreparatorSettings[] mCrawlerPluginSettingsArr;
    private AuxiliaryField[] mAuxiliaryFieldArr;
    private String mCrawlerAccessControllerClass;
    private String mCrawlerAccessControllerJar;
    private Properties mCrawlerAccessControllerConfig;
    private int mMaxSummaryLength;
    private boolean storeContentForPreview;
    private String[] mURLCleaners;

    public XmlCrawlerConfig(File xmlFile) throws RegainException {
        Document doc = XmlToolkit.loadXmlDocument(xmlFile);
        Element config = doc.getDocumentElement();
        this.readProxyConfig(config);
        this.readLoadUnparsedUrls(config);
        this.readHttpTimeoutSecs(config);
        this.readUserAgent(config);
        this.readIndexConfig(config);
        this.readControlFileConfig(config);
        this.readStartUrls(config);
        this.readHtmlParserUrlPatterns(config);
        this.readBlackList(config);
        this.readWhiteList(config);
        this.readUseLinkTextAsTitleRegexList(config);
        this.readPreparatorSettingsList(config, xmlFile);
        this.readCrawlerPluginConfigSettingsList(config, xmlFile);
        this.readAuxiliaryFieldList(config);
        this.readCrawlerAccessController(config);
        this.readMaxCycleCount(config);
        this.readMaxSummaryLength(config);
        this.readURLCleaner(config);
    }

    private void readURLCleaner(Element config) throws RegainException {
        Node node = XmlToolkit.getChild(config, "UrlCleaner");
        if (node == null) {
            this.mURLCleaners = new String[0];
        } else {
            Node[] nodeArr = XmlToolkit.getChildArr(node, "regex");
            this.mURLCleaners = new String[nodeArr.length];
            for (int i = 0; i < nodeArr.length; ++i) {
                this.mURLCleaners[i] = XmlToolkit.getText(nodeArr[i]);
            }
        }
    }

    private void readMaxCycleCount(Element config) throws RegainException {
        Node node = XmlToolkit.getChild(config, "MaxCycleCount");
        this.mMaxCycleCount = node == null ? -1 : XmlToolkit.getTextAsInt(node);
    }

    private void readLoadUnparsedUrls(Element config) throws RegainException {
        Node node = XmlToolkit.getChild(config, "loadUnparsedUrls");
        this.mLoadUnparsedUrls = node == null ? false : XmlToolkit.getTextAsBoolean(node);
    }

    private void readHttpTimeoutSecs(Element config) throws RegainException {
        Node node = XmlToolkit.getChild(config, "httpTimeout");
        this.mHttpTimeoutSecs = node == null ? 180 : XmlToolkit.getTextAsInt(node);
    }

    private void readUserAgent(Element config) throws RegainException {
        Node node = XmlToolkit.getChild(config, "userAgent", false);
        if (node != null) {
            this.mUserAgent = XmlToolkit.getText(node);
        }
    }

    private void readProxyConfig(Node config) throws RegainException {
        Node proxyNode = XmlToolkit.getChild(config, "proxy");
        if (proxyNode != null) {
            Node node = XmlToolkit.getChild(proxyNode, "host");
            if (node != null) {
                this.mProxyHost = XmlToolkit.getText(node, true);
            }
            if ((node = XmlToolkit.getChild(proxyNode, "port")) != null) {
                this.mProxyPort = XmlToolkit.getText(node, true);
            }
            if ((node = XmlToolkit.getChild(proxyNode, "user")) != null) {
                this.mProxyUser = XmlToolkit.getText(node, true);
            }
            if ((node = XmlToolkit.getChild(proxyNode, "password")) != null) {
                this.mProxyPassword = XmlToolkit.getText(node, true);
            }
        }
    }

    private void readIndexConfig(Node config) throws RegainException {
        Node indexNode = XmlToolkit.getChild(config, "searchIndex", true);
        Node node = XmlToolkit.getChild(indexNode, "dir", true);
        this.mIndexDir = XmlToolkit.getText(node, true);
        node = XmlToolkit.getChild(indexNode, "buildIndex");
        this.mBuildIndex = node == null ? true : XmlToolkit.getTextAsBoolean(node);
        node = XmlToolkit.getChild(indexNode, "analyzerType", true);
        this.mAnalyzerType = XmlToolkit.getText(node, true);
        node = XmlToolkit.getChild(indexNode, "maxFieldLength", false);
        this.mMaxFieldLength = node == null ? -1 : XmlToolkit.getTextAsInt(node);
        node = XmlToolkit.getChild(indexNode, "stopwordList", false);
        this.mStopWordList = node == null ? null : XmlToolkit.getTextAsWordList(node, true);
        node = XmlToolkit.getChild(indexNode, "exclusionList", true);
        this.mExclusionList = XmlToolkit.getTextAsWordList(node, false);
        node = XmlToolkit.getChild(indexNode, "writeAnalysisFiles");
        this.mWriteAnalysisFiles = node == null ? false : XmlToolkit.getTextAsBoolean(node);
        node = XmlToolkit.getChild(indexNode, "breakpointInterval");
        this.mBreakpointInterval = node == null ? 10 : XmlToolkit.getTextAsInt(node);
        node = XmlToolkit.getChild(indexNode, "maxFailedDocuments");
        this.mMaxFailedDocuments = node == null ? 1.0 : XmlToolkit.getTextAsDouble(node) / 100.0;
        node = XmlToolkit.getChild(indexNode, "valuePrefetchFields", false);
        this.mValuePrefetchFields = node == null ? null : XmlToolkit.getTextAsWordList(node, false);
        node = XmlToolkit.getChild(indexNode, "storeContentForPreview");
        this.storeContentForPreview = node == null ? false : XmlToolkit.getTextAsBoolean(node);
    }

    private void readControlFileConfig(Node config) throws RegainException {
        Node ctrNode = XmlToolkit.getChild(config, "controlFiles");
        if (ctrNode != null) {
            Node node = XmlToolkit.getChild(ctrNode, "finishedWithoutFatalsFile");
            if (node != null) {
                this.mFinishedWithoutFatalsFileName = XmlToolkit.getText(node, true).trim();
            }
            if ((node = XmlToolkit.getChild(ctrNode, "finishedWithFatalsFile")) != null) {
                this.mFinishedWithFatalsFileName = XmlToolkit.getText(node, true).trim();
            }
        }
    }

    private void readStartUrls(Node config) throws RegainException {
        Node node = XmlToolkit.getChild(config, "startlist", true);
        Node[] nodeArr = XmlToolkit.getChildArr(node, "start");
        this.mStartUrls = new StartUrl[nodeArr.length];
        for (int i = 0; i < nodeArr.length; ++i) {
            String url = XmlToolkit.getTextOrCDataAsUrl(nodeArr[i]);
            boolean parse = XmlToolkit.getAttributeAsBoolean(nodeArr[i], "parse");
            boolean index = XmlToolkit.getAttributeAsBoolean(nodeArr[i], "index");
            this.mStartUrls[i] = new StartUrl(url, parse, index);
        }
    }

    private void readHtmlParserUrlPatterns(Node config) throws RegainException {
        Node node = XmlToolkit.getChild(config, "htmlParserPatternList", false);
        if (node != null) {
            Node[] nodeArr = XmlToolkit.getChildArr(node, "pattern");
            this.mHtmlParserUrlPatterns = new UrlPattern[nodeArr.length];
            for (int i = 0; i < nodeArr.length; ++i) {
                String regexPattern = XmlToolkit.getText(nodeArr[i], true);
                int regexGroup = XmlToolkit.getAttributeAsInt(nodeArr[i], "regexGroup");
                boolean parse = XmlToolkit.getAttributeAsBoolean(nodeArr[i], "parse");
                boolean index = XmlToolkit.getAttributeAsBoolean(nodeArr[i], "index");
                this.mHtmlParserUrlPatterns[i] = new UrlPattern(regexPattern, regexGroup, parse, index);
            }
        } else {
            this.mHtmlParserUrlPatterns = new UrlPattern[0];
        }
    }

    private void readBlackList(Node config) throws RegainException {
        int i;
        Node node = XmlToolkit.getChild(config, "blacklist", true);
        Node[] prefixNodeArr = XmlToolkit.getChildArr(node, "prefix");
        Node[] regexNodeArr = XmlToolkit.getChildArr(node, "regex");
        this.mBlackList = new UrlMatcher[prefixNodeArr.length + regexNodeArr.length];
        for (i = 0; i < prefixNodeArr.length; ++i) {
            String prefix = XmlToolkit.getTextOrCData(prefixNodeArr[i], true).replaceAll(" ", "%20");
            this.mBlackList[i] = new PrefixUrlMatcher(prefix, false, false);
        }
        for (i = 0; i < regexNodeArr.length; ++i) {
            String regex = XmlToolkit.getTextOrCData(regexNodeArr[i], true);
            this.mBlackList[prefixNodeArr.length + i] = new RegexUrlMatcher(regex, false, false);
        }
    }

    private void readWhiteList(Node config) throws RegainException {
        String name;
        UrlMatcherResult matcher;
        boolean index;
        boolean parse;
        int i;
        Node node = XmlToolkit.getChild(config, "whitelist", true);
        Node[] prefixNodeArr = XmlToolkit.getChildArr(node, "prefix");
        Node[] regexNodeArr = XmlToolkit.getChildArr(node, "regex");
        this.mWhiteListEntryArr = new WhiteListEntry[prefixNodeArr.length + regexNodeArr.length];
        for (i = 0; i < prefixNodeArr.length; ++i) {
            String prefix = XmlToolkit.getTextOrCData(prefixNodeArr[i], true).replaceAll(" ", "%20");
            parse = XmlToolkit.getAttributeAsBoolean(prefixNodeArr[i], "parse", true);
            index = XmlToolkit.getAttributeAsBoolean(prefixNodeArr[i], "index", true);
            matcher = new PrefixUrlMatcher(prefix, parse, index);
            name = XmlToolkit.getAttribute(prefixNodeArr[i], "name");
            this.mWhiteListEntryArr[i] = new WhiteListEntry(matcher, name);
        }
        for (i = 0; i < regexNodeArr.length; ++i) {
            String regex = XmlToolkit.getTextOrCData(regexNodeArr[i], true);
            parse = XmlToolkit.getAttributeAsBoolean(regexNodeArr[i], "parse", true);
            index = XmlToolkit.getAttributeAsBoolean(regexNodeArr[i], "index", true);
            matcher = new RegexUrlMatcher(regex, parse, index);
            name = XmlToolkit.getAttribute(regexNodeArr[i], "name");
            this.mWhiteListEntryArr[prefixNodeArr.length + i] = new WhiteListEntry(matcher, name);
        }
    }

    private void readUseLinkTextAsTitleRegexList(Node config) throws RegainException {
        Node node = XmlToolkit.getChild(config, "useLinkTextAsTitleList");
        if (node == null) {
            this.mUseLinkTextAsTitleRegexList = new String[0];
        } else {
            Node[] nodeArr = XmlToolkit.getChildArr(node, "urlPattern");
            this.mUseLinkTextAsTitleRegexList = new String[nodeArr.length];
            for (int i = 0; i < nodeArr.length; ++i) {
                this.mUseLinkTextAsTitleRegexList[i] = XmlToolkit.getText(nodeArr[i], true);
            }
        }
    }

    private void readPreparatorSettingsList(Node config, File xmlFile) throws RegainException {
        Node node = XmlToolkit.getChild(config, "preparatorList", true);
        Node[] nodeArr = XmlToolkit.getChildArr(node, "preparator");
        this.mPreparatorSettingsArr = new PreparatorSettings[nodeArr.length];
        for (int i = 0; i < nodeArr.length; ++i) {
            boolean enabled = XmlToolkit.getAttributeAsBoolean(nodeArr[i], "enabled", true);
            int priority = XmlToolkit.getAttributeAsInt(nodeArr[i], "priority", 0);
            node = XmlToolkit.getChild(nodeArr[i], "class", true);
            String className = XmlToolkit.getText(node, true);
            node = XmlToolkit.getChild(nodeArr[i], "urlPattern", false);
            String urlRegex = null;
            if (node != null) {
                urlRegex = XmlToolkit.getText(node, true);
            }
            PreparatorConfig prepConfig = (node = XmlToolkit.getChild(nodeArr[i], "config")) != null ? this.readPreparatorConfig(node, xmlFile, className) : new PreparatorConfig();
            this.mPreparatorSettingsArr[i] = new PreparatorSettings(enabled, priority, className, urlRegex, prepConfig);
        }
    }

    private void readCrawlerPluginConfigSettingsList(Node config, File xmlFile) throws RegainException {
        Node node = XmlToolkit.getChild(config, "crawlerPluginList", false);
        if (node == null) {
            this.mCrawlerPluginSettingsArr = new PreparatorSettings[0];
            return;
        }
        Node[] nodeArr = XmlToolkit.getChildArr(node, "crawlerPlugin");
        this.mCrawlerPluginSettingsArr = new PreparatorSettings[nodeArr.length];
        for (int i = 0; i < nodeArr.length; ++i) {
            boolean enabled = XmlToolkit.getAttributeAsBoolean(nodeArr[i], "enabled", true);
            int priority = XmlToolkit.getAttributeAsInt(nodeArr[i], "priority", 0);
            node = XmlToolkit.getChild(nodeArr[i], "class", true);
            String className = XmlToolkit.getText(node, true);
            node = XmlToolkit.getChild(nodeArr[i], "config");
            PreparatorConfig prepConfig = node != null ? this.readPreparatorConfig(node, xmlFile, className) : new PreparatorConfig();
            this.mCrawlerPluginSettingsArr[i] = new PreparatorSettings(enabled, priority, className, null, prepConfig);
        }
    }

    private void readAuxiliaryFieldList(Node config) throws RegainException {
        Node node = XmlToolkit.getChild(config, "auxiliaryFieldList");
        if (node != null) {
            Node[] nodeArr = XmlToolkit.getChildArr(node, "auxiliaryField");
            this.mAuxiliaryFieldArr = new AuxiliaryField[nodeArr.length];
            for (int i = 0; i < nodeArr.length; ++i) {
                AuxiliaryField.SourceField sourceField;
                String sourceFieldName = XmlToolkit.getAttribute(nodeArr[i], "sourceField");
                if (sourceFieldName == null || sourceFieldName.equalsIgnoreCase("URL")) {
                    sourceField = AuxiliaryField.SourceField.URL;
                } else if (sourceFieldName.equalsIgnoreCase("path")) {
                    sourceField = AuxiliaryField.SourceField.PATH;
                } else {
                    throw new RegainException("The attribute 'sourceField' of node 'auxiliaryField' has illegal value: '" + sourceFieldName + "'");
                }
                String fieldName = XmlToolkit.getAttribute(nodeArr[i], "name", true);
                RE urlRegex = this.readRegexChild(nodeArr[i]);
                String value = XmlToolkit.getAttribute(nodeArr[i], "value");
                boolean toLowerCase = XmlToolkit.getAttributeAsBoolean(nodeArr[i], "toLowerCase", true);
                int urlRegexGroup = XmlToolkit.getAttributeAsInt(nodeArr[i], "regexGroup", -1);
                if (value == null && urlRegexGroup == -1) {
                    throw new RegainException("The node 'auxiliaryField' must have either the attribute 'value' or the attribute 'regexGroup'");
                }
                boolean store = XmlToolkit.getAttributeAsBoolean(nodeArr[i], "store", true);
                boolean index = XmlToolkit.getAttributeAsBoolean(nodeArr[i], "index", true);
                boolean tokenize = XmlToolkit.getAttributeAsBoolean(nodeArr[i], "tokenize", false);
                this.mAuxiliaryFieldArr[i] = new AuxiliaryField(sourceField, fieldName, value, toLowerCase, urlRegex, urlRegexGroup, store, index, tokenize);
            }
        }
    }

    private RE readRegexChild(Node node) throws RegainException {
        Node regexNode = XmlToolkit.getChild(node, "regex");
        if (regexNode != null) {
            boolean caseSensitive = XmlToolkit.getAttributeAsBoolean(regexNode, "caseSensitive", false);
            String regex = XmlToolkit.getText(regexNode, true);
            int flags = caseSensitive ? 0 : 1;
            try {
                return new RE(regex, flags);
            }
            catch (RESyntaxException exc) {
                throw new RegainException("Regex of node '" + node.getNodeName() + "' has a wrong syntax: '" + regex + "'", exc);
            }
        }
        String regex = XmlToolkit.getText(node, true);
        try {
            return new RE(regex, 1);
        }
        catch (RESyntaxException exc) {
            throw new RegainException("Regex of node '" + node.getNodeName() + "' has a wrong syntax: '" + regex + "'", exc);
        }
    }

    private PreparatorConfig readPreparatorConfig(Node prepConfig, File xmlFile, String className) throws RegainException {
        String extraFileName = XmlToolkit.getAttribute(prepConfig, "file");
        if (extraFileName != null) {
            File extraFile = new File(xmlFile.getParentFile(), extraFileName);
            Document doc = XmlToolkit.loadXmlDocument(extraFile);
            prepConfig = doc.getDocumentElement();
        }
        PreparatorConfig config = new PreparatorConfig();
        Node[] sectionArr = XmlToolkit.getChildArr(prepConfig, "section");
        for (int secIdx = 0; secIdx < sectionArr.length; ++secIdx) {
            String sectionName = XmlToolkit.getAttribute(sectionArr[secIdx], "name", true);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            Node[] paramArr = XmlToolkit.getChildArr(sectionArr[secIdx], "param");
            for (int paramIdx = 0; paramIdx < paramArr.length; ++paramIdx) {
                String paramName = XmlToolkit.getAttribute(paramArr[paramIdx], "name", true);
                String paramValue = XmlToolkit.getText(paramArr[paramIdx], true);
                if (paramMap.containsKey(paramName)) {
                    throw new RegainException("Preparator configuration of '" + className + "' has multiple '" + paramName + "' parameters in section '" + sectionName + "'");
                }
                paramMap.put(paramName, paramValue);
            }
            config.addSection(sectionName, paramMap);
        }
        return config;
    }

    private void readCrawlerAccessController(Node config) throws RegainException {
        Node node = XmlToolkit.getChild(config, "crawlerAccessController");
        if (node != null) {
            Node classNode = XmlToolkit.getChild(node, "class", true);
            this.mCrawlerAccessControllerClass = XmlToolkit.getText(classNode, true);
            this.mCrawlerAccessControllerJar = XmlToolkit.getAttribute(classNode, "jar");
            Node configNode = XmlToolkit.getChild(node, "config");
            if (configNode != null) {
                this.mCrawlerAccessControllerConfig = new Properties();
                Node[] paramNodeArr = XmlToolkit.getChildArr(configNode, "param");
                for (int i = 0; i < paramNodeArr.length; ++i) {
                    String name = XmlToolkit.getAttribute(paramNodeArr[i], "name", true);
                    String value = XmlToolkit.getText(paramNodeArr[i], true);
                    this.mCrawlerAccessControllerConfig.setProperty(name, value);
                }
            }
        }
    }

    @Override
    public String getProxyHost() {
        return this.mProxyHost;
    }

    @Override
    public String getProxyPort() {
        return this.mProxyPort;
    }

    @Override
    public String getProxyUser() {
        return this.mProxyUser;
    }

    @Override
    public String getProxyPassword() {
        return this.mProxyPassword;
    }

    @Override
    public String getUserAgent() {
        return this.mUserAgent;
    }

    @Override
    public int getHttpTimeoutSecs() {
        return this.mHttpTimeoutSecs;
    }

    @Override
    public boolean getLoadUnparsedUrls() {
        return this.mLoadUnparsedUrls;
    }

    @Override
    public boolean getBuildIndex() {
        return this.mBuildIndex;
    }

    @Override
    public String getIndexDir() {
        return this.mIndexDir;
    }

    @Override
    public String getAnalyzerType() {
        return this.mAnalyzerType;
    }

    @Override
    public int getMaxFieldLength() {
        return this.mMaxFieldLength;
    }

    @Override
    public String[] getStopWordList() {
        return this.mStopWordList;
    }

    @Override
    public String[] getExclusionList() {
        return this.mExclusionList;
    }

    @Override
    public boolean getWriteAnalysisFiles() {
        return this.mWriteAnalysisFiles;
    }

    @Override
    public int getBreakpointInterval() {
        return this.mBreakpointInterval;
    }

    @Override
    public double getMaxFailedDocuments() {
        return this.mMaxFailedDocuments;
    }

    @Override
    public String getFinishedWithoutFatalsFileName() {
        return this.mFinishedWithoutFatalsFileName;
    }

    @Override
    public String getFinishedWithFatalsFileName() {
        return this.mFinishedWithFatalsFileName;
    }

    @Override
    public boolean getStoreContentForPreview() {
        return this.storeContentForPreview;
    }

    @Override
    public StartUrl[] getStartUrls() {
        return this.mStartUrls;
    }

    @Override
    public UrlPattern[] getHtmlParserUrlPatterns() {
        return this.mHtmlParserUrlPatterns;
    }

    @Override
    public UrlMatcher[] getBlackList() {
        return this.mBlackList;
    }

    @Override
    public WhiteListEntry[] getWhiteList() {
        return this.mWhiteListEntryArr;
    }

    @Override
    public String[] getValuePrefetchFields() {
        return this.mValuePrefetchFields;
    }

    @Override
    public String[] getUseLinkTextAsTitleRegexList() {
        return this.mUseLinkTextAsTitleRegexList;
    }

    @Override
    public PreparatorSettings[] getPreparatorSettingsList() {
        return this.mPreparatorSettingsArr;
    }

    @Override
    public PreparatorSettings[] getCrawlerPluginSettingsList() {
        return this.mCrawlerPluginSettingsArr;
    }

    @Override
    public AuxiliaryField[] getAuxiliaryFieldList() {
        return this.mAuxiliaryFieldArr;
    }

    @Override
    public String getCrawlerAccessControllerClass() {
        return this.mCrawlerAccessControllerClass;
    }

    @Override
    public String getCrawlerAccessControllerJar() {
        return this.mCrawlerAccessControllerJar;
    }

    @Override
    public Properties getCrawlerAccessControllerConfig() {
        return this.mCrawlerAccessControllerConfig;
    }

    @Override
    public int getMaxCycleCount() {
        return this.mMaxCycleCount;
    }

    @Override
    public int getMaxSummaryLength() {
        return this.mMaxSummaryLength;
    }

    private void readMaxSummaryLength(Element config) throws RegainException {
        Node node = XmlToolkit.getChild(config, "MaxSummaryLength");
        this.mMaxSummaryLength = node == null ? 250000 : XmlToolkit.getTextAsInt(node);
    }

    @Override
    public String[] getUntokenizedFieldNames() {
        AuxiliaryField[] auxFieldArr = this.getAuxiliaryFieldList();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < auxFieldArr.length; ++i) {
            if (auxFieldArr[i].isTokenized()) continue;
            list.add(auxFieldArr[i].getTargetFieldName());
        }
        String[] asArr = new String[list.size()];
        list.toArray(asArr);
        return asArr;
    }

    @Override
    public String[] getURLCleaners() {
        return this.mURLCleaners;
    }
}

