/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.config;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.regain.RegainException;
import net.sf.regain.crawler.config.UrlMatcherResult;
import org.apache.log4j.Logger;

public class RegexUrlMatcher
extends UrlMatcherResult {
    private static Logger mLog = Logger.getLogger(RegexUrlMatcher.class);
    private String mUrlRegexAsString;
    private Pattern mUrlRegex;

    public RegexUrlMatcher(String regex, boolean shouldBeParsed, boolean shouldBeIndexed) throws RegainException {
        super(shouldBeParsed, shouldBeIndexed);
        this.mUrlRegexAsString = regex;
        try {
            this.mUrlRegex = Pattern.compile(regex);
        }
        catch (Exception ex) {
            throw new RegainException("Regular expression of URL matcher has a wrong syntax: '" + regex + "'", ex);
        }
    }

    @Override
    public boolean matches(String url) {
        Matcher matcher = this.mUrlRegex.matcher(url);
        boolean result = matcher.matches();
        mLog.debug("Exact match with pattern: " + this.mUrlRegexAsString + ", " + this.mUrlRegex.pattern() + ": " + (result ? "yes" : "no"));
        return result;
    }

    public String toString() {
        return this.mUrlRegexAsString;
    }
}

