/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import net.sf.regain.RegainToolkit;
import org.apache.log4j.Logger;

public class Profiler {
    private static Logger mLog = Logger.getLogger(Profiler.class);
    private static List<Profiler> mProfilerList;
    private String mName;
    private String mUnit;
    private long mTotalTime;
    private long mTotalBytes;
    private int mMeasureCount;
    private int mAbortedMeasureCount;
    private long mMeasureStart = -1L;

    public Profiler(String name, String unit) {
        this.mName = name;
        this.mUnit = unit;
        Profiler.registerProfiler(this);
    }

    public int getMeasureCount() {
        return this.mMeasureCount;
    }

    public int getAbortedMeasureCount() {
        return this.mAbortedMeasureCount;
    }

    public long getCurrentMeasuringTime() {
        long startTime = this.mMeasureStart;
        if (startTime == -1L) {
            return -1L;
        }
        return System.currentTimeMillis() - startTime;
    }

    public static synchronized void clearRegisteredProfilers() {
        mProfilerList = null;
    }

    private static synchronized void registerProfiler(Profiler profiler) {
        if (mProfilerList == null) {
            mProfilerList = new ArrayList<Profiler>();
        }
        mProfilerList.add(profiler);
    }

    public void startMeasuring() {
        if (this.mMeasureStart != -1L) {
            mLog.warn("A profiler measuring for " + this.mName + " was started, although " + "there is currently a measuring running!");
        }
        this.mMeasureStart = System.currentTimeMillis();
    }

    public void stopMeasuring(long bytes) {
        if (this.mMeasureStart == -1L) {
            mLog.warn("A profiler measuring for " + this.mName + " was stopped, although " + "there was currently no measuring running!");
        } else {
            this.mTotalTime += System.currentTimeMillis() - this.mMeasureStart;
            this.mTotalBytes += bytes;
            ++this.mMeasureCount;
            this.mMeasureStart = -1L;
        }
    }

    public void abortMeasuring() {
        if (this.mMeasureStart == -1L) {
            mLog.warn("A profiler measuring for " + this.mName + " was aborted, although " + "there was currently no measuring running!");
        } else {
            this.mMeasureStart = -1L;
            ++this.mAbortedMeasureCount;
        }
    }

    public String toString() {
        long totalTime = this.mTotalTime;
        long totalBytes = this.mTotalBytes;
        int measureCount = this.mMeasureCount;
        int abortedMeasureCount = this.mAbortedMeasureCount;
        long averageTime = 0L;
        long averageBytes = 0L;
        if (measureCount > 0) {
            averageTime = totalTime / (long)measureCount;
            averageBytes = totalBytes / (long)measureCount;
        }
        long dataRatePerSec = 0L;
        double secs = (double)totalTime / 1000.0;
        if (secs > 0.0) {
            dataRatePerSec = (long)((double)totalBytes / secs);
        }
        double countsPerMinute = 0.0;
        if (totalTime > 0L) {
            countsPerMinute = (double)measureCount * 60000.0 / (double)totalTime;
        }
        int maxStaticLabelLength = 12;
        int maxDynamicLabelLength = 10 + this.mUnit.length();
        int minLabelLength = Math.max(maxStaticLabelLength, maxDynamicLabelLength);
        String lineSeparator = RegainToolkit.getLineSeparator();
        StringBuffer buffer = new StringBuffer(this.mName + ":");
        NumberFormat integerFormat = NumberFormat.getInstance();
        integerFormat.setMaximumFractionDigits(0);
        if (abortedMeasureCount > 0) {
            buffer.append(lineSeparator);
            this.appendLabel(buffer, "Aborted " + this.mUnit, minLabelLength);
            buffer.append(integerFormat.format(abortedMeasureCount) + " " + this.mUnit + " (");
            int total = abortedMeasureCount + measureCount;
            double errorPercent = (double)abortedMeasureCount / (double)total;
            buffer.append(RegainToolkit.toPercentString(errorPercent));
            buffer.append(")");
        }
        if (measureCount > 0) {
            buffer.append(lineSeparator);
            this.appendLabel(buffer, "Completed " + this.mUnit, minLabelLength);
            buffer.append(integerFormat.format(measureCount) + " " + this.mUnit + lineSeparator);
            this.appendLabel(buffer, "Total time", minLabelLength);
            buffer.append(RegainToolkit.toTimeString(totalTime) + lineSeparator);
            this.appendLabel(buffer, "Total data", minLabelLength);
            buffer.append(RegainToolkit.bytesToString(totalBytes) + lineSeparator);
            this.appendLabel(buffer, "Average time", minLabelLength);
            buffer.append(RegainToolkit.toTimeString(averageTime) + lineSeparator);
            this.appendLabel(buffer, "Average data", minLabelLength);
            buffer.append(RegainToolkit.bytesToString(averageBytes) + lineSeparator);
            this.appendLabel(buffer, "Data rate", minLabelLength);
            buffer.append(RegainToolkit.bytesToString(dataRatePerSec) + "/sec" + lineSeparator);
            this.appendLabel(buffer, "Output", minLabelLength);
            if (countsPerMinute > 10.0) {
                buffer.append(integerFormat.format(countsPerMinute) + " " + this.mUnit + "/min");
            } else {
                NumberFormat floatingFormat = NumberFormat.getInstance();
                floatingFormat.setMinimumFractionDigits(2);
                floatingFormat.setMaximumFractionDigits(2);
                buffer.append(floatingFormat.format(countsPerMinute) + " " + this.mUnit + "/min");
            }
        }
        return buffer.toString();
    }

    private void appendLabel(StringBuffer buffer, String label, int minLabelLength) {
        buffer.append("  ");
        buffer.append(label);
        buffer.append(": ");
        int spaceCount = minLabelLength - label.length();
        for (int i = 0; i < spaceCount; ++i) {
            buffer.append(' ');
        }
    }

    public boolean wasUsed() {
        return this.mMeasureCount > 0 || this.mAbortedMeasureCount > 0;
    }

    public static String getProfilerResults() {
        if (mProfilerList == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (Profiler profiler : mProfilerList) {
            if (!profiler.wasUsed()) continue;
            buffer.append(profiler);
            buffer.append(RegainToolkit.getLineSeparator());
        }
        return buffer.toString();
    }
}

