/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import net.sf.regain.RegainException;
import net.sf.regain.RegainToolkit;
import net.sf.regain.crawler.Crawler;
import net.sf.regain.crawler.config.XmlCrawlerConfig;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Main {
    private static Logger mLog = Logger.getLogger(Main.class);
    private static final String LOG4J_PROP_FILE_NAME = "log4j.properties";

    public static void main(String[] args) {
        XmlCrawlerConfig config;
        String crawlerConfigFileName = "CrawlerConfiguration.xml";
        String logConfigFileName = LOG4J_PROP_FILE_NAME;
        String[] onlyEntriesArr = null;
        boolean updateIndex = true;
        boolean retryFailedDocs = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-forceNewIndex")) {
                updateIndex = false;
                continue;
            }
            if (args[i].equalsIgnoreCase("-retryFailedDocs")) {
                retryFailedDocs = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("--help") || args[i].equalsIgnoreCase("/?")) {
                Main.showHelp();
                continue;
            }
            if (args[i].equalsIgnoreCase("-onlyEntries")) {
                String ssv = Main.readParam(args, ++i);
                onlyEntriesArr = RegainToolkit.splitString(ssv, ",");
                continue;
            }
            if (args[i].equalsIgnoreCase("-config")) {
                crawlerConfigFileName = Main.readParam(args, ++i);
                continue;
            }
            if (args[i].equalsIgnoreCase("-logConfig")) {
                logConfigFileName = Main.readParam(args, ++i);
                continue;
            }
            Main.showHelp();
        }
        File logConfigFile = new File(logConfigFileName);
        if (!logConfigFile.exists()) {
            System.out.println("ERROR: Logging configuration file not found: " + logConfigFile.getAbsolutePath());
            return;
        }
        PropertyConfigurator.configureAndWatch(logConfigFile.getAbsolutePath(), 10000L);
        mLog.info("Logging initialized");
        File xmlFile = new File(crawlerConfigFileName);
        try {
            config = new XmlCrawlerConfig(xmlFile);
        }
        catch (RegainException exc) {
            mLog.error("Loading XML Configuration failed", exc);
            return;
        }
        Properties authProps = new Properties();
        try {
            File authPropsFile = new File(new File("conf"), "authentication.properties");
            if (!authPropsFile.exists()) {
                authPropsFile = new File("authentication.properties");
            }
            mLog.debug(authPropsFile.getAbsolutePath());
            authProps.load(new FileInputStream(authPropsFile));
        }
        catch (Exception ex) {
            mLog.error("Couldn't load authentication.properties", ex);
            return;
        }
        Crawler crawler = null;
        try {
            crawler = new Crawler(config, authProps);
        }
        catch (RegainException exc) {
            mLog.error("There was an error when initializing the crawler!", exc);
        }
        if (crawler != null) {
            crawler.run(updateIndex, retryFailedDocs, onlyEntriesArr);
            int returnCode = crawler.getErrorCount() > 0 ? (crawler.getFatalErrorCount() > 0 ? 100 : 1) : 0;
            if (returnCode == 100) {
                Main.deleteControlFile(config.getFinishedWithoutFatalsFileName());
                Main.createControlFile(config.getFinishedWithFatalsFileName());
            } else {
                Main.deleteControlFile(config.getFinishedWithFatalsFileName());
                Main.createControlFile(config.getFinishedWithoutFatalsFileName());
            }
            System.exit(returnCode);
        }
    }

    private static String readParam(String[] args, int paramIdx) {
        if (paramIdx < args.length) {
            return args[paramIdx];
        }
        Main.showHelp();
        return null;
    }

    private static void showHelp() {
        System.out.println("Allowed parameters:\n  --help:             Shows this help page\n  -forceNewIndex:     Forces the creation of a new search index\n  -retryFailedDocs:   The preparation of documents that failed last time is retried\n  -onlyEntries <CSV>: The white list entries to use, separated by comma (,)\n                      (Default: all entries)\n  -config <file>:     The configuration file to use\n                      (Default: CrawlerConfiguration.xml)\n  -logConfig <file>:  The logging configuration file to use\n                      (Default: log4j.properties)\n");
        System.exit(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createControlFile(String fileName) {
        if (fileName != null) {
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(fileName);
                mLog.info("Created control file: '" + fileName + "'");
            }
            catch (IOException exc) {
                mLog.warn("Creating control file failed: '" + fileName + "'", exc);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static void deleteControlFile(String fileName) {
        File file;
        if (fileName != null && (file = new File(fileName)).exists() && !file.delete()) {
            mLog.warn("Deleting old control file failed: '" + fileName + "'");
        }
    }
}

