/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler;

import java.net.HttpURLConnection;
import java.net.URLConnection;
import net.sf.regain.RegainException;

public class HttpStreamException
extends RegainException {
    private int mHttpReturnCode;

    private HttpStreamException(String message, Throwable cause, int httpReturnCode) {
        super(message, cause);
        this.mHttpReturnCode = httpReturnCode;
    }

    public static HttpStreamException createInstance(String message, Throwable cause, URLConnection conn) {
        int httpReturnCode = -1;
        if (conn instanceof HttpURLConnection) {
            HttpURLConnection hconn = (HttpURLConnection)conn;
            try {
                httpReturnCode = hconn.getResponseCode();
                message = message + " (HTTP response code: " + httpReturnCode + ")";
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        return new HttpStreamException(message, cause, httpReturnCode);
    }

    public int getHttpReturnCode() {
        return this.mHttpReturnCode;
    }

    public boolean isHttpReturnCodeFromDeadLink() {
        return this.mHttpReturnCode == 404 || this.mHttpReturnCode == 400;
    }
}

