/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.preparator;

import com.jacob.com.ComFailException;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.SafeArray;
import com.jacob.com.Variant;
import de.filiadata.lucene.spider.generated.msoffice2000.excel.Application;
import de.filiadata.lucene.spider.generated.msoffice2000.excel.Range;
import de.filiadata.lucene.spider.generated.msoffice2000.excel.Sheets;
import de.filiadata.lucene.spider.generated.msoffice2000.excel.Workbook;
import de.filiadata.lucene.spider.generated.msoffice2000.excel.Workbooks;
import de.filiadata.lucene.spider.generated.msoffice2000.excel.Worksheet;
import java.io.File;
import net.sf.regain.RegainException;
import net.sf.regain.crawler.config.PreparatorConfig;
import net.sf.regain.crawler.document.RawDocument;
import net.sf.regain.crawler.preparator.AbstractJacobMsOfficePreparator;

public class JacobMsExcelPreparator
extends AbstractJacobMsOfficePreparator {
    private Application mExcelApplication;

    public JacobMsExcelPreparator() throws RegainException {
        super(new String[]{"xls", "xlt"});
    }

    @Override
    public void init(PreparatorConfig config) throws RegainException {
        super.init(config);
    }

    public Range getCells(Worksheet sheet, int row, int col) {
        return new Range(Dispatch.call((Object)sheet, "Cells", (Object)new Variant(row), (Object)new Variant(col)).toDispatch());
    }

    public void prepare(RawDocument rawDocument) throws RegainException {
        if (this.mExcelApplication == null) {
            ComThread.InitSTA();
            this.mExcelApplication = new Application();
        }
        try {
            Variant what = new Variant("*");
            Variant lookIn = new Variant(-4163);
            Variant lookAt = new Variant(1);
            Variant searchOrderByRows = new Variant(1);
            Variant searchOrderByCols = new Variant(2);
            int searchDirectionUp = 1;
            int searchDirectionDown = 2;
            Variant xlFalse = new Variant(false);
            Workbooks wbs = this.mExcelApplication.getWorkbooks();
            File file = rawDocument.getContentAsFile();
            Workbook wb = wbs.open(file.getAbsolutePath(), new Variant(0));
            Sheets sheets = wb.getWorksheets();
            int sheetCount = sheets.getCount();
            StringBuffer contentBuf = new StringBuffer(16384);
            for (int sheetIdx = 1; sheetIdx <= sheetCount; ++sheetIdx) {
                Range extractRange;
                Variant sheetVariant = (Variant)sheets.getItem(new Variant(sheetIdx));
                Worksheet sheet = new Worksheet(sheetVariant.toDispatch());
                Variant after = new Variant(sheet.getRange(new Variant("IV65536")));
                try {
                    int firstRow = sheet.getCells().find(what, after, lookIn, lookAt, searchOrderByRows, searchDirectionUp, xlFalse, xlFalse).getRow();
                    int firstCol = sheet.getCells().find(what, after, lookIn, lookAt, searchOrderByCols, searchDirectionUp, xlFalse, xlFalse).getColumn();
                    int lastRow = sheet.getCells().find(what, after, lookIn, lookAt, searchOrderByRows, searchDirectionDown, xlFalse, xlFalse).getRow();
                    int lastCol = sheet.getCells().find(what, after, lookIn, lookAt, searchOrderByCols, searchDirectionDown, xlFalse, xlFalse).getColumn();
                    extractRange = sheet.getRange(new Variant(this.getCells(sheet, firstRow, firstCol)), new Variant(this.getCells(sheet, lastRow, lastCol)));
                }
                catch (NullPointerException e) {
                    extractRange = sheet.getUsedRange();
                }
                if (extractRange.getAddress().equals("$A$1")) continue;
                SafeArray cellArray = extractRange.getValue().toSafeArray();
                int startRow = cellArray.getLBound(1);
                int startCol = cellArray.getLBound(2);
                int endRow = cellArray.getUBound(1);
                int endCol = cellArray.getUBound(2);
                for (int row = startRow; row <= endRow; ++row) {
                    for (int col = startCol; col <= endCol; ++col) {
                        String cellValue = cellArray.getString(row, col);
                        if (cellValue == null || cellValue.length() == 0) continue;
                        contentBuf.append(cellValue);
                        contentBuf.append(" ");
                    }
                    contentBuf.append("\n");
                }
            }
            this.readProperties(wb);
            this.setCleanedContent(contentBuf.toString());
            wb.close(new Variant(false));
        }
        catch (ComFailException exc) {
            throw new RegainException("Using COM failed.", (Throwable)exc);
        }
    }

    public void close() throws RegainException {
        if (this.mExcelApplication != null) {
            try {
                this.mExcelApplication.quit();
            }
            catch (Throwable thr) {
                throw new RegainException("Using COM failed.", thr);
            }
            finally {
                ComThread.Release();
            }
        }
    }
}

