/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.preparator;

import net.sf.regain.RegainException;
import net.sf.regain.RegainToolkit;
import net.sf.regain.crawler.document.AbstractPreparator;
import net.sf.regain.crawler.document.RawDocument;

public class FilenamePreparator
extends AbstractPreparator {
    public void prepare(RawDocument rawDocument) throws RegainException {
        String filename = RegainToolkit.urlToFileName((String)rawDocument.getUrl());
        filename = FilenamePreparator.getName(filename);
        this.setCleanedContent(filename);
    }

    private static String getName(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FilenamePreparator.indexOfLastSeparator(filename);
        return filename.substring(index + 1);
    }

    private static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }
}

