/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.preparator.rtf;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class RtfFilterReader
extends FilterReader {
    private static final int TEXT_DEPTH = 2;
    private int mDepth = 0;
    private boolean mLastCharWasInTextDepth = true;

    public RtfFilterReader(Reader in) {
        super(in);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int ch = this.read();
        if (ch == -1) {
            return -1;
        }
        cbuf[off] = (char)ch;
        for (int i = 1; i < len; ++i) {
            ch = this.read();
            cbuf[off + i] = (char)ch;
            if (ch != -1) continue;
            return i;
        }
        return len;
    }

    @Override
    public int read() throws IOException {
        int ch = this.getNext();
        while (ch == 92 && ch != -1) {
            StringBuffer buf;
            ch = this.in.read();
            if (ch == 123 || ch == 125 || ch == 92) {
                return ch;
            }
            if (ch == 42) {
                do {
                    if ((ch = this.in.read()) == 123) {
                        ++this.mDepth;
                        continue;
                    }
                    if (ch != 125) continue;
                    --this.mDepth;
                } while (this.mDepth != 1 && ch != 125 && ch != -1);
            } else if (ch == 39) {
                buf = new StringBuffer(2);
                buf.append((char)this.getNext());
                buf.append((char)this.getNext());
                String specChar = buf.toString();
                if (specChar.equals("c4")) {
                    return 196;
                }
                if (specChar.equals("d6")) {
                    return 214;
                }
                if (specChar.equals("dc")) {
                    return 220;
                }
                if (specChar.equals("e4")) {
                    return 228;
                }
                if (specChar.equals("f6")) {
                    return 246;
                }
                if (specChar.equals("fc")) {
                    return 252;
                }
                if (specChar.equals("df")) {
                    return 223;
                }
            } else {
                buf = new StringBuffer();
                do {
                    buf.append((char)ch);
                } while ((ch = this.getNext()) != -1 && ch != 32 && ch != 92);
                String controlWord = buf.toString();
                char translated = this.translateControlWord(controlWord);
                if (translated != '\u0000') {
                    return translated;
                }
            }
            if (ch == 92 || ch == 32) continue;
            ch = this.getNext();
        }
        return ch;
    }

    private char translateControlWord(String controlWord) {
        if (controlWord.equals("tab")) {
            return '\t';
        }
        if (controlWord.equals("par")) {
            return '\n';
        }
        if (controlWord.equals("line")) {
            return '\n';
        }
        return '\u0000';
    }

    private int getNext() throws IOException {
        int ch;
        do {
            ch = this.in.read();
            while (ch == 10 || ch == 13) {
                ch = this.in.read();
            }
            if (ch == 123) {
                ++this.mDepth;
            } else if (ch == 125) {
                --this.mDepth;
            }
            if (!this.mLastCharWasInTextDepth || this.mDepth == 2) continue;
            this.mLastCharWasInTextDepth = false;
            if (ch == -1) {
                return -1;
            }
            return 32;
        } while (ch == 123 || ch == 125 || this.mDepth != 2 && ch != -1);
        this.mLastCharWasInTextDepth = true;
        return ch;
    }
}

