/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.preparator;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.regain.RegainException;
import net.sf.regain.RegainToolkit;
import net.sf.regain.crawler.document.AbstractPreparator;
import net.sf.regain.crawler.document.RawDocument;

public class ZipPreparator
extends AbstractPreparator {
    public ZipPreparator() throws RegainException {
        super(new String[]{"application/zip"});
    }

    public void prepare(RawDocument rawDocument) throws RegainException {
        File rawFile = rawDocument.getContentAsFile(false);
        ArrayList<String> contentParts = new ArrayList<String>();
        try {
            ZipFile zipFile = new ZipFile(rawFile, 1);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String filenameWithVariants = RegainToolkit.urlToWhitespacedFileName((String)entry.getName());
                if (!filenameWithVariants.startsWith(entry.getName().substring(0, entry.getName().length() - 1))) {
                    contentParts.add(entry.getName());
                }
                contentParts.add(filenameWithVariants);
            }
            this.setCleanedContent(this.concatenateStringParts(contentParts, Integer.MAX_VALUE));
        }
        catch (Exception ex) {
            throw new RegainException("Error parsing archive (zipped) file: " + rawDocument.getUrl(), (Throwable)ex);
        }
    }
}

