/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.preparator;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import net.sf.regain.RegainException;
import net.sf.regain.crawler.CrawlerToolkit;
import net.sf.regain.crawler.config.PreparatorConfig;
import net.sf.regain.crawler.document.AbstractPreparator;
import net.sf.regain.crawler.document.RawDocument;
import net.sf.regain.crawler.preparator.ifilter.IfilterWrapper;
import org.apache.log4j.Logger;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class IfilterPreparator
extends AbstractPreparator {
    private static Logger mLog = Logger.getLogger(IfilterPreparator.class);
    private static String[] mExtensionArr;
    private HashMap<String, IfilterWrapper> mExtensionToIFilterHash;
    private HashMap<String, IfilterWrapper> mGuidToIFilterHash;
    private static RE mValueRegex;

    public IfilterPreparator() throws RegainException {
        super(IfilterPreparator.getExtensionArr());
    }

    private static String[] getExtensionArr() throws RegainException {
        if (mExtensionArr == null) {
            String regKey;
            String[] classChildren;
            long startTime = 0L;
            if (mLog.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
            }
            if ((classChildren = IfilterPreparator.getRegistryKeyChildren(regKey = "HKEY_LOCAL_MACHINE\\Software\\Classes")) == null) {
                throw new RegainException("Reading windows registry failed");
            }
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < classChildren.length; ++i) {
                String persistentHandlerGuid;
                if (!classChildren[i].startsWith(".") || (persistentHandlerGuid = IfilterPreparator.getRegistryKeyValue(regKey = "HKEY_LOCAL_MACHINE\\Software\\Classes\\" + classChildren[i] + "\\PersistentHandler")) == null) continue;
                list.add(classChildren[i].substring(1));
            }
            mExtensionArr = new String[list.size()];
            list.toArray(mExtensionArr);
            if (mLog.isDebugEnabled()) {
                double duration = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                NumberFormat format = NumberFormat.getInstance();
                format.setMinimumFractionDigits(2);
                format.setMaximumFractionDigits(2);
                mLog.debug((Object)("Getting the supported extensions of the IfilterPreparator took " + format.format(duration) + " secs"));
            }
        }
        return mExtensionArr;
    }

    public void init(PreparatorConfig config) throws RegainException {
        IfilterWrapper.initCom();
        this.mExtensionToIFilterHash = new HashMap();
        this.mGuidToIFilterHash = new HashMap();
    }

    public void prepare(RawDocument rawDocument) throws RegainException {
        String url = rawDocument.getUrl();
        int dotPos = url.lastIndexOf(46);
        if (dotPos == -1) {
            throw new RegainException("Can't detect file extension: " + url);
        }
        String extension = url.substring(dotPos);
        IfilterWrapper ifilter = this.getIfilterWrapperForExtension(extension);
        String fileName = rawDocument.getContentAsFile().getAbsolutePath();
        StringBuffer buffer = new StringBuffer(16384);
        ifilter.getText(fileName, buffer);
        this.setCleanedContent(buffer.toString());
    }

    private IfilterWrapper getIfilterWrapperForExtension(String extension) throws RegainException {
        String ifilterGuid;
        IfilterWrapper ifilter = this.mExtensionToIFilterHash.get(extension);
        if (ifilter != null) {
            return ifilter;
        }
        String regKey = "HKEY_LOCAL_MACHINE\\Software\\Classes\\" + extension + "\\PersistentHandler";
        String persistentHandlerGuid = IfilterPreparator.getRegistryKeyValue(regKey);
        if (persistentHandlerGuid == null) {
            regKey = "HKEY_LOCAL_MACHINE\\Software\\Classes\\" + extension;
            String extensionClass = IfilterPreparator.getRegistryKeyValue(regKey);
            if (extensionClass == null) {
                throw new RegainException("Unknown file extension: " + extension);
            }
            regKey = "HKEY_LOCAL_MACHINE\\Software\\Classes\\" + extensionClass + "\\CLSID";
            String extensionClsid = IfilterPreparator.getRegistryKeyValue(regKey);
            if (extensionClsid == null) {
                throw new RegainException("CLSID of extension class " + extensionClass + " not found");
            }
            regKey = "HKEY_LOCAL_MACHINE\\Software\\Classes\\CLSID\\" + extensionClsid + "\\PersistentHandler";
            persistentHandlerGuid = IfilterPreparator.getRegistryKeyValue(regKey);
            if (persistentHandlerGuid == null) {
                throw new RegainException("PersistentHandler of extension class " + extensionClass + " not found");
            }
        }
        if ((ifilterGuid = IfilterPreparator.getRegistryKeyValue(regKey = "HKEY_LOCAL_MACHINE\\Software\\Classes\\CLSID\\" + persistentHandlerGuid + "\\PersistentAddinsRegistered\\{89BCB740-6119-101A-BCB7-00DD010655AF}")) == null) {
            throw new RegainException("GUIF of PersistentHandler not found for extension " + extension);
        }
        ifilterGuid = "clsid:" + ifilterGuid.substring(1, ifilterGuid.length() - 1);
        if (mLog.isDebugEnabled()) {
            mLog.debug((Object)("# ifilterGuid for " + extension + " is " + ifilterGuid));
        }
        ifilter = this.getIfilterWrapperForGuid(ifilterGuid);
        this.mExtensionToIFilterHash.put(extension, ifilter);
        return ifilter;
    }

    private IfilterWrapper getIfilterWrapperForGuid(String ifilterGuid) throws RegainException {
        IfilterWrapper ifilter = this.mGuidToIFilterHash.get(ifilterGuid);
        if (ifilter == null) {
            ifilter = new IfilterWrapper(ifilterGuid);
            this.mGuidToIFilterHash.put(ifilterGuid, ifilter);
        }
        return ifilter;
    }

    public void close() throws RegainException {
        for (IfilterWrapper ifilter : this.mGuidToIFilterHash.values()) {
            ifilter.close();
        }
        this.mExtensionToIFilterHash = null;
        this.mGuidToIFilterHash = null;
        IfilterWrapper.closeCom();
    }

    private static String getRegistryKeyValue(String regKey) throws RegainException {
        return IfilterPreparator.getRegistryKeyValue(regKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRegistryKeyValue(String regKey, String valueName) throws RegainException {
        String[] output;
        String[] cmdArr = new String[]{"reg", "query", regKey};
        try {
            output = CrawlerToolkit.executeNativeCommand((String[])cmdArr);
        }
        catch (RegainException exc) {
            return null;
        }
        int valueStartIdx = -1;
        for (int i = 0; i < output.length; ++i) {
            if (!output[i].equals(regKey)) continue;
            valueStartIdx = i + 1;
        }
        if (valueStartIdx == -1) {
            return null;
        }
        if (mValueRegex == null) {
            try {
                mValueRegex = new RE("^\\s+(.*)\\s+REG_SZ\\s+(.*)$");
            }
            catch (RESyntaxException exc) {
                throw new RegainException("Creating registry value regex failed", (Throwable)exc);
            }
        }
        RE rE = mValueRegex;
        synchronized (rE) {
            for (int i = valueStartIdx; i < output.length && mValueRegex.match(output[i]); ++i) {
                String name = mValueRegex.getParen(1).trim();
                if (!(valueName != null ? name.equals(valueName) : name.equals("<NO NAME>") || name.startsWith("("))) continue;
                return mValueRegex.getParen(2);
            }
        }
        return null;
    }

    private static String[] getRegistryKeyChildren(String regKey) {
        String[] output;
        String[] cmdArr = new String[]{"reg", "query", regKey};
        try {
            output = CrawlerToolkit.executeNativeCommand((String[])cmdArr);
        }
        catch (RegainException exc) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String childPrefix = regKey + "\\";
        for (int i = 0; i < output.length; ++i) {
            if (!output[i].startsWith(childPrefix)) continue;
            list.add(output[i].substring(childPrefix.length()));
        }
        String[] asArr = new String[list.size()];
        list.toArray(asArr);
        return asArr;
    }
}

