/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data.config.properties;

import io.netty.handler.flush.FlushConsolidationHandler;
import io.tarantool.balancer.BalancerMode;
import io.tarantool.balancer.TarantoolBalancer;
import io.tarantool.core.protocol.requests.IProtoAuth;
import io.tarantool.pool.HeartbeatOpts;
import io.tarantool.pool.InstanceConnectionGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BaseTarantoolProperties {
    private String host = "localhost";
    private String password = "secret-cluster-cookie";
    private int port = 3301;
    private String userName = "admin";
    private List<PropertyInstanceConnectionGroup> connectionGroups;
    private int eventLoopThreadsCount = 0;
    private boolean isGracefulShutdownEnabled = true;
    private PropertyHeartbeatOpts heartbeat;
    private long connectTimeout = 3000L;
    private long reconnectAfter = 1000L;
    private boolean fetchSchema = true;
    private boolean ignoreOldSchemaVersion = true;
    private BalancerMode balancerMode = BalancerMode.DEFAULT_BALANCER_MODE;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseTarantoolProperties)) {
            return false;
        }
        BaseTarantoolProperties that = (BaseTarantoolProperties)o;
        return this.getPort() == that.getPort() && this.getEventLoopThreadsCount() == that.getEventLoopThreadsCount() && this.isGracefulShutdownEnabled() == that.isGracefulShutdownEnabled() && this.getConnectTimeout() == that.getConnectTimeout() && this.getReconnectAfter() == that.getReconnectAfter() && this.isFetchSchema() == that.isFetchSchema() && this.isIgnoreOldSchemaVersion() == that.isIgnoreOldSchemaVersion() && Objects.equals(this.getHost(), that.getHost()) && Objects.equals(this.getPassword(), that.getPassword()) && Objects.equals(this.getUserName(), that.getUserName()) && Objects.equals(this.getConnectionGroups(), that.getConnectionGroups()) && Objects.equals(this.getHeartbeat(), that.getHeartbeat()) && this.getBalancerMode() == that.getBalancerMode();
    }

    public int hashCode() {
        return Objects.hash(this.getHost(), this.getPassword(), this.getPort(), this.getUserName(), this.getConnectionGroups(), this.getEventLoopThreadsCount(), this.isGracefulShutdownEnabled(), this.getHeartbeat(), this.getConnectTimeout(), this.getReconnectAfter(), this.isFetchSchema(), this.isIgnoreOldSchemaVersion(), this.getBalancerMode());
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getEventLoopThreadsCount() {
        return this.eventLoopThreadsCount;
    }

    public void setEventLoopThreadsCount(int eventLoopThreadsCount) {
        this.eventLoopThreadsCount = eventLoopThreadsCount;
    }

    public boolean isGracefulShutdownEnabled() {
        return this.isGracefulShutdownEnabled;
    }

    public void setGracefulShutdownEnabled(boolean gracefulShutdownEnabled) {
        this.isGracefulShutdownEnabled = gracefulShutdownEnabled;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getReconnectAfter() {
        return this.reconnectAfter;
    }

    public void setReconnectAfter(long reconnectAfter) {
        this.reconnectAfter = reconnectAfter;
    }

    public boolean isFetchSchema() {
        return this.fetchSchema;
    }

    public void setFetchSchema(boolean fetchSchema) {
        this.fetchSchema = fetchSchema;
    }

    public boolean isIgnoreOldSchemaVersion() {
        return this.ignoreOldSchemaVersion;
    }

    public void setIgnoreOldSchemaVersion(boolean ignoreOldSchemaVersion) {
        this.ignoreOldSchemaVersion = ignoreOldSchemaVersion;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public List<PropertyInstanceConnectionGroup> getConnectionGroups() {
        return this.connectionGroups;
    }

    public List<InstanceConnectionGroup> getInstanceConnectionGroups() {
        if (this.connectionGroups != null) {
            ArrayList<InstanceConnectionGroup> connectionGroups = new ArrayList<InstanceConnectionGroup>();
            for (PropertyInstanceConnectionGroup group : this.connectionGroups) {
                connectionGroups.add(group.getInstanceConnectionGroup());
            }
            return connectionGroups;
        }
        return null;
    }

    public void setConnectionGroups(List<PropertyInstanceConnectionGroup> connectionGroups) {
        this.connectionGroups = connectionGroups;
    }

    public PropertyHeartbeatOpts getHeartbeat() {
        return this.heartbeat;
    }

    public HeartbeatOpts getHeartbeatOpts() {
        if (this.getHeartbeat() != null) {
            return this.getHeartbeat().getHeartbeatOpts();
        }
        return null;
    }

    public void setHeartbeat(PropertyHeartbeatOpts propertyHeartbeatOptsOpts) {
        this.heartbeat = propertyHeartbeatOptsOpts;
    }

    public BalancerMode getBalancerMode() {
        return this.balancerMode;
    }

    public Class<? extends TarantoolBalancer> getBalancerClass() {
        return this.getBalancerMode().getBalancerClass();
    }

    public void setBalancerMode(BalancerMode balancerMode) {
        this.balancerMode = balancerMode;
    }

    public static class PropertyHeartbeatOpts {
        private long pingInterval = 3000L;
        private int invalidationThreshold = 2;
        private int windowSize = 4;
        private int deathThreshold = 4;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PropertyHeartbeatOpts)) {
                return false;
            }
            PropertyHeartbeatOpts propertyHeartbeatOpts = (PropertyHeartbeatOpts)o;
            return this.pingInterval == propertyHeartbeatOpts.pingInterval && this.invalidationThreshold == propertyHeartbeatOpts.invalidationThreshold && this.windowSize == propertyHeartbeatOpts.windowSize && this.deathThreshold == propertyHeartbeatOpts.deathThreshold;
        }

        public int hashCode() {
            return Objects.hash(this.pingInterval, this.invalidationThreshold, this.windowSize, this.deathThreshold);
        }

        public HeartbeatOpts getHeartbeatOpts() {
            return HeartbeatOpts.getDefault().withDeathThreshold(this.deathThreshold).withWindowSize(this.windowSize).withPingInterval(this.pingInterval).withInvalidationThreshold(this.invalidationThreshold);
        }

        public long getPingInterval() {
            return this.pingInterval;
        }

        public void setPingInterval(long pingInterval) {
            this.pingInterval = pingInterval;
        }

        public int getInvalidationThreshold() {
            return this.invalidationThreshold;
        }

        public void setInvalidationThreshold(int invalidationThreshold) {
            this.invalidationThreshold = invalidationThreshold;
        }

        public int getWindowSize() {
            return this.windowSize;
        }

        public void setWindowSize(int windowSize) {
            this.windowSize = windowSize;
        }

        public int getDeathThreshold() {
            return this.deathThreshold;
        }

        public void setDeathThreshold(int deathThreshold) {
            this.deathThreshold = deathThreshold;
        }
    }

    public static class PropertyInstanceConnectionGroup {
        private String host = "localhost";
        private String password = "secret-cluster-cookie";
        private int port = 3301;
        private int connectionGroupSize = 1;
        private String tag = "default";
        private String userName = "admin";
        private IProtoAuth.AuthType authType = IProtoAuth.DEFAULT_AUTH_TYPE;
        private PropertyFlushConsolidationHandler flushConsolidationHandler;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PropertyInstanceConnectionGroup)) {
                return false;
            }
            PropertyInstanceConnectionGroup that = (PropertyInstanceConnectionGroup)o;
            return this.port == that.port && this.connectionGroupSize == that.connectionGroupSize && Objects.equals(this.host, that.host) && Objects.equals(this.password, that.password) && Objects.equals(this.tag, that.tag) && Objects.equals(this.userName, that.userName) && this.authType == that.authType && Objects.equals(this.flushConsolidationHandler, that.flushConsolidationHandler);
        }

        public int hashCode() {
            return Objects.hash(this.host, this.password, this.port, this.connectionGroupSize, this.tag, this.userName, this.authType, this.flushConsolidationHandler);
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public int getConnectionGroupSize() {
            return this.connectionGroupSize;
        }

        public void setConnectionGroupSize(int connectionGroupSize) {
            this.connectionGroupSize = connectionGroupSize;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public IProtoAuth.AuthType getAuthType() {
            return this.authType;
        }

        public void setAuthType(IProtoAuth.AuthType authType) {
            this.authType = authType;
        }

        public void setFlushConsolidationHandler(PropertyFlushConsolidationHandler flushConsolidationHandler) {
            this.flushConsolidationHandler = flushConsolidationHandler;
        }

        public PropertyFlushConsolidationHandler getFlushConsolidationHandler() {
            return this.flushConsolidationHandler;
        }

        public InstanceConnectionGroup getInstanceConnectionGroup() {
            InstanceConnectionGroup.Builder builder = InstanceConnectionGroup.builder().withUser(this.userName).withPassword(this.password).withSize(this.connectionGroupSize).withPort(this.port).withHost(this.host).withAuthType(this.authType).withTag(this.tag);
            if (this.flushConsolidationHandler != null) {
                builder.withFlushConsolidationHandler(this.flushConsolidationHandler.getFlushConsolidationHandler());
            }
            return builder.build();
        }
    }

    public static class PropertyFlushConsolidationHandler {
        private int explicitFlushAfterFlushes = 256;
        private boolean consolidateWhenNoReadInProgress = false;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PropertyFlushConsolidationHandler)) {
                return false;
            }
            PropertyFlushConsolidationHandler that = (PropertyFlushConsolidationHandler)o;
            return this.explicitFlushAfterFlushes == that.explicitFlushAfterFlushes && this.consolidateWhenNoReadInProgress == that.consolidateWhenNoReadInProgress;
        }

        public int hashCode() {
            return Objects.hash(this.explicitFlushAfterFlushes, this.consolidateWhenNoReadInProgress);
        }

        public int getExplicitFlushAfterFlushes() {
            return this.explicitFlushAfterFlushes;
        }

        public void setExplicitFlushAfterFlushes(int explicitFlushAfterFlushes) {
            this.explicitFlushAfterFlushes = explicitFlushAfterFlushes;
        }

        public boolean isConsolidateWhenNoReadInProgress() {
            return this.consolidateWhenNoReadInProgress;
        }

        public void setConsolidateWhenNoReadInProgress(boolean consolidateWhenNoReadInProgress) {
            this.consolidateWhenNoReadInProgress = consolidateWhenNoReadInProgress;
        }

        public FlushConsolidationHandler getFlushConsolidationHandler() {
            return new FlushConsolidationHandler(this.explicitFlushAfterFlushes, this.consolidateWhenNoReadInProgress);
        }
    }
}

