/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.client.factory;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.jmx.JmxConfig;
import io.micrometer.jmx.JmxMeterRegistry;
import io.tarantool.client.factory.TarantoolBoxClientBuilder;
import io.tarantool.client.factory.TarantoolBoxClientImpl;
import io.tarantool.client.factory.TarantoolCrudClientBuilder;
import io.tarantool.client.factory.TarantoolCrudClientImpl;
import io.tarantool.core.exceptions.ClientException;

public class TarantoolFactory {
    private static MeterRegistry metricsRegistry = new JmxMeterRegistry(JmxConfig.DEFAULT, Clock.SYSTEM);
    private static Counter requestCounter;
    private static Counter responseSuccess;
    private static Counter responseErrors;
    private static Counter ignoredResponsesCounter;
    private static boolean metricsRegistered;

    private TarantoolFactory() {
    }

    public static void setMeterRegistry(MeterRegistry meterRegistry) {
        if (metricsRegistered) {
            throw new ClientException("Metrics has already been initialized, set meterRegistry before first factory usage");
        }
        metricsRegistry = meterRegistry;
    }

    private static void initMetricsIfNeeded() {
        if (metricsRegistry != null && !metricsRegistered) {
            LongTaskTimer.builder((String)"request.timer").description("Latency of requests to Tarantool").register(metricsRegistry);
            requestCounter = Counter.builder((String)"request.counter").description("Number of requests to Tarantool").register(metricsRegistry);
            responseSuccess = Counter.builder((String)"response.success").description("Number of successful responses").register(metricsRegistry);
            responseErrors = Counter.builder((String)"response.errors").description("Number of error responses").register(metricsRegistry);
            ignoredResponsesCounter = Counter.builder((String)"response.ignored").description("Number of ignored IProto packets").register(metricsRegistry);
            metricsRegistered = true;
        }
    }

    public static TarantoolBoxClientBuilder box() {
        TarantoolFactory.initMetricsIfNeeded();
        return TarantoolBoxClientImpl.builder().withMeterRegistry(metricsRegistry);
    }

    public static TarantoolCrudClientBuilder crud() {
        TarantoolFactory.initMetricsIfNeeded();
        return TarantoolCrudClientImpl.builder().withMeterRegistry(metricsRegistry);
    }

    public static double getRequestAmount() {
        TarantoolFactory.initMetricsIfNeeded();
        if (metricsRegistry == null) {
            throw new ClientException("No metrics exist");
        }
        return requestCounter.count();
    }

    public static double getResponseSuccessAmount() {
        TarantoolFactory.initMetricsIfNeeded();
        if (metricsRegistry == null) {
            throw new ClientException("No metrics exist");
        }
        return responseSuccess.count();
    }

    public static double getResponseErrorAmount() {
        TarantoolFactory.initMetricsIfNeeded();
        if (metricsRegistry == null) {
            throw new ClientException("No metrics exist");
        }
        return responseErrors.count();
    }

    public static double getIgnoredResponsesAmount() {
        TarantoolFactory.initMetricsIfNeeded();
        if (metricsRegistry == null) {
            throw new ClientException("No metrics exist");
        }
        return ignoredResponsesCounter.count();
    }
}

