/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.client.factory;

import io.micrometer.core.instrument.MeterRegistry;
import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContext;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.tarantool.balancer.TarantoolBalancer;
import io.tarantool.client.TarantoolClient;
import io.tarantool.client.crud.TarantoolCrudClient;
import io.tarantool.client.factory.TarantoolCrudClientImpl;
import io.tarantool.core.WatcherOptions;
import io.tarantool.core.protocol.IProtoResponse;
import io.tarantool.pool.HeartbeatOpts;
import io.tarantool.pool.InstanceConnectionGroup;
import io.tarantool.pool.TripleConsumer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TarantoolCrudClientBuilder {
    private final Map<ChannelOption<?>, Object> options = new HashMap(TarantoolClient.DEFAULT_NETTY_CHANNEL_OPTIONS);
    private String host = "localhost";
    private int port = 3301;
    private String user = "admin";
    private String password = "secret-cluster-cookie";
    private List<InstanceConnectionGroup> groups;
    private int nThreads = 0;
    private Timer timerService = new HashedWheelTimer();
    private boolean gracefulShutdown = true;
    private boolean useTupleExtension = false;
    private Class<? extends TarantoolBalancer> balancerClass = TarantoolBalancer.DEFAULT_BALANCER_CLASS;
    private HeartbeatOpts heartbeatOpts = null;
    private WatcherOptions watcherOpts = null;
    private long connectTimeout = 3000L;
    private long reconnectAfter = 1000L;
    private MeterRegistry metricsRegistry;
    private TripleConsumer<String, Integer, IProtoResponse> ignoredPacketsHandler;
    private SslContext sslContext;

    public Map<ChannelOption<?>, Object> getOptions() {
        return this.options;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public List<InstanceConnectionGroup> getGroups() {
        return this.groups;
    }

    public int getnThreads() {
        return this.nThreads;
    }

    public Timer getTimerService() {
        return this.timerService;
    }

    public boolean isGracefulShutdown() {
        return this.gracefulShutdown;
    }

    public Class<? extends TarantoolBalancer> getBalancerClass() {
        return this.balancerClass;
    }

    public HeartbeatOpts getHeartbeatOpts() {
        return this.heartbeatOpts;
    }

    public WatcherOptions getWatcherOpts() {
        return this.watcherOpts;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getReconnectAfter() {
        return this.reconnectAfter;
    }

    public MeterRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public TripleConsumer<String, Integer, IProtoResponse> getIgnoredPacketsHandler() {
        return this.ignoredPacketsHandler;
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    public TarantoolCrudClientBuilder withGroups(List<InstanceConnectionGroup> groups) {
        this.groups = groups;
        return this;
    }

    public TarantoolCrudClientBuilder withHost(String host) {
        if (host == null) {
            throw new IllegalArgumentException("Host can't be null");
        }
        this.host = host;
        return this;
    }

    public TarantoolCrudClientBuilder withPort(int port) {
        this.port = port;
        return this;
    }

    public TarantoolCrudClientBuilder withUser(String user) {
        this.user = user;
        return this;
    }

    public TarantoolCrudClientBuilder withPassword(String password) {
        this.password = password;
        return this;
    }

    public <T> TarantoolCrudClientBuilder withChannelOption(ChannelOption<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException("ChannelOption key can't be null");
        }
        this.options.put(key, value);
        return this;
    }

    public TarantoolCrudClientBuilder withChannelOptions(Map<ChannelOption<?>, Object> channelOptions) {
        this.options.putAll(channelOptions);
        return this;
    }

    public TarantoolCrudClientBuilder withEventLoopThreadsCount(int nThreads) {
        this.nThreads = nThreads;
        return this;
    }

    public TarantoolCrudClientBuilder withTimerService(Timer timerService) {
        if (timerService == null) {
            throw new IllegalArgumentException("Timer can't be null");
        }
        this.timerService = timerService;
        return this;
    }

    public TarantoolCrudClientBuilder disableGracefulShutdown() {
        this.gracefulShutdown = false;
        return this;
    }

    public TarantoolCrudClientBuilder enableTupleExtension() {
        this.useTupleExtension = true;
        return this;
    }

    public TarantoolCrudClientBuilder withBalancerClass(Class<? extends TarantoolBalancer> balancerClass) {
        if (balancerClass == null) {
            throw new IllegalArgumentException("BalancerClass key can't be null");
        }
        this.balancerClass = balancerClass;
        return this;
    }

    public TarantoolCrudClientBuilder withHeartbeat(HeartbeatOpts opts) {
        this.heartbeatOpts = opts;
        return this;
    }

    public TarantoolCrudClientBuilder withWatcherOptions(WatcherOptions opts) {
        this.watcherOpts = opts;
        return this;
    }

    public TarantoolCrudClientBuilder withConnectTimeout(long timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    public TarantoolCrudClientBuilder withReconnectAfter(long after) {
        this.reconnectAfter = after;
        return this;
    }

    public TarantoolCrudClientBuilder withMeterRegistry(MeterRegistry metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
        return this;
    }

    public TarantoolCrudClientBuilder withIgnoredPacketsHandler(TripleConsumer<String, Integer, IProtoResponse> handler) {
        this.ignoredPacketsHandler = handler;
        return this;
    }

    public TarantoolCrudClientBuilder withSslContext(SslContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public TarantoolCrudClient build() throws Exception {
        if (this.groups == null) {
            this.groups = Collections.singletonList(InstanceConnectionGroup.builder().withHost(this.host).withPort(this.port).withSize(1).withTag("default").withUser(this.user).withPassword(this.password).build());
        }
        return new TarantoolCrudClientImpl(this.groups, this.options, this.nThreads, this.timerService, this.gracefulShutdown, this.balancerClass, this.heartbeatOpts, this.watcherOpts, this.connectTimeout, this.reconnectAfter, this.metricsRegistry, this.ignoredPacketsHandler, this.sslContext, this.useTupleExtension);
    }
}

