/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data32.repository.config;

import io.tarantool.client.ClientType;
import io.tarantool.spring.data32.config.TarantoolCrudConfiguration;
import io.tarantool.spring.data32.core.TarantoolTemplate;
import io.tarantool.spring.data32.core.mapping.TarantoolMappingContext;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.data.keyvalue.repository.config.KeyValueRepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryConfigurationSource;

public class TarantoolRepositoryConfigurationExtension
extends KeyValueRepositoryConfigurationExtension {
    public String getModuleName() {
        return "Tarantool";
    }

    public String getModulePrefix() {
        return "tarantool";
    }

    public String getDefaultKeyValueTemplateRef() {
        return "keyValueTemplate";
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        ClientType clientTypeAttribute = (ClientType)configurationSource.getRequiredAttribute("clientType", ClientType.class);
        if (clientTypeAttribute != ClientType.CRUD) {
            throw new IllegalArgumentException("The Box client is not yet supported.");
        }
        String defaultCrudConfigurationBeanName = TarantoolCrudConfiguration.class.getCanonicalName();
        TarantoolRepositoryConfigurationExtension.registerIfNotAlreadyRegistered(() -> new RootBeanDefinition(TarantoolCrudConfiguration.class), (BeanDefinitionRegistry)registry, (String)defaultCrudConfigurationBeanName, (Object)configurationSource);
        super.registerBeansForRoot(registry, configurationSource);
        registry.removeBeanDefinition(this.getMappingContextBeanRef());
        TarantoolRepositoryConfigurationExtension.registerIfNotAlreadyRegistered(() -> {
            RootBeanDefinition definition = new RootBeanDefinition(TarantoolMappingContext.class);
            definition.setSource(configurationSource.getSource());
            return definition;
        }, (BeanDefinitionRegistry)registry, (String)this.getMappingContextBeanRef(), (Object)configurationSource);
    }

    protected AbstractBeanDefinition getDefaultKeyValueTemplateBeanDefinition(RepositoryConfigurationSource configurationSource) {
        RootBeanDefinition keyValueTemplateBeanDefinition = new RootBeanDefinition(TarantoolTemplate.class);
        ConstructorArgumentValues constructorArgumentValues = new ConstructorArgumentValues();
        constructorArgumentValues.addIndexedArgumentValue(0, (Object)new RuntimeBeanReference("tarantoolCrudKeyValueAdapter"));
        constructorArgumentValues.addIndexedArgumentValue(1, (Object)new RuntimeBeanReference(this.getMappingContextBeanRef()));
        keyValueTemplateBeanDefinition.setConstructorArgumentValues(constructorArgumentValues);
        keyValueTemplateBeanDefinition.setSource((Object)configurationSource);
        keyValueTemplateBeanDefinition.setDependsOn(new String[]{"tarantoolCrudKeyValueAdapter"});
        keyValueTemplateBeanDefinition.setDependsOn(new String[]{this.getMappingContextBeanRef()});
        return keyValueTemplateBeanDefinition;
    }
}

