/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data32.query;

import io.tarantool.spring.data32.query.TarantoolScrollPosition;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.springframework.data.domain.Window;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class TarantoolWindowIterator<T>
implements Iterator<T> {
    private final Function<TarantoolScrollPosition, Window<T>> windowFunction;
    private TarantoolScrollPosition currentPosition;
    @Nullable
    private Window<T> currentWindow;
    @Nullable
    private Iterator<T> currentIterator;

    public static <T> TarantoolWindowIteratorBuilder<T> of(Function<TarantoolScrollPosition, Window<T>> windowFunction) {
        return new TarantoolWindowIteratorBuilder<T>(windowFunction);
    }

    TarantoolWindowIterator(Function<TarantoolScrollPosition, Window<T>> windowFunction, TarantoolScrollPosition position) {
        this.windowFunction = windowFunction;
        this.currentPosition = position;
    }

    @Override
    public boolean hasNext() {
        while (true) {
            if (this.currentWindow == null) {
                this.currentWindow = this.windowFunction.apply(this.currentPosition);
            }
            if (this.currentIterator == null && this.currentWindow != null) {
                this.currentIterator = this.currentWindow.iterator();
            }
            if (this.currentIterator == null) break;
            if (this.currentIterator.hasNext()) {
                return true;
            }
            if (this.currentWindow == null || !this.currentWindow.hasNext()) break;
            this.currentPosition = TarantoolWindowIterator.getNextPosition(this.currentWindow);
            this.currentIterator = null;
            this.currentWindow = null;
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentIterator.next();
    }

    private static TarantoolScrollPosition getNextPosition(Window<?> window) {
        return (TarantoolScrollPosition)window.positionAt(window.size() - 1);
    }

    public static class TarantoolWindowIteratorBuilder<T> {
        private final Function<TarantoolScrollPosition, Window<T>> windowFunction;

        TarantoolWindowIteratorBuilder(Function<TarantoolScrollPosition, Window<T>> windowFunction) {
            Assert.notNull(windowFunction, (String)"WindowFunction must not be null");
            this.windowFunction = windowFunction;
        }

        public TarantoolWindowIterator<T> startingAt(TarantoolScrollPosition position) {
            Assert.notNull((Object)position, (String)"TarantoolScrollPosition must not be null");
            return new TarantoolWindowIterator<T>(this.windowFunction, position);
        }
    }
}

