/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data32.query;

import io.tarantool.spring.data.query.PaginationDirection;
import io.tarantool.spring.data.query.TarantoolCriteria;
import io.tarantool.spring.data32.query.TarantoolPageImpl;
import io.tarantool.spring.data32.query.TarantoolPageable;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.util.Assert;

public class PaginationUtils {
    private static final String CRITERIA_NULL_EXC_MSG = "TarantoolCriteria must be not null";

    public static TarantoolPageable<?> castToTarantoolPageable(Pageable sliceParams) {
        Assert.isInstanceOf(TarantoolPageable.class, (Object)sliceParams, (String)"Pageable must be TarantoolPageable");
        return (TarantoolPageable)sliceParams;
    }

    public static List<?> doPaginationQuery(KeyValueQuery<?> query, TarantoolPageable<?> pageRequest, int pageSize, KeyValueOperations keyValueOperations, Class<?> targetType) {
        TarantoolCriteria criteria = (TarantoolCriteria)query.getCriteria();
        PaginationDirection paginationDirection = pageRequest.getPaginationDirection();
        Assert.notNull((Object)criteria, (String)CRITERIA_NULL_EXC_MSG);
        criteria.withAfter(pageRequest.getTupleCursor());
        query.setRows(pageSize * paginationDirection.getMultiplier());
        return IterableConverter.toList((Iterable)keyValueOperations.find(query, targetType));
    }

    public static Page<?> doPageQuery(Pageable pageable, KeyValueQuery<?> query, KeyValueOperations keyValueOperations, Class<?> targetType) {
        int pageSize;
        if (pageable.isUnpaged()) {
            return new TarantoolPageImpl();
        }
        TarantoolPageable<?> resultSliceParams = PaginationUtils.castToTarantoolPageable(pageable);
        List<?> content = PaginationUtils.doPaginationQuery(query, resultSliceParams, pageSize = resultSliceParams.getPageSize(), keyValueOperations, targetType);
        if (content.isEmpty()) {
            return new TarantoolPageImpl();
        }
        long totalElements = keyValueOperations.count(query, targetType);
        return new TarantoolPageImpl(content, resultSliceParams, totalElements);
    }
}

