/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data32.core.mapping.model;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.springframework.data.mapping.TargetAwareIdentifierAccessor;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class CompositeIdPropertyAccessor
extends TargetAwareIdentifierAccessor {
    private final Map<Field, Field> entityIdClassFields;
    private final Class<?> idClassType;
    private final Object target;

    public CompositeIdPropertyAccessor(Object target, @NonNull Map<Field, Field> entityIdClassFields, Class<?> idClassType) {
        super(target);
        this.target = target;
        this.entityIdClassFields = entityIdClassFields;
        this.idClassType = idClassType;
    }

    @Nullable
    public Object getIdentifier() {
        try {
            return this.generateIdentifier();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Object generateIdentifier() throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Assert.notNull((Object)this.target, (String)"target object must be not null!");
        Object compositeKey = this.idClassType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        for (Map.Entry<Field, Field> fieldPair : this.entityIdClassFields.entrySet()) {
            this.writeValuesFromEntityId(compositeKey, fieldPair.getKey(), fieldPair.getValue());
        }
        return compositeKey;
    }

    private void writeValuesFromEntityId(Object compositeKey, Field entityField, Field compositeKeyField) {
        ReflectionUtils.makeAccessible((Field)entityField);
        ReflectionUtils.makeAccessible((Field)compositeKeyField);
        Object value = ReflectionUtils.getField((Field)entityField, (Object)this.target);
        ReflectionUtils.setField((Field)compositeKeyField, (Object)compositeKey, (Object)value);
    }
}

