/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data32.core.mapping;

import io.tarantool.spring.data.core.annotation.IdClassResolver;
import io.tarantool.spring.data32.core.annotation.DefaultIdClassResolver;
import io.tarantool.spring.data32.core.mapping.BasicKeyValueCompositePersistentEntity;
import io.tarantool.spring.data32.core.mapping.KeyValueCompositePersistentEntity;
import io.tarantool.spring.data32.core.mapping.KeyValueCompositeProperty;
import org.springframework.data.keyvalue.core.mapping.BasicKeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeySpaceResolver;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.keyvalue.core.mapping.context.KeyValueMappingContext;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;

public class TarantoolMappingContext<E extends KeyValuePersistentEntity<?, P>, P extends KeyValuePersistentProperty<P>>
extends KeyValueMappingContext<E, P> {
    private final IdClassResolver idClassResolver = DefaultIdClassResolver.INSTANCE;
    @Nullable
    private KeySpaceResolver fallbackKeySpaceResolver;

    public void setFallbackKeySpaceResolver(KeySpaceResolver fallbackKeySpaceResolver) {
        super.setFallbackKeySpaceResolver(fallbackKeySpaceResolver);
        this.fallbackKeySpaceResolver = fallbackKeySpaceResolver;
    }

    protected <T> E createPersistentEntity(TypeInformation<T> typeInformation) {
        Class idClassTypeValue = this.idClassResolver.resolveIdClassType(typeInformation.getType());
        if (idClassTypeValue == null) {
            return (E)new BasicKeyValuePersistentEntity(typeInformation, this.fallbackKeySpaceResolver);
        }
        return (E)new BasicKeyValueCompositePersistentEntity(typeInformation, this.fallbackKeySpaceResolver, idClassTypeValue);
    }

    protected P createPersistentProperty(Property property, E owner, SimpleTypeHolder simpleTypeHolder) {
        if (KeyValueCompositePersistentEntity.class.isAssignableFrom(owner.getClass())) {
            return (P)new KeyValueCompositeProperty(property, owner, simpleTypeHolder);
        }
        return (P)new KeyValuePersistentProperty(property, owner, simpleTypeHolder);
    }
}

