/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data32.core.mapping;

import io.tarantool.spring.data32.core.mapping.Identifier;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.util.Assert;

public class KeyValueCompositeProperty<P extends KeyValuePersistentProperty<P>>
extends KeyValuePersistentProperty<P>
implements Identifier<P> {
    private final List<P> identifierPartsWithoutFirst = new ArrayList<P>();

    public KeyValueCompositeProperty(Property property, PersistentEntity<?, P> owner, SimpleTypeHolder simpleTypeHolder) {
        super(property, owner, simpleTypeHolder);
    }

    @Override
    public void addPart(P property) {
        Assert.notNull(property, (String)"property must be not null");
        if (this.equals(property) || this.identifierPartsWithoutFirst.contains(property)) {
            return;
        }
        this.identifierPartsWithoutFirst.add(property);
    }

    @Override
    public Collection<P> getParts() {
        ArrayList<P> resultList = new ArrayList<P>(this.identifierPartsWithoutFirst);
        resultList.add(0, this);
        return resultList;
    }

    @Override
    public Field[] getFields() {
        int totalSize = this.identifierPartsWithoutFirst.size() + 1;
        Field[] fields = new Field[totalSize];
        fields[0] = this.getField();
        for (int i = 1; i < totalSize; ++i) {
            fields[i] = ((KeyValuePersistentProperty)this.identifierPartsWithoutFirst.get(i - 1)).getField();
        }
        return fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyValueCompositeProperty other = (KeyValueCompositeProperty)o;
        if (this.identifierPartsWithoutFirst.isEmpty() && other.identifierPartsWithoutFirst.isEmpty()) {
            return super.equals(o);
        }
        if (this.identifierPartsWithoutFirst.size() != other.identifierPartsWithoutFirst.size() || !other.getProperty().equals((Object)this.getProperty())) {
            return false;
        }
        for (int i = 0; i < this.identifierPartsWithoutFirst.size(); ++i) {
            Property otherKeyPartProperty;
            Property thisKeyPartProperty = ((KeyValueCompositeProperty)this.identifierPartsWithoutFirst.get(i)).getProperty();
            if (thisKeyPartProperty.equals((Object)(otherKeyPartProperty = ((KeyValueCompositeProperty)other.identifierPartsWithoutFirst.get(i)).getProperty()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        if (this.identifierPartsWithoutFirst.isEmpty()) {
            return hashCode;
        }
        return Objects.hash(hashCode, this.identifierPartsWithoutFirst);
    }
}

