/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data32.core.annotation;

import io.tarantool.spring.data.core.annotation.IdClass;
import io.tarantool.spring.data.core.annotation.IdClassResolver;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public enum DefaultIdClassResolver implements IdClassResolver
{
    INSTANCE;

    public static final String ANNOTATION_TYPE_EXCEPTION = "The class of a composite identifier specified in the @IdClass annotation cannot be annotation!";

    @Nullable
    public Class<?> resolveIdClassType(Class<?> type) {
        Assert.notNull(type, (String)"Type for IdClass must be not null!");
        IdClass idClassTypeAnnotation = (IdClass)AnnotatedElementUtils.findMergedAnnotation(type, IdClass.class);
        if (idClassTypeAnnotation == null) {
            return null;
        }
        Class idClassTypeValue = idClassTypeAnnotation.value();
        Assert.isTrue((!idClassTypeValue.isAnnotation() ? 1 : 0) != 0, (String)ANNOTATION_TYPE_EXCEPTION);
        return idClassTypeValue;
    }
}

