/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.protocol.requests;

import io.tarantool.core.protocol.requests.IProtoBaseRequest;
import io.tarantool.core.protocol.requests.IProtoConstant;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class IProtoExecute
extends IProtoBaseRequest {
    private final Boolean withStatementId;
    private final long statementId;
    private final String statementText;
    private ArrayValue sqlBind;
    private ArrayValue options;
    private byte[] rawSqlBind;
    private byte[] rawOptions;

    public IProtoExecute(long statementId, ArrayValue sqlBind, ArrayValue options, Long streamId) {
        this.setStreamId(streamId);
        this.withStatementId = true;
        this.statementId = statementId;
        this.statementText = "";
        this.sqlBind = sqlBind;
        this.options = options;
    }

    public IProtoExecute(long statementId, byte[] sqlBind, byte[] options, Long streamId) {
        this.setStreamId(streamId);
        this.withStatementId = true;
        this.statementId = statementId;
        this.statementText = "";
        this.rawSqlBind = sqlBind;
        this.rawOptions = options;
    }

    public IProtoExecute(String statementText, ArrayValue sqlBind, ArrayValue options, Long streamId) {
        this.setStreamId(streamId);
        this.withStatementId = false;
        this.statementId = 0L;
        this.statementText = statementText;
        this.sqlBind = sqlBind;
        this.options = options;
    }

    public IProtoExecute(String statementText, byte[] sqlBind, byte[] options, Long streamId) {
        this.setStreamId(streamId);
        this.withStatementId = false;
        this.statementId = 0L;
        this.statementText = statementText;
        this.rawSqlBind = sqlBind;
        this.rawOptions = options;
    }

    @Override
    public byte[] getPacket(MessageBufferPacker packer) throws IOException {
        this.preparePacker(packer);
        packer.addPayload(IProtoConstant.RAW_MAP_HEADER_WITH_THREE_ITEMS);
        if (this.withStatementId.booleanValue()) {
            packer.addPayload(IProtoConstant.RAW_IPROTO_STMT_ID);
            packer.packLong(this.statementId);
        } else {
            packer.addPayload(IProtoConstant.RAW_IPROTO_SQL_TEXT);
            packer.packString(this.statementText);
        }
        packer.addPayload(IProtoConstant.RAW_IPROTO_SQL_BIND);
        this.packValue(packer, this.rawSqlBind, (Value)this.sqlBind);
        packer.addPayload(IProtoConstant.RAW_IPROTO_OPTIONS);
        this.packValue(packer, this.rawOptions, (Value)this.options);
        return this.getPacketFromBase(packer);
    }

    @Override
    public MapValue getBody() {
        HashMap<Value, Object> map = new HashMap<Value, Object>();
        if (this.withStatementId.booleanValue()) {
            map.put(IProtoConstant.MP_IPROTO_STMT_ID, ValueFactory.newInteger((long)this.statementId));
        } else {
            map.put(IProtoConstant.MP_IPROTO_SQL_TEXT, ValueFactory.newString((String)this.statementText));
        }
        map.put(IProtoConstant.MP_IPROTO_SQL_BIND, this.sqlBind);
        map.put(IProtoConstant.MP_IPROTO_OPTIONS, this.options);
        return ValueFactory.newMap(map);
    }

    @Override
    protected byte[] getRequestTypeRaw() {
        return IProtoConstant.RAW_IPROTO_TYPE_EXECUTE;
    }

    @Override
    public int getRequestType() {
        return 11;
    }

    public String toString() {
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder();
            if (this.withStatementId.booleanValue()) {
                this.stringBuilder.append("IProtoExecute(syncId = ").append(this.getSyncId()).append(", statementId = ").append(this.statementId).append(", sqlBind = ").append(this.sqlBind != null ? this.sqlBind : Arrays.toString(this.rawSqlBind)).append(", options = ").append(this.options != null ? this.options : Arrays.toString(this.rawOptions)).append(", streamId = ").append(this.getStreamId()).append(")");
            } else {
                this.stringBuilder.append("IProtoExecute(syncId = ").append(this.getSyncId()).append(", statementText = ").append(this.statementText).append(", sqlBind = ").append(this.sqlBind != null ? this.sqlBind : Arrays.toString(this.rawSqlBind)).append(", options = ").append(this.options != null ? this.options : Arrays.toString(this.rawOptions)).append(", streamId = ").append(this.getStreamId()).append(")");
            }
        }
        return this.stringBuilder.toString();
    }
}

