/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.protocol.requests;

import io.tarantool.core.protocol.IProtoRequest;
import io.tarantool.core.protocol.requests.IProtoConstant;
import java.io.IOException;
import java.util.HashMap;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.msgpack.value.ImmutableIntegerValue;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public abstract class IProtoBaseRequest
implements IProtoRequest {
    protected long syncId = -1L;
    protected Long streamId;
    protected StringBuilder stringBuilder;

    protected static byte[] packType(int type) {
        byte[] byArray;
        block8: {
            MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();
            try {
                packer.packInt(type);
                byte[] typeRaw = packer.toByteArray();
                packer.clear();
                byArray = typeRaw;
                if (packer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (packer != null) {
                        try {
                            packer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            packer.close();
        }
        return byArray;
    }

    protected static void reserveBytesForSize(MessageBufferPacker packer) throws IOException {
        packer.addPayload(IProtoConstant.RAW_UINT32_RESERVED_FOR_SIZE);
    }

    protected static void patchSize(byte[] packet) {
        int packetSize = packet.length - 5;
        packet[1] = (byte)(packetSize >>> 24);
        packet[2] = (byte)(packetSize >>> 16);
        packet[3] = (byte)(packetSize >>> 8);
        packet[4] = (byte)packetSize;
    }

    protected MessageBufferPacker preparePacker(MessageBufferPacker packer) throws IOException {
        IProtoBaseRequest.reserveBytesForSize(packer);
        this.packHeader(packer);
        return packer;
    }

    protected byte[] getPacketFromBase(MessageBufferPacker packer) throws IOException {
        packer.flush();
        byte[] packet = packer.toByteArray();
        packer.close();
        IProtoBaseRequest.patchSize(packet);
        return packet;
    }

    protected void packHeader(MessageBufferPacker packer) throws IOException {
        if (this.streamId != null) {
            packer.addPayload(IProtoConstant.RAW_MAP_HEADER_WITH_THREE_ITEMS_PLUS_IPROTO_STREAM_ID);
            packer.packLong(this.streamId.longValue());
        } else {
            packer.addPayload(IProtoConstant.RAW_MAP_HEADER_WITH_TWO_ITEMS);
        }
        packer.addPayload(IProtoConstant.RAW_IPROTO_REQUEST_TYPE);
        packer.addPayload(this.getRequestTypeRaw());
        packer.addPayload(IProtoConstant.RAW_IPROTO_SYNC_ID);
        packer.packLong(this.syncId);
    }

    protected void packValue(MessageBufferPacker packer, byte[] rawValue, Value value) throws IOException {
        if (rawValue != null) {
            packer.addPayload(rawValue);
            return;
        }
        packer.packValue(value);
    }

    protected abstract byte[] getRequestTypeRaw();

    @Override
    public abstract MapValue getBody() throws Exception;

    @Override
    public MapValue getHeader() {
        HashMap<Value, ImmutableIntegerValue> map = new HashMap<Value, ImmutableIntegerValue>();
        map.put(IProtoConstant.MP_IPROTO_REQUEST_TYPE, ValueFactory.newInteger((int)this.getRequestType()));
        map.put(IProtoConstant.MP_IPROTO_SYNC_ID, ValueFactory.newInteger((long)this.getSyncId()));
        if (this.streamId != null) {
            map.put(IProtoConstant.MP_IPROTO_STREAM_ID, ValueFactory.newInteger((long)this.streamId));
        }
        return ValueFactory.newMap(map);
    }

    @Override
    public long getSyncId() {
        return this.syncId;
    }

    @Override
    public void setSyncId(long syncId) {
        this.syncId = syncId;
    }

    @Override
    public boolean hasSyncId() {
        return this.syncId != -1L;
    }

    @Override
    public abstract int getRequestType();

    public Long getStreamId() {
        return this.streamId;
    }

    public void setStreamId(Long streamId) {
        this.streamId = streamId;
    }
}

