/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.connection.codecs;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.tarantool.core.protocol.IProtoRawResponse;
import java.io.IOException;
import java.util.List;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ImmutableMapValue;
import org.msgpack.value.MapValue;

public class IProtoFrameDecoder
extends ReplayingDecoder<DecoderState> {
    private static final int MINIMAL_HEADER_SIZE = 5;
    private int size;

    public IProtoFrameDecoder() {
        super((Object)DecoderState.LENGTH);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> list) throws Exception {
        switch (((DecoderState)((Object)this.state())).ordinal()) {
            case 0: {
                this.readSize(byteBuf);
                this.checkpoint((Object)DecoderState.BODY);
            }
            case 1: {
                this.readPacket(byteBuf, list);
                this.checkpoint((Object)DecoderState.LENGTH);
                break;
            }
            default: {
                throw new Error("Shouldn't reach here.");
            }
        }
    }

    private void readSize(ByteBuf buf) throws IOException {
        byte[] mpSize = new byte[5];
        buf.readBytes(mpSize, 0, 5);
        try (MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])mpSize);){
            this.size = unpacker.unpackInt();
        }
    }

    private void readPacket(ByteBuf buf, List<Object> list) throws IOException {
        if (this.size <= 0) {
            return;
        }
        byte[] packet = new byte[this.size];
        buf.readBytes(packet, 0, this.size);
        try (MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])packet);){
            ImmutableMapValue header = unpacker.unpackValue().asMapValue();
            int read = (int)unpacker.getTotalReadBytes();
            list.add(new IProtoRawResponse((MapValue)header, packet, read));
            this.size = 0;
        }
    }

    protected static enum DecoderState {
        LENGTH,
        BODY;

    }
}

