/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core;

import io.tarantool.core.protocol.IProtoResponse;
import io.tarantool.core.protocol.fsm.WatcherStateMachine;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.msgpack.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Watcher
implements Consumer<IProtoResponse> {
    private static final Logger log = LoggerFactory.getLogger(Watcher.class);
    private final List<Consumer<IProtoResponse>> callbacks = new ArrayList<Consumer<IProtoResponse>>();
    private WatcherStateMachine context;
    private long syncId;

    public void addRawCallback(Consumer<IProtoResponse> callback) {
        if (callback != null) {
            this.callbacks.add(callback);
        }
    }

    public void setStateContext(WatcherStateMachine context) {
        this.context = context;
    }

    public WatcherStateMachine getStateContext() {
        return this.context;
    }

    public void setSyncId(long syncId) {
        this.syncId = syncId;
    }

    public long getSyncId() {
        return this.syncId;
    }

    @Override
    public void accept(IProtoResponse message) {
        Value data = message.getBodyValue(88);
        if (data != null && !data.isNilValue()) {
            for (Consumer<IProtoResponse> callback : this.callbacks) {
                try {
                    callback.accept(message);
                }
                catch (Exception e) {
                    log.error("watcher callback error: %s", (Throwable)e);
                }
            }
        }
    }
}

