/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.balancer;

import io.tarantool.balancer.TarantoolBalancer;
import io.tarantool.balancer.exceptions.NoAvailableClientsException;
import io.tarantool.core.IProtoClient;
import io.tarantool.pool.IProtoClientPool;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class TarantoolRoundRobinBalancer
implements TarantoolBalancer {
    private final IProtoClientPool pool;
    private List<String> tags;
    private String currentTag;
    private int currentTagIndex;
    private int currentConnectionIndex;

    public TarantoolRoundRobinBalancer(IProtoClientPool pool) {
        this.pool = pool;
        this.tags = pool.getTags();
        this.currentTagIndex = 0;
        this.currentConnectionIndex = 0;
        this.currentTag = this.tags.get(this.currentTagIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<IProtoClient> getNext() {
        while (this.pool.hasAvailableClients()) {
            TarantoolRoundRobinBalancer tarantoolRoundRobinBalancer = this;
            synchronized (tarantoolRoundRobinBalancer) {
                CompletableFuture clientFuture;
                if (this.currentConnectionIndex >= this.pool.getGroupSize(this.currentTag)) {
                    this.currentConnectionIndex = 0;
                    ++this.currentTagIndex;
                    if (this.currentTagIndex >= this.tags.size()) {
                        this.currentTagIndex = 0;
                    }
                    this.currentTag = this.tags.get(this.currentTagIndex);
                }
                if ((clientFuture = this.pool.get(this.currentTag, this.currentConnectionIndex++)) == null) {
                    continue;
                }
                return ((CompletableFuture)clientFuture.handle((connect, exc) -> {
                    if (exc != null) {
                        return this.getNext();
                    }
                    return CompletableFuture.completedFuture(connect);
                })).thenCompose(x -> x);
            }
        }
        CompletableFuture<IProtoClient> future = new CompletableFuture<IProtoClient>();
        future.completeExceptionally(new NoAvailableClientsException());
        return future;
    }

    @Override
    public IProtoClientPool getPool() {
        return this.pool;
    }

    @Override
    public void close() throws Exception {
        this.pool.close();
    }
}

