/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.pool;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.tarantool.core.IProtoClient;
import io.tarantool.core.IProtoClientImpl;
import io.tarantool.core.WatcherOptions;
import io.tarantool.core.connection.ConnectionCloseEvent;
import io.tarantool.core.connection.ConnectionFactory;
import io.tarantool.core.connection.exceptions.ConnectionException;
import io.tarantool.core.protocol.IProtoRequestOpts;
import io.tarantool.core.protocol.IProtoResponse;
import io.tarantool.pool.HeartbeatEvent;
import io.tarantool.pool.HeartbeatOpts;
import io.tarantool.pool.InstanceConnectionGroup;
import io.tarantool.pool.TripleConsumer;
import java.util.ArrayDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.msgpack.value.impl.ImmutableBooleanValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PoolEntry {
    private static final IProtoRequestOpts firstPingOpts = IProtoRequestOpts.empty().withRequestTimeout(1000L);
    private static final Logger log = LoggerFactory.getLogger(PoolEntry.class);
    private final ArrayDeque<Integer> window;
    private final AtomicInteger unavailable;
    private final AtomicInteger reconnecting;
    private final HeartbeatOpts heartbeatOpts;
    private final IProtoClient client;
    private final IProtoRequestOpts heartbeatPingOpts;
    private final InstanceConnectionGroup group;
    private final String tag;
    private final Timer timerService;
    private final boolean gracefulShutdown;
    private final int deathThreshold;
    private final int failedPingsThreshold;
    private final int index;
    private final int windowSize;
    private final long reconnectAfter;
    private final BiFunction<IProtoClient, IProtoRequestOpts, CompletableFuture<IProtoResponse>> pingFunction;
    private final boolean useTupleExtension;
    private final MeterRegistry metricsRegistry;
    private CompletableFuture<IProtoClient> connectFuture;
    private HeartbeatEvent lastHeartbeatEvent;
    private Timeout heartbeatTask;
    private Timeout reconnectTask;
    private boolean isHeartbeatStarted;
    private boolean isLocked;
    private int currentDeathPings;
    private int currentFailedPings;
    private long lastPingTs;
    private long connectTimeout;
    private Counter connectSuccess;
    private Counter connectErrors;
    private LongTaskTimer connectTime;
    private Counter heartbeatSuccess;
    private Counter heartbeatErrors;
    private LongTaskTimer heartbeatTime;

    public PoolEntry(ConnectionFactory factory, Timer timerService, InstanceConnectionGroup group, int index, boolean gracefulShutdown, long connectTimeout, long reconnectAfter, HeartbeatOpts heartbeatOpts, WatcherOptions watcherOpts, AtomicInteger unavailable, AtomicInteger reconnecting, MeterRegistry registry, TripleConsumer<String, Integer, IProtoResponse> ignoredPacketsHandler, boolean useTupleExtension) {
        this.metricsRegistry = registry;
        this.client = new IProtoClientImpl(factory, timerService, watcherOpts, registry, group.getFlushConsolidationHandler(), useTupleExtension);
        this.isHeartbeatStarted = false;
        this.lastHeartbeatEvent = HeartbeatEvent.KILL;
        if (heartbeatOpts == null) {
            this.heartbeatOpts = null;
            this.heartbeatPingOpts = null;
            this.deathThreshold = 0;
            this.failedPingsThreshold = 0;
            this.windowSize = 0;
            this.window = null;
            this.pingFunction = null;
        } else {
            this.heartbeatOpts = heartbeatOpts;
            this.heartbeatPingOpts = IProtoRequestOpts.empty().withRequestTimeout(heartbeatOpts.getPingInterval());
            this.deathThreshold = heartbeatOpts.getDeathThreshold();
            this.failedPingsThreshold = heartbeatOpts.getInvalidationThreshold();
            this.windowSize = heartbeatOpts.getWindowSize();
            this.window = new ArrayDeque(this.windowSize);
            this.pingFunction = heartbeatOpts.getPingFunction();
        }
        this.connectTimeout = connectTimeout;
        this.gracefulShutdown = gracefulShutdown;
        this.group = group;
        this.index = index;
        this.isLocked = false;
        this.reconnectAfter = reconnectAfter;
        this.tag = group.getTag();
        this.timerService = timerService;
        this.unavailable = unavailable;
        this.reconnecting = reconnecting;
        this.client.onClose(ConnectionCloseEvent.CLOSE_BY_REMOTE, this::handleConnectError);
        this.client.onClose(ConnectionCloseEvent.CLOSE_BY_SHUTDOWN, this::handleConnectError);
        this.useTupleExtension = useTupleExtension;
        if (ignoredPacketsHandler != null) {
            this.client.onIgnoredPacket(packet -> ignoredPacketsHandler.accept(this.tag, this.index, (IProtoResponse)packet));
        }
        this.initMetrics();
    }

    public IProtoClient getClient() {
        return this.client;
    }

    public void lock() {
        if (!this.isLocked) {
            this.unavailable.incrementAndGet();
            this.isLocked = true;
        }
    }

    public void unlock() {
        if (this.isLocked) {
            this.stopReconnectTask();
            this.unavailable.decrementAndGet();
            this.isLocked = false;
        }
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void close() {
        this.stopReconnectTask();
        this.shutdown();
    }

    public void shutdown() {
        this.connectFuture = null;
        this.stopHeartbeat();
        try {
            this.client.close();
        }
        catch (Exception e) {
            log.warn("Cannot close client in pool", (Throwable)e);
        }
    }

    public synchronized CompletableFuture<IProtoClient> connect() {
        if (this.connectFuture != null) {
            return this.connectFuture;
        }
        return this.internalConnect();
    }

    public void setConnectTimeout(long timeout) {
        this.connectTimeout = timeout;
    }

    public void startHeartbeat() {
        if (this.isHeartbeatStarted || this.heartbeatOpts == null) {
            return;
        }
        log.info("heartbeat: start for {}/{}: failures = {}, interval = {}, death pings = {}", new Object[]{this.tag, this.index, this.failedPingsThreshold, this.heartbeatOpts.getPingInterval(), this.deathThreshold});
        this.isHeartbeatStarted = true;
        this.window.clear();
        this.window.addFirst(0);
        this.currentDeathPings = 0;
        this.currentFailedPings = 0;
        this.lastHeartbeatEvent = HeartbeatEvent.ACTIVATE;
        this.heartbeatTask = this.timerService.newTimeout(this::ping, this.heartbeatOpts.getPingInterval(), TimeUnit.MILLISECONDS);
    }

    public void stopHeartbeat() {
        this.isHeartbeatStarted = false;
        if (this.heartbeatTask != null) {
            this.heartbeatTask.cancel();
            this.heartbeatTask = null;
        }
    }

    private CompletableFuture<IProtoClient> internalConnect() {
        log.info("connect {}/{}", (Object)this.tag, (Object)this.index);
        LongTaskTimer.Sample timer = this.startTimer(this.connectTime);
        CompletableFuture future = this.client.connect(this.group.getAddress(), this.connectTimeout, this.gracefulShutdown);
        String user = this.group.getUser();
        this.connectFuture = ((CompletableFuture)((CompletableFuture)future.thenCompose(greeting -> {
            this.stopTimer(timer);
            if (user != null) {
                return this.client.authorize(user, this.group.getPassword(), this.group.getAuthType());
            }
            return this.client.ping(firstPingOpts);
        })).thenApply(r -> this.client)).whenComplete(this::onConnectComplete);
        return this.connectFuture;
    }

    private void onConnectComplete(Object r, Throwable exc) {
        if (this.metricsRegistry != null) {
            if (exc != null) {
                this.connectErrors.increment();
            } else {
                this.connectSuccess.increment();
            }
        }
        if (exc != null) {
            this.handleConnectError(r, exc);
            return;
        }
        this.startHeartbeat();
        this.unlock();
        log.info("connected {}/{}", (Object)this.tag, (Object)this.index);
    }

    private void handleConnectError(Object r, Throwable exc) {
        if (exc == null) {
            return;
        }
        if (exc.getCause() != null) {
            exc = exc.getCause();
        }
        this.connectFuture = null;
        log.error("connect error {}/{}: {}", new Object[]{this.tag, this.index, exc.toString()});
        this.lock();
        this.shutdown();
        this.connectAfter();
    }

    private void connectAfter() {
        log.info("reconnect {}/{} after {} ms", new Object[]{this.tag, this.index, this.reconnectAfter});
        if (this.reconnectTask == null) {
            this.reconnecting.incrementAndGet();
        }
        this.reconnectTask = this.timerService.newTimeout(timeout -> this.internalConnect(), this.reconnectAfter, TimeUnit.MILLISECONDS);
    }

    private void ping(Timeout handler) {
        this.lastPingTs = System.currentTimeMillis();
        LongTaskTimer.Sample timer = this.startTimer(this.heartbeatTime);
        this.pingFunction.apply(this.client, this.heartbeatPingOpts).whenComplete((r, exc) -> {
            this.stopTimer(timer);
            this.pong((IProtoResponse)r, (Throwable)exc);
        });
    }

    private void nextPing() {
        long delta = this.heartbeatOpts.getPingInterval() - (System.currentTimeMillis() - this.lastPingTs);
        if (delta <= 0L) {
            this.ping(null);
        } else {
            this.heartbeatTask = this.timerService.newTimeout(this::ping, delta, TimeUnit.MILLISECONDS);
        }
    }

    private void pong(IProtoResponse result, Throwable exc) {
        this.nextPing();
        int failure = 0;
        if (exc != null) {
            String msg;
            failure = 1;
            Throwable error = exc.getCause();
            if (error instanceof ConnectionException && (msg = error.getMessage()).startsWith("Connection")) {
                this.stopHeartbeat();
                return;
            }
        } else if (!result.isBodyEmpty() && !result.getBodyArrayValue(48).get(0).equals((Object)ImmutableBooleanValueImpl.TRUE)) {
            failure = 1;
        }
        this.incHeartbeatCounters(failure);
        this.window.addFirst(failure);
        this.currentFailedPings += failure;
        if (this.window.size() > this.windowSize) {
            this.currentFailedPings -= this.window.removeLast().intValue();
        } else if (this.window.size() < this.windowSize) {
            return;
        }
        if (this.currentFailedPings >= this.failedPingsThreshold) {
            this.fire(HeartbeatEvent.INVALIDATE);
            ++this.currentDeathPings;
            if (this.currentDeathPings > this.deathThreshold) {
                this.fire(HeartbeatEvent.KILL);
            }
            return;
        }
        this.fire(HeartbeatEvent.ACTIVATE);
        this.currentDeathPings = 0;
    }

    private void fire(HeartbeatEvent event) {
        if (this.lastHeartbeatEvent == event) {
            return;
        }
        this.lastHeartbeatEvent = event;
        switch (event) {
            case INVALIDATE: {
                this.lock();
                log.info("heartbeat: connection {}/{} is invalid", (Object)this.tag, (Object)this.index);
                break;
            }
            case ACTIVATE: {
                this.unlock();
                log.info("heartbeat: connection {}/{} is ok", (Object)this.tag, (Object)this.index);
                break;
            }
            case KILL: {
                this.shutdown();
                log.warn("heartbeat: close connection {}/{}", (Object)this.tag, (Object)this.index);
                this.connectAfter();
            }
        }
    }

    private void initMetrics() {
        if (this.metricsRegistry == null) {
            return;
        }
        this.heartbeatSuccess = this.metricsRegistry.get("pool.heartbeat.success").counter();
        this.heartbeatErrors = this.metricsRegistry.get("pool.heartbeat.errors").counter();
        this.heartbeatTime = this.metricsRegistry.get("pool.heartbeat.time").longTaskTimer();
        this.connectSuccess = this.metricsRegistry.get("pool.connect.success").counter();
        this.connectErrors = this.metricsRegistry.get("pool.connect.errors").counter();
        this.connectTime = this.metricsRegistry.get("pool.connect.time").longTaskTimer();
    }

    private LongTaskTimer.Sample startTimer(LongTaskTimer timer) {
        if (this.metricsRegistry == null) {
            return null;
        }
        return timer.start();
    }

    private void stopTimer(LongTaskTimer.Sample timer) {
        if (timer == null) {
            return;
        }
        timer.stop();
    }

    private void incHeartbeatCounters(int fail) {
        if (this.metricsRegistry == null || this.heartbeatSuccess == null || this.heartbeatErrors == null) {
            return;
        }
        if (fail != 0) {
            this.heartbeatErrors.increment();
        } else {
            this.heartbeatSuccess.increment();
        }
    }

    private void stopReconnectTask() {
        if (this.reconnectTask != null) {
            this.reconnecting.decrementAndGet();
            this.reconnectTask.cancel();
            this.reconnectTask = null;
        }
    }
}

