/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.mapping;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.tarantool.mapping.DatetimeExtensionModule;
import io.tarantool.mapping.DecimalExtensionModule;
import io.tarantool.mapping.Interval;
import io.tarantool.mapping.IntervalExtensionModule;
import io.tarantool.mapping.TarantoolDeserializer;
import io.tarantool.mapping.TupleExtensionModule;
import io.tarantool.mapping.UUIDExtensionModule;
import io.tarantool.mapping.Utils;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.UUID;
import org.msgpack.jackson.dataformat.MessagePackExtensionType;

public class UniversalExtensionModule {
    private static final ThreadLocal<StringBuilder> threadLocalStringBuilder;
    public static final SimpleModule INSTANCE;

    private UniversalExtensionModule() {
    }

    static {
        INSTANCE = new SimpleModule("msgpack-ext-any");
        INSTANCE.addDeserializer(Object.class, (JsonDeserializer)new ObjectDeserializer());
        threadLocalStringBuilder = ThreadLocal.withInitial(StringBuilder::new);
    }

    public static class ObjectDeserializer
    extends UntypedObjectDeserializer {
        private final HashMap<Byte, TarantoolDeserializer<?>> deserializers = new HashMap();

        public ObjectDeserializer() {
            super(null, null);
            this.deserializers.put((byte)1, new DecimalExtensionModule.BigDecimalDeserializer(BigDecimal.class));
            this.deserializers.put((byte)2, new UUIDExtensionModule.UUIDDeserializer(UUID.class));
            this.deserializers.put((byte)4, new DatetimeExtensionModule.ZonedDateTimeDeserializer(ZonedDateTime.class));
            this.deserializers.put((byte)6, new IntervalExtensionModule.IntervalDeserializer(Interval.class));
            this.deserializers.put((byte)7, new TupleExtensionModule.TupleDeserializer());
        }

        private boolean isExtensionValue(Object object) {
            return object instanceof MessagePackExtensionType;
        }

        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            if (p.currentTokenId() != 12 || !this.isExtensionValue(p.getEmbeddedObject())) {
                return super.deserialize(p, ctxt);
            }
            MessagePackExtensionType ext = (MessagePackExtensionType)p.readValueAs(MessagePackExtensionType.class);
            byte type = ext.getType();
            TarantoolDeserializer<?> res = this.deserializers.get(type);
            if (res == null) {
                StringBuilder sb = (StringBuilder)threadLocalStringBuilder.get();
                throw new IllegalStateException(sb.delete(0, ((StringBuilder)threadLocalStringBuilder.get()).length()).append("Deserializer for type Object is not found for 0x").append(Utils.byteToHex(type)).toString());
            }
            return res.deserialize(ext);
        }
    }
}

