/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.mapping;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Field {
    String name;
    String type;
    Boolean isNullable;
    String collation;
    Object constraint;
    Object foreignKey;

    public Field() {
    }

    public Field(String name, String type, Boolean isNullable, String collation, Object constraint, Object foreignKey) {
        this.name = name;
        this.type = type;
        this.isNullable = isNullable;
        this.collation = collation;
        this.constraint = constraint;
        this.foreignKey = foreignKey;
    }

    public String getName() {
        return this.name;
    }

    @JsonSetter(value="name")
    public Field setName(String name) {
        this.name = name;
        return this;
    }

    public String getType() {
        return this.type;
    }

    @JsonSetter(value="type")
    public Field setType(String type) {
        this.type = type;
        return this;
    }

    public Boolean isNullable() {
        if (this.isNullable == null) {
            return false;
        }
        return this.isNullable;
    }

    @JsonSetter(value="is_nullable")
    public Field setNullable(Boolean nullable) {
        this.isNullable = nullable;
        return this;
    }

    public String getCollation() {
        return this.collation;
    }

    @JsonSetter(value="collation")
    public Field setCollation(String collation) {
        this.collation = collation;
        return this;
    }

    public Object getConstraint() {
        return this.constraint;
    }

    @JsonSetter(value="constraint")
    public Field setConstraint(Object constraint) {
        this.constraint = constraint;
        return this;
    }

    public Object getForeignKey() {
        return this.foreignKey;
    }

    @JsonSetter(value="foreign_key")
    public Field setForeignKey(Object foreignKey) {
        this.foreignKey = foreignKey;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field field = (Field)o;
        if (!Objects.equals(this.name, field.name)) {
            return false;
        }
        if (!Objects.equals(this.type, field.type)) {
            return false;
        }
        if (!Objects.equals(this.isNullable, field.isNullable)) {
            return false;
        }
        if (!Objects.equals(this.collation, field.collation)) {
            return false;
        }
        if (!Objects.equals(this.constraint, field.constraint)) {
            return false;
        }
        return Objects.equals(this.foreignKey, field.foreignKey);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.isNullable != null ? this.isNullable.hashCode() : 0);
        result = 31 * result + (this.collation != null ? this.collation.hashCode() : 0);
        result = 31 * result + (this.constraint != null ? this.constraint.hashCode() : 0);
        result = 31 * result + (this.foreignKey != null ? this.foreignKey.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Field{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", isNullable=" + this.isNullable + ", collation='" + this.collation + '\'' + ", constraint=" + this.constraint + ", foreignKey=" + this.foreignKey + '}';
    }
}

